/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.ref.TextBooleanReference;
import net.openhft.chronicle.bytes.ref.TextIntArrayReference;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.Resettable;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextReadDocumentContext;
import net.openhft.chronicle.wire.TextStopCharTesters;
import net.openhft.chronicle.wire.TextStopCharsTesters;
import net.openhft.chronicle.wire.TextWriteDocumentContext;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueInStack;
import net.openhft.chronicle.wire.ValueInState;
import net.openhft.chronicle.wire.VanillaMethodReaderBuilder;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.YamlWire;
import net.openhft.chronicle.wire.YamlWireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWire
extends YamlWireOut<TextWire> {
    public static final BytesStore BINARY = BytesStore.from((String)"!!binary");
    @NotNull
    public static final Bytes<byte[]> TYPE_STR = Bytes.from((String)"type ");
    static final String SEQ_MAP = "!seqmap";
    static final BitSet END_CHARS = new BitSet();
    static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_QUOTES = new ThreadLocal();
    static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_SINGLE_QUOTES = new ThreadLocal();
    static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_END_OF_TEXT = new ThreadLocal();
    static final ThreadLocal<WeakReference<StopCharsTester>> STRICT_ESCAPED_END_OF_TEXT = new ThreadLocal();
    static final Pattern REGX_PATTERN = Pattern.compile("\\.|\\$");
    static final Supplier<StopCharTester> QUOTES_ESCAPING = () -> ((StopCharTesters)StopCharTesters.QUOTES).escaping();
    static final Supplier<StopCharTester> SINGLE_QUOTES_ESCAPING = () -> ((StopCharTesters)StopCharTesters.SINGLE_QUOTES).escaping();
    static final Supplier<StopCharTester> END_OF_TEXT_ESCAPING = () -> ((TextStopCharTesters)TextStopCharTesters.END_OF_TEXT).escaping();
    static final Supplier<StopCharsTester> STRICT_END_OF_TEXT_ESCAPING = () -> ((TextStopCharsTesters)TextStopCharsTesters.STRICT_END_OF_TEXT).escaping();
    static final Supplier<StopCharsTester> END_EVENT_NAME_ESCAPING = () -> ((TextStopCharsTesters)TextStopCharsTesters.END_EVENT_NAME).escaping();
    static final Bytes<?> META_DATA = Bytes.from((String)"!!meta-data");
    protected final TextValueIn valueIn = this.createValueIn();
    protected long lineStart = 0L;
    private DefaultValueIn defaultValueIn;
    protected WriteDocumentContext writeContext;
    protected ReadDocumentContext readContext;
    private boolean strict = false;

    public TextWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super((Bytes)bytes, use8bit);
    }

    public TextWire(@NotNull Bytes<?> bytes) {
        this(bytes, false);
    }

    @NotNull
    public static TextWire fromFile(String name) throws IOException {
        return new TextWire((Bytes<?>)BytesUtil.readFile((String)name), true);
    }

    @NotNull
    public static TextWire from(@NotNull String text) {
        return new TextWire(Bytes.from((String)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asText(@NotNull Wire wire) {
        NativeBytes bytes = NativeBytes.nativeBytes();
        try {
            long pos = wire.bytes().readPosition();
            @NotNull Wire tw = (Wire)WireType.TEXT.apply(bytes);
            wire.copyTo(tw);
            wire.bytes().readPosition(pos);
            String string = tw.toString();
            return string;
        }
        finally {
            bytes.releaseLast();
        }
    }

    public static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        for (int i = 0; i < length; ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case '0': {
                        ch = 0;
                        break;
                    }
                    case 'a': {
                        ch = 7;
                        break;
                    }
                    case 'b': {
                        ch = 8;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 'v': {
                        ch = 11;
                        break;
                    }
                    case 'f': {
                        ch = 12;
                        break;
                    }
                    case 'r': {
                        ch = 13;
                        break;
                    }
                    case 'e': {
                        ch = 27;
                        break;
                    }
                    case 'N': {
                        ch = 133;
                        break;
                    }
                    case '_': {
                        ch = 160;
                        break;
                    }
                    case 'L': {
                        ch = 8232;
                        break;
                    }
                    case 'P': {
                        ch = 8233;
                        break;
                    }
                    case 'x': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case 'u': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 4096 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 256 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            AppendableUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, (int)end);
    }

    @Nullable
    static StopCharTester getEscapingSingleQuotes() {
        StopCharTester sct = (StopCharTester)ThreadLocalHelper.getTL(ESCAPED_SINGLE_QUOTES, SINGLE_QUOTES_ESCAPING);
        sct.isStopChar(32);
        return sct;
    }

    public static <T> T load(String filename) throws IOException {
        return (T)TextWire.fromFile(filename).readObject();
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    public boolean strict() {
        return this.strict;
    }

    public TextWire strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    @Override
    @NotNull
    public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.TEXT, () -> this.newTextMethodWriterInvocationHandler(tClass));
        for (Class aClass : additional) {
            builder.addInterface(aClass);
        }
        this.useTextDocuments();
        builder.marshallableOut(this);
        return builder.build();
    }

    @NotNull
    TextMethodWriterInvocationHandler newTextMethodWriterInvocationHandler(Class ... interfaces) {
        for (Class anInterface : interfaces) {
            Comment c = anInterface.getAnnotation(Comment.class);
            if (c == null) continue;
            this.writeComment(c.value());
        }
        return new TextMethodWriterInvocationHandler(interfaces[0], this);
    }

    @Override
    @NotNull
    public <T> MethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder<T> text = new VanillaMethodWriterBuilder<T>(tClass, WireType.TEXT, () -> this.newTextMethodWriterInvocationHandler(tClass));
        text.marshallableOut(this);
        return text;
    }

    @Override
    @NotNull
    public VanillaMethodReaderBuilder methodReaderBuilder() {
        return super.methodReaderBuilder().wireType(WireType.TEXT);
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        if (this.writeContext == null) {
            this.useTextDocuments();
        }
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (this.writeContext != null && this.writeContext.isOpen() && this.writeContext.chainedElement()) {
            return this.writeContext;
        }
        return this.writingDocument(metaData);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.initReadContext();
        return this.readContext;
    }

    protected void initReadContext() {
        if (this.readContext == null) {
            this.useBinaryDocuments();
        }
        this.readContext.start();
    }

    @NotNull
    public TextWire useBinaryDocuments() {
        this.readContext = new BinaryReadDocumentContext(this, false);
        this.writeContext = new BinaryWriteDocumentContext(this);
        return this;
    }

    @NotNull
    public TextWire useTextDocuments() {
        this.readContext = new TextReadDocumentContext(this);
        this.writeContext = new TextWriteDocumentContext(this);
        return this;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.initReadContext();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @NotNull
    protected TextValueIn createValueIn() {
        return new TextValueIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.bytes.readRemaining() > 0x100000L) {
            long l = this.bytes.readLimit();
            try {
                this.bytes.readLimit(this.bytes.readPosition() + 0x100000L);
                String string = this.bytes + "..";
                return string;
            }
            finally {
                this.bytes.readLimit(l);
            }
        }
        return this.bytes.toString();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        if (!(wire instanceof TextWire) && !(wire instanceof YamlWire)) {
            throw new UnsupportedOperationException("Not implemented yet. Can only copy TextWire format to the same format  not " + wire.getClass());
        }
        Bytes<?> bytes0 = this.bytes();
        long length = bytes0.readRemaining();
        wire.bytes().write((BytesStore)this.bytes, bytes0.readPosition(), length);
        this.bytes.readSkip(length);
    }

    @Override
    public long readEventNumber() {
        StringBuilder stringBuilder = this.acquireStringBuilder();
        this.readField(stringBuilder);
        try {
            return StringUtils.parseInt((CharSequence)stringBuilder, (int)10);
        }
        catch (NumberFormatException ignored) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder());
        return this.valueIn;
    }

    @NotNull
    protected StringBuilder acquireStringBuilder() {
        StringUtils.setCount((StringBuilder)this.sb, (int)0);
        return this.sb;
    }

    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        try {
            int ch = this.peekCode();
            if (ch > 128 && ((ch & 0xC0) == 128 || (ch & 0xF0) == 240)) {
                throw new IllegalStateException("Attempting to read binary as TextWire ch=" + Integer.toHexString(ch));
            }
            if (ch < 0 || ch == 33 || ch == 91 || ch == 123) {
                sb.setLength(0);
                return sb;
            }
            if (ch == 63) {
                this.bytes.readSkip(1L);
                this.consumePadding();
                ch = this.peekCode();
            }
            if (ch == 34) {
                this.bytes.readSkip(1L);
                this.parseUntil(sb, this.getEscapingQuotes());
                this.consumePadding();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString() + " was " + (char)ch);
                }
            } else if (ch == 39) {
                this.bytes.readSkip(1L);
                this.parseUntil(sb, TextWire.getEscapingSingleQuotes());
                this.consumePadding();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString() + " was " + (char)ch);
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            TextWire.unescape(sb);
        }
        catch (BufferUnderflowException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        return sb;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) {
        this.consumePadding(0);
        @NotNull StringBuilder sb = this.acquireStringBuilder();
        try {
            int ch = this.peekCode();
            if (ch > 128 && ((ch & 0xC0) == 128 || (ch & 0xF0) == 240)) {
                throw new IllegalStateException("Attempting to read binary as TextWire ch=" + Integer.toHexString(ch));
            }
            if (ch == 63) {
                this.bytes.readSkip(1L);
                this.consumePadding();
                int ch3 = this.peekCode();
                @Nullable Object object = ch3 != 33 && expectedClass == Object.class ? this.valueIn.objectWithInferredType0(null, SerializationStrategies.ANY_SCALAR, this.defaultKeyClass()) : this.valueIn.object(expectedClass);
                this.consumePadding();
                int ch2 = this.readCode();
                if (ch2 != 58) {
                    throw new IllegalStateException("Unexpected character after field " + ch + " '" + (char)ch2 + "'");
                }
                return object;
            }
            if (ch == 91) {
                return this.valueIn.object(expectedClass);
            }
            if (ch == 34 || ch == 39) {
                this.bytes.readSkip(1L);
                StopCharTester escapingQuotes = ch == 34 ? this.getEscapingQuotes() : TextWire.getEscapingSingleQuotes();
                this.parseUntil(sb, escapingQuotes);
                this.consumePadding(1);
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return null;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            TextWire.unescape(sb);
        }
        catch (BufferUnderflowException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        return this.toExpected(expectedClass, sb);
    }

    protected Class defaultKeyClass() {
        return Object.class;
    }

    @Nullable
    private <K> K toExpected(Class<K> expectedClass, StringBuilder sb) {
        return (K)ObjectUtils.convertTo(expectedClass, (Object)WireInternal.INTERNER.intern((CharSequence)sb));
    }

    @NotNull
    protected StopCharTester getEscapingEndOfText() {
        StopCharTester escaping = (StopCharTester)ThreadLocalHelper.getTL(ESCAPED_END_OF_TEXT, END_OF_TEXT_ESCAPING);
        escaping.isStopChar(32);
        return escaping;
    }

    @NotNull
    protected StopCharsTester getStrictEscapingEndOfText() {
        StopCharsTester escaping = (StopCharsTester)ThreadLocalHelper.getTL(STRICT_ESCAPED_END_OF_TEXT, this.strictEndOfTextEscaping());
        escaping.isStopChar(32, 32);
        return escaping;
    }

    @NotNull
    protected Supplier<StopCharsTester> strictEndOfTextEscaping() {
        return STRICT_END_OF_TEXT_ESCAPING;
    }

    @NotNull
    protected StopCharsTester getEscapingEndEventName() {
        StopCharsTester escaping = (StopCharsTester)ThreadLocalHelper.getTL(STRICT_ESCAPED_END_OF_TEXT, END_EVENT_NAME_ESCAPING);
        escaping.isStopChar(32, 32);
        return escaping;
    }

    @Nullable
    protected StopCharTester getEscapingQuotes() {
        StopCharTester sct = (StopCharTester)ThreadLocalHelper.getTL(ESCAPED_QUOTES, QUOTES_ESCAPING);
        sct.isStopChar(32);
        return sct;
    }

    @Override
    public void consumePadding() {
        this.consumePadding(0);
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        return "todo";
    }

    public void consumePadding(int commas) {
        block6: while (true) {
            int codePoint = this.peekCode();
            switch (codePoint) {
                case 35: {
                    int ch;
                    this.readCode();
                    while (this.peekCode() == 32) {
                        this.readCode();
                    }
                    StringBuilder sb = WireInternal.acquireAnotherStringBuilder(this.sb);
                    while (this.notNewLine(ch = this.readCode())) {
                        sb.append((char)ch);
                    }
                    if (!this.valueIn.consumeAny) {
                        this.commentListener.accept(sb);
                    }
                    this.lineStart = this.bytes.readPosition();
                    continue block6;
                }
                case 44: {
                    if (this.valueIn.isASeparator(this.peekCodeNext()) && commas-- <= 0) {
                        return;
                    }
                    this.bytes.readSkip(1L);
                    if (commas != 0) continue block6;
                    return;
                }
                case 9: 
                case 32: {
                    this.bytes.readSkip(1L);
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.lineStart = this.bytes.readPosition() + 1L;
                    this.bytes.readSkip(1L);
                    continue block6;
                }
            }
            break;
        }
    }

    private boolean notNewLine(int readCode) {
        return readCode >= 0 && readCode != 13 && readCode != 10;
    }

    protected void consumeDocumentStart() {
        long pos;
        if (this.bytes.readRemaining() > 4L && this.bytes.readByte(pos = this.bytes.readPosition()) == 45 && this.bytes.readByte(pos + 1L) == 45 && this.bytes.readByte(pos + 2L) == 45) {
            String word;
            this.bytes.readSkip(3L);
            this.consumeWhiteSpace();
            pos = this.bytes.readPosition();
            switch (word = this.bytes.parseUtf8((StopCharTester)StopCharTesters.SPACE_STOP)) {
                case "!!data": 
                case "!!data-not-ready": 
                case "!!meta-data": 
                case "!!meta-data-not-ready": {
                    break;
                }
                default: {
                    this.bytes.readPosition(pos);
                }
            }
        }
    }

    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    int peekCodeNext() {
        return this.bytes.peekUnsignedByte(this.bytes.readPosition() + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    protected int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.read(key.name(), key.code(), key.defaultValue());
    }

    private ValueIn read(@NotNull CharSequence keyName, int keyCode, Object defaultValue) {
        this.consumePadding();
        ValueInState curr = this.valueIn.curr();
        StringBuilder stringBuilder = this.acquireStringBuilder();
        if (curr.savedPosition() > 0L) {
            this.bytes.readPosition(curr.savedPosition() - 1L);
            curr.savedPosition(0L);
        }
        while (this.bytes.readRemaining() > 0L) {
            long position = this.bytes.readPosition();
            this.readField(stringBuilder);
            curr = this.valueIn.curr();
            if (StringUtils.equalsCaseIgnore((CharSequence)stringBuilder, (CharSequence)keyName)) {
                return this.valueIn;
            }
            if (stringBuilder.length() == 0) {
                if (curr.unexpectedSize() > 0) break;
                return this.valueIn;
            }
            curr.addUnexpected(position);
            long toSkip = this.valueIn.readLengthMarshallable();
            this.bytes.readSkip(toSkip);
            this.consumePadding(1);
        }
        return this.read2(keyName, keyCode, defaultValue, curr, stringBuilder, keyName);
    }

    protected ValueIn read2(CharSequence keyName, int keyCode, Object defaultValue, @NotNull ValueInState curr, @NotNull StringBuilder sb, @NotNull CharSequence name) {
        long position2 = this.bytes.readPosition();
        for (int i = 0; i < curr.unexpectedSize(); ++i) {
            this.bytes.readPosition(curr.unexpected(i));
            this.readField(sb);
            if (sb.length() != 0 && !StringUtils.equalsCaseIgnore((CharSequence)sb, (CharSequence)name)) continue;
            curr.removeUnexpected(i);
            curr.savedPosition(position2 + 1L);
            return this.valueIn;
        }
        this.bytes.readPosition(position2);
        if (this.defaultValueIn == null) {
            this.defaultValueIn = new DefaultValueIn(this);
        }
        this.defaultValueIn.defaultValue = defaultValue;
        return this.defaultValueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumePadding();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        this.consumeWhiteSpace();
        if (this.peekCode() == 35) {
            this.bytes.readSkip(1L);
            this.consumeWhiteSpace();
            this.bytes.parseUtf8((Appendable)s, (StopCharTester)StopCharTesters.CONTROL_STOP);
        }
        return this;
    }

    public void consumeWhiteSpace() {
        while (Character.isWhitespace(this.peekCode())) {
            this.bytes.readSkip(1L);
        }
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.valueIn.resetState();
        this.valueOut.resetState();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        return new TextBooleanReference();
    }

    @Override
    public boolean useSelfDescribingMessage(@NotNull CommonMarshallable object) {
        return true;
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        return new TextIntArrayReference();
    }

    public void parseWord(@NotNull StringBuilder sb) {
        this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
    }

    public void parseUntil(@NotNull StringBuilder sb, @NotNull StopCharTester testers) {
        if (this.use8bit) {
            this.bytes.parse8bit((Appendable)sb, testers);
        } else {
            this.bytes.parseUtf8((Appendable)sb, testers);
        }
    }

    public void parseUntil(@NotNull StringBuilder sb, @NotNull StopCharsTester testers) {
        sb.setLength(0);
        if (this.use8bit) {
            AppendableUtil.read8bitAndAppend((StreamingDataInput)this.bytes, (StringBuilder)sb, (StopCharsTester)testers);
        } else {
            AppendableUtil.readUTFAndAppend((StreamingDataInput)this.bytes, (Appendable)sb, (StopCharsTester)testers);
        }
    }

    @Nullable
    public Object readObject() {
        this.consumePadding();
        this.consumeDocumentStart();
        return this.getValueIn().object(Object.class);
    }

    @Nullable
    Object readObject(int indentation) {
        this.consumePadding();
        int code = this.peekCode();
        int indentation2 = this.indentation();
        if (indentation2 < indentation) {
            return NoObject.NO_OBJECT;
        }
        switch (code) {
            case 45: {
                if (this.peekCodeNext() == 45) {
                    return NoObject.NO_OBJECT;
                }
                return this.readList(indentation2, null);
            }
            case 91: {
                return this.readList();
            }
            case 123: {
                return this.valueIn.marshallableAsMap(Object.class, Object.class);
            }
            case 33: {
                return this.readTypedObject();
            }
        }
        return this.readMap(indentation2, null);
    }

    private int indentation() {
        long pos = this.bytes.readPosition();
        if (pos < this.lineStart) {
            this.lineStart = pos;
            return 0;
        }
        return Maths.toInt32((long)(pos - this.lineStart));
    }

    @Nullable
    private Object readTypedObject() {
        return this.valueIn.object(Object.class);
    }

    @NotNull
    private List readList() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    List readList(int indentation, Class elementType) {
        @NotNull ArrayList<Object> objects = new ArrayList<Object>();
        while (this.peekCode() == 45 && this.indentation() >= indentation && this.peekCodeNext() != 45) {
            long ls = this.lineStart;
            this.bytes.readSkip(1L);
            this.consumePadding();
            if (this.lineStart == ls) {
                objects.add(this.valueIn.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, elementType));
            } else {
                @Nullable Object e = this.readObject(indentation);
                if (e != NoObject.NO_OBJECT) {
                    objects.add(e);
                }
            }
            this.consumePadding(1);
        }
        return objects;
    }

    @NotNull
    private Map readMap(int indentation, Class valueType) {
        @NotNull LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuilder sb = WireInternal.acquireAnotherStringBuilder(this.acquireStringBuilder());
        this.consumePadding();
        while (this.bytes.readRemaining() > 0L && this.indentation() >= indentation && this.bytes.readRemaining() != 0L) {
            this.read(sb);
            @Nullable String key = WireInternal.INTERNER.intern((CharSequence)sb);
            if (key.equals("...")) break;
            @Nullable Object value = this.valueIn.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, valueType);
            map.put(key, value);
            this.consumePadding(1);
        }
        return map;
    }

    @Override
    public void reset() {
        this.writeContext.reset();
        this.readContext.reset();
        this.sb.setLength(0);
        this.lineStart = 0L;
        this.valueIn.resetState();
        this.valueOut.resetState();
        this.bytes.clear();
    }

    @Override
    public boolean hasMetaDataPrefix() {
        if (this.bytes.startsWith(META_DATA) && this.bytes.peekUnsignedByte(this.bytes.readPosition() + 11L) <= 32) {
            this.bytes.readSkip(12L);
            return true;
        }
        return false;
    }

    @Override
    public boolean writingIsComplete() {
        return !this.writeContext.isNotComplete();
    }

    static {
        IOTools.unmonitor((Object)BINARY);
        for (char ch : "#:}]".toCharArray()) {
            END_CHARS.set(ch);
        }
        WireInternal.INTERNER.valueCount();
    }

    public class TextValueIn
    implements ValueIn {
        final ValueInStack stack = new ValueInStack();
        int sequenceLimit = 0;
        private boolean consumeAny;

        @Override
        public void resetState() {
            this.stack.reset();
        }

        public void pushState() {
            this.stack.push();
        }

        public void popState() {
            this.stack.pop();
        }

        public ValueInState curr() {
            return this.stack.curr();
        }

        @Override
        @Nullable
        public String text() {
            @Nullable CharSequence cs = this.textTo0(TextWire.this.acquireStringBuilder());
            return cs == null ? null : WireInternal.INTERNER.intern(cs);
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            sb.setLength(0);
            @Nullable CharSequence cs = this.textTo0(sb);
            if (cs == null) {
                return null;
            }
            if (cs != sb) {
                sb.setLength(0);
                sb.append(cs);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> bytes) {
            bytes.clear();
            @Nullable CharSequence cs = this.textTo0((Appendable & CharSequence)bytes);
            TextWire.this.consumePadding(1);
            if (cs == null) {
                return null;
            }
            if (cs != bytes) {
                bytes.clear();
                bytes.writeUtf8(cs);
            }
            return bytes;
        }

        @Override
        @NotNull
        public BracketType getBracketType() {
            TextWire.this.consumePadding();
            switch (TextWire.this.peekCode()) {
                case 123: {
                    return BracketType.MAP;
                }
                case 91: {
                    return BracketType.SEQ;
                }
            }
            return BracketType.NONE;
        }

        @Nullable
        <ACS extends Appendable & CharSequence> CharSequence textTo0(@NotNull ACS a) {
            TextWire.this.consumePadding();
            int ch = TextWire.this.peekCode();
            @Nullable CharSequence ret = a;
            switch (ch) {
                case 123: {
                    long len = this.readLength();
                    try {
                        a.append(Bytes.toString((Bytes)TextWire.this.bytes, (long)TextWire.this.bytes.readPosition(), (long)len));
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                    TextWire.this.bytes.readSkip(len);
                    TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                    return a;
                }
                case 34: {
                    this.readText(a, TextWire.this.getEscapingQuotes());
                    break;
                }
                case 39: {
                    this.readText(a, TextWire.getEscapingSingleQuotes());
                    break;
                }
                case 33: {
                    TextWire.this.bytes.readSkip(1L);
                    StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                    TextWire.this.parseWord(stringBuilder);
                    if (StringUtils.isEqual((StringBuilder)stringBuilder, (CharSequence)"!null")) {
                        this.textTo(stringBuilder);
                        ret = null;
                        break;
                    }
                    if (a instanceof StringBuilder) {
                        this.textTo((StringBuilder)a);
                        break;
                    }
                    this.textTo(stringBuilder);
                    ret = stringBuilder;
                    break;
                }
                case -1: {
                    return "";
                }
                case 36: {
                    if (TextWire.this.peekCodeNext() == 123) {
                        this.unsubstitutedString(a);
                        return a;
                    }
                }
                default: {
                    long rem = TextWire.this.bytes.readRemaining();
                    if (rem > 0L) {
                        if (a instanceof Bytes) {
                            TextWire.this.bytes.parse8bit((Bytes)a, TextWire.this.getStrictEscapingEndOfText());
                        } else if (TextWire.this.use8bit) {
                            TextWire.this.bytes.parse8bit((StringBuilder)a, TextWire.this.getStrictEscapingEndOfText());
                        } else {
                            TextWire.this.bytes.parseUtf8(a, TextWire.this.getStrictEscapingEndOfText());
                        }
                        if (rem == TextWire.this.bytes.readRemaining()) {
                            throw new IORuntimeException("Nothing to read at " + TextWire.this.bytes.toDebugString(32L));
                        }
                    } else {
                        AppendableUtil.setLength(a, (int)0);
                    }
                    while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                        AppendableUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                    }
                    break block1;
                }
            }
            int prev = this.peekBack();
            if (END_CHARS.get(prev)) {
                TextWire.this.bytes.readSkip(-1L);
            }
            return ret;
        }

        private <ACS extends Appendable & CharSequence> void unsubstitutedString(@NotNull ACS a) {
            char c;
            String text = TextWire.this.bytes.toString();
            if (text.length() > 32) {
                text = text.substring(0, 32);
            }
            Jvm.warn().on(this.getClass(), "Found an unsubstituted ${} as " + text);
            do {
                c = TextWire.this.bytes.readChar();
                try {
                    a.append(c);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            } while (!TextWire.this.bytes.isEmpty() && c != '}');
        }

        private <ACS extends Appendable & CharSequence> void readText(@NotNull ACS a, @NotNull StopCharTester quotes) {
            TextWire.this.bytes.readSkip(1L);
            if (TextWire.this.use8bit) {
                TextWire.this.bytes.parse8bit(a, quotes);
            } else {
                TextWire.this.bytes.parseUtf8(a, quotes);
            }
            TextWire.unescape(a);
            TextWire.this.consumePadding(1);
        }

        protected int peekBack() {
            while (TextWire.this.bytes.readPosition() > TextWire.this.bytes.start()) {
                int prev = TextWire.this.bytes.readUnsignedByte(TextWire.this.bytes.readPosition() - 1L);
                if (prev != 32) {
                    if (prev == 10 || prev == 13) {
                        TextWire.this.lineStart = TextWire.this.bytes.readPosition();
                    }
                    return prev;
                }
                TextWire.this.bytes.readSkip(-1L);
            }
            return -1;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes) {
            toBytes.clear();
            return this.bytes(b -> {
                Bytes cfr_ignored_0 = (Bytes)toBytes.write((BytesStore)b);
            });
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            return this.bytes(bytes -> {
                long capacity = bytes.readRemaining();
                VanillaBytes bytes2 = Bytes.allocateDirect((long)capacity);
                bytes2.write((BytesStore)bytes);
                toBytes.set(bytes2.addressForRead(bytes2.start()), capacity);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            TextWire.this.consumePadding();
            try {
                @NotNull StringBuilder sb = TextWire.this.acquireStringBuilder();
                if (TextWire.this.peekCode() == 33) {
                    TextWire.this.bytes.readSkip(1L);
                    TextWire.this.parseWord(sb);
                    @Nullable byte[] uncompressed = Compression.uncompress((CharSequence)sb, (Object)TextWire.this, t -> {
                        @NotNull StringBuilder sb2 = TextWire.this.acquireStringBuilder();
                        AppendableUtil.setLength((Appendable)sb2, (int)0);
                        t.parseUntil(sb2, (StopCharTester)StopCharTesters.COMMA_SPACE_STOP);
                        return Base64.getDecoder().decode(sb2.toString());
                    });
                    if (uncompressed != null) {
                        bytesConsumer.readMarshallable((BytesIn)Bytes.wrapForRead((byte[])uncompressed));
                    } else {
                        if (!StringUtils.isEqual((StringBuilder)sb, (CharSequence)"!null")) throw new IORuntimeException("Unsupported type=" + sb);
                        bytesConsumer.readMarshallable(null);
                        TextWire.this.parseWord(sb);
                    }
                } else {
                    this.textTo(sb);
                    bytesConsumer.readMarshallable((BytesIn)Bytes.wrapForRead((byte[])sb.toString().getBytes(StandardCharsets.ISO_8859_1)));
                }
                TextWire textWire = TextWire.this;
                return textWire;
            }
            finally {
                TextWire.this.consumePadding(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] bytes(byte[] using) {
            TextWire.this.consumePadding();
            try {
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                if (TextWire.this.peekCode() == 33) {
                    byte[] bytes;
                    TextWire.this.bytes.readSkip(1L);
                    TextWire.this.parseWord(stringBuilder);
                    if ("byte[]".contentEquals(stringBuilder)) {
                        TextWire.this.bytes.readSkip(1L);
                        TextWire.this.parseWord(stringBuilder);
                    }
                    if ((bytes = Compression.uncompress((CharSequence)stringBuilder, (Object)this, t -> {
                        @NotNull StringBuilder sb0 = TextWire.this.acquireStringBuilder();
                        TextWire.this.parseUntil(sb0, (StopCharTester)StopCharTesters.COMMA_SPACE_STOP);
                        return Base64.getDecoder().decode(WireInternal.INTERNER.intern((CharSequence)sb0));
                    })) != null) {
                        byte[] byArray = bytes;
                        return byArray;
                    }
                    if ("!null".contentEquals(stringBuilder)) {
                        TextWire.this.parseWord(stringBuilder);
                        byte[] byArray = null;
                        return byArray;
                    }
                    throw new IllegalStateException("unsupported type=" + stringBuilder);
                }
                this.textTo(stringBuilder);
                if (using != null && stringBuilder.length() == using.length) {
                    for (int i = 0; i < using.length; ++i) {
                        using[i] = (byte)stringBuilder.charAt(i);
                    }
                    byte[] byArray = using;
                    return byArray;
                }
                byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
                return byArray;
            }
            finally {
                TextWire.this.consumePadding(1);
            }
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return TextWire.this;
        }

        @Override
        public long readLength() {
            return this.readLengthMarshallable();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            this.consumeAny();
            if (TextWire.this.peekCode() == 44) {
                TextWire.this.bytes.readSkip(1L);
            }
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long readLengthMarshallable() {
            long start = TextWire.this.bytes.readPosition();
            this.consumeAny = true;
            try {
                this.consumeAny();
                long l = TextWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                this.consumeAny = false;
                TextWire.this.bytes.readPosition(start);
            }
        }

        protected void consumeAny() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            switch (code) {
                case 36: {
                    TextWire.this.bytes.readSkip(1L);
                    if (TextWire.this.peekCode() != 123) break;
                    TextWire.this.bytes.parse8bit((StopCharTester)StopCharTesters.CURLY_STOP);
                    break;
                }
                case 123: {
                    this.consumeMap();
                    break;
                }
                case 91: {
                    this.consumeSeq();
                    break;
                }
                case 125: {
                    break;
                }
                case 93: {
                    break;
                }
                case 63: {
                    TextWire.this.bytes.readSkip(1L);
                    this.consumeAny();
                    if (TextWire.this.peekCode() != 58) break;
                    TextWire.this.bytes.readSkip(1L);
                    this.consumeAny();
                    break;
                }
                case 33: {
                    this.consumeType2();
                    break;
                }
                default: {
                    this.consumeValue();
                    while (this.peekBack() <= 32 && TextWire.this.bytes.readPosition() >= 0L) {
                        TextWire.this.bytes.readSkip(-1L);
                    }
                    if (this.peekBack() == 44) {
                        TextWire.this.bytes.readSkip(-1L);
                        break;
                    }
                    TextWire.this.consumePadding();
                    if (TextWire.this.peekCode() != 58 || !this.isASeparator(TextWire.this.peekCodeNext())) break;
                    TextWire.this.readCode();
                    this.consumeAny();
                }
            }
        }

        protected boolean isASeparator(int nextChar) {
            return TextStopCharsTesters.isASeparator(nextChar);
        }

        private void consumeType2() {
            TextWire.this.bytes.readSkip(1L);
            boolean type = TextWire.this.bytes.startsWith(TYPE_STR);
            if (type) {
                TextWire.this.bytes.readSkip((long)TYPE_STR.length());
            }
            while (!TextStopCharTesters.END_OF_TYPE.isStopChar(TextWire.this.peekCode())) {
                TextWire.this.bytes.readSkip(1L);
            }
            if (TextWire.this.peekCode() == 59) {
                TextWire.this.bytes.readSkip(1L);
            }
            if (!type) {
                this.consumeAny();
            }
        }

        private void consumeSeq() {
            block2: {
                long pos;
                TextWire.this.bytes.readSkip(1L);
                do {
                    pos = TextWire.this.bytes.readPosition();
                    this.consumeAny();
                    if (TextWire.this.peekCode() != 44 || !this.isASeparator(TextWire.this.peekCodeNext())) break block2;
                    TextWire.this.readCode();
                } while (TextWire.this.bytes.readPosition() != pos);
                throw new IllegalStateException("Stuck at pos " + pos + " " + TextWire.this.bytes);
            }
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (code != 93) {
                TextWire.this.bytes.readSkip(-1L);
                throw new IllegalStateException("Expected a ] was " + TextWire.this.bytes);
            }
        }

        private void consumeMap() {
            block2: {
                long pos;
                TextWire.this.bytes.readSkip(1L);
                do {
                    pos = TextWire.this.bytes.readPosition();
                    this.consumeAny();
                    int code2 = TextWire.this.peekCode();
                    if (code2 == 125 || code2 == 93 || code2 <= 0) break block2;
                    if (code2 != 44 || !this.isASeparator(TextWire.this.peekCodeNext())) continue;
                    TextWire.this.readCode();
                } while (TextWire.this.bytes.readPosition() != pos);
                throw new IllegalStateException("Stuck at pos " + pos + " " + TextWire.this.bytes);
            }
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (code != 125) {
                TextWire.this.bytes.readSkip(-1L);
                throw new IllegalStateException("Expected a } was " + (char)code);
            }
        }

        private void consumeValue() {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.parseWord(stringBuilder);
                if (StringUtils.isEqual((StringBuilder)stringBuilder, (CharSequence)"type")) {
                    this.consumeType();
                } else {
                    this.consumeAny();
                }
            } else {
                this.textTo(stringBuilder);
            }
        }

        private void consumeType() {
            TextWire.this.parseUntil(TextWire.this.acquireStringBuilder(), (StopCharTester)StopCharTesters.COMMA_SPACE_STOP);
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                tFlag.accept(t, null);
                return TextWire.this;
            }
            tFlag.accept(t, Boolean.valueOf(StringUtils.isEqual((StringBuilder)stringBuilder, (CharSequence)"true")));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            TextWire.this.consumePadding();
            tb.accept(t, (byte)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return TextWire.this;
        }

        long getALong() {
            int code = TextWire.this.peekCode();
            switch (code) {
                case 34: 
                case 39: {
                    TextWire.this.bytes.readSkip(1L);
                    break;
                }
                case 70: 
                case 84: 
                case 102: 
                case 116: {
                    return this.bool() ? 1L : 0L;
                }
                case 36: {
                    this.unsubstitutedNumber();
                    return 0L;
                }
                case 91: 
                case 123: {
                    throw new IORuntimeException("Cannot read a " + (char)code + " as a number");
                }
            }
            return TextWire.this.bytes.parseLong();
        }

        private void unsubstitutedNumber() {
            String s = TextWire.this.bytes.parse8bit((StopCharTester)StopCharTesters.CURLY_STOP);
            Jvm.warn().on(this.getClass(), "Cannot read " + s + "} as a number, treating as 0");
            if (",\n ".indexOf(TextWire.this.peekCode()) < 0) {
                throw new IllegalStateException("Unable to continue after ${} in number.");
            }
            TextWire.this.bytes.readSkip(1L);
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            TextWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            TextWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            TextWire.this.consumePadding();
            if (TextWire.this.peekCode() == 36) {
                this.unsubstitutedNumber();
            } else {
                tf.accept(t, (float)TextWire.this.bytes.parseDouble());
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            TextWire.this.consumePadding();
            if (TextWire.this.peekCode() == 36) {
                this.unsubstitutedNumber();
            } else {
                td.accept(t, TextWire.this.bytes.parseDouble());
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            setLocalTime.accept(t, LocalTime.parse(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tZonedDateTime.accept(t, ZonedDateTime.parse(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tLocalDate.accept(t, LocalDate.parse(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tuuid.accept(t, UUID.fromString(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            TextWire.this.consumePadding();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
            }
            @NotNull Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength((BytesStore)TextWire.this.bytes, (long)TextWire.this.bytes.readPosition());
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            setter.accept(t, values);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            TextWire.this.consumePadding();
            @NotNull Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            TextWire.this.consumePadding();
            @NotNull Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        public WireIn bool(@NotNull BooleanValue value) {
            TextWire.this.consumePadding();
            @NotNull Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            TextWire.this.consumePadding();
            if (!(value instanceof TextIntReference)) {
                value = new TextIntReference();
                setter.accept(t, value);
            }
            @Nullable Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.peekCode();
            if (code == '!') {
                @Nullable Class typePrefix = this.typePrefix();
                if (typePrefix == Void.TYPE) {
                    this.text();
                    return false;
                }
                TextWire.this.consumePadding();
                code = (char)TextWire.this.readCode();
            }
            if (code == '[') {
                TextWire.this.bytes.readSkip(1L);
                this.sequenceLimit = Integer.MAX_VALUE;
            } else {
                this.sequenceLimit = 1;
            }
            tReader.accept(t, TextWire.this.valueIn);
            if (code == '[') {
                TextWire.this.consumePadding(1);
                char code2 = (char)TextWire.this.readCode();
                if (code2 != ']') {
                    throw new IORuntimeException("Expected a ] but got " + code2 + " (" + code2 + ")");
                }
            }
            TextWire.this.consumePadding(1);
            return true;
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) {
            return this.sequence(list, buffer, bufferAdd);
        }

        @Override
        public <T> boolean sequence(@NotNull List<T> list, @NotNull List<T> buffer, @NotNull Supplier<T> bufferAdd) {
            list.clear();
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.peekCode();
            if (code == '!') {
                @Nullable Class typePrefix = this.typePrefix();
                if (typePrefix == Void.TYPE) {
                    this.text();
                    return false;
                }
                TextWire.this.consumePadding();
                code = (char)TextWire.this.readCode();
            }
            if (code == '[') {
                TextWire.this.bytes.readSkip(1L);
                this.sequenceLimit = Integer.MAX_VALUE;
            } else {
                this.sequenceLimit = 1;
            }
            while (this.hasNextSequenceItem()) {
                T t;
                int size = list.size();
                if (buffer.size() <= size) {
                    buffer.add(bufferAdd.get());
                }
                if ((t = buffer.get(size)) instanceof Resettable) {
                    ((Resettable)t).reset();
                }
                list.add(this.object(t, t.getClass()));
            }
            if (code == '[') {
                TextWire.this.consumePadding(1);
                char code2 = (char)TextWire.this.readCode();
                if (code2 != ']') {
                    throw new IORuntimeException("Expected a ] but got " + code2 + " (" + code2 + ")");
                }
            }
            TextWire.this.consumePadding(1);
            return true;
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.peekCode();
            if (code == '[') {
                TextWire.this.bytes.readSkip(1L);
                this.sequenceLimit = Integer.MAX_VALUE;
            } else {
                this.sequenceLimit = 1;
            }
            TextWire.this.consumePadding();
            char code2 = (char)TextWire.this.peekCode();
            if (code2 == ']') {
                TextWire.this.readCode();
            } else {
                tReader.accept(t, kls, TextWire.this.valueIn);
                if (code == '[') {
                    TextWire.this.consumePadding();
                    char code3 = (char)TextWire.this.readCode();
                    if (code3 != ']') {
                        throw new IORuntimeException("Expected a ] but got " + code3 + " (" + code3 + ")");
                    }
                }
            }
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        public boolean hasNext() {
            TextWire.this.consumePadding();
            return TextWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            if (this.sequenceLimit-- <= 0) {
                return false;
            }
            TextWire.this.consumePadding();
            int ch = TextWire.this.peekCode();
            if (ch == 44) {
                TextWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            boolean endsNormally = false;
            try {
                long newLimit = position - 1L + len;
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                T apply = marshallableReader.apply(TextWire.this);
                endsNormally = true;
                T t = apply;
                return t;
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.consumePadding(1);
                code = TextWire.this.readCode();
                this.popState();
                if (code != 125 && endsNormally) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toString((Bytes)TextWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            stringBuilder.setLength(0);
            if (code == -1) {
                stringBuilder.append("java.lang.Object");
            } else if (code == 33) {
                TextWire.this.readCode();
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.bytes.readSkip(-1L);
                TextWire.this.consumePadding();
            }
            return this;
        }

        @Override
        public Class typePrefix() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33 || code == 64) {
                TextWire.this.readCode();
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                stringBuilder.setLength(0);
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.bytes.readSkip(-1L);
                try {
                    return this.classLookup().forName((CharSequence)stringBuilder);
                }
                catch (ClassNotFoundRuntimeException e) {
                    Jvm.warn().on(this.getClass(), "Unable to find " + stringBuilder + " " + e.getCause());
                    return null;
                }
            }
            return null;
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                TextWire.this.readCode();
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                stringBuilder.setLength(0);
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.bytes.readSkip(-1L);
                try {
                    return this.classLookup().forName((CharSequence)stringBuilder);
                }
                catch (ClassNotFoundRuntimeException e) {
                    if (tClass == null) {
                        if (Wires.GENERATE_TUPLES) {
                            return Wires.tupleFor(null, stringBuilder.toString());
                        }
                        Jvm.warn().on(TextWire.class, "Unable to load " + stringBuilder + ", is a class alias missing.");
                        return null;
                    }
                    String className = tClass.getName();
                    String[] split = REGX_PATTERN.split(stringBuilder);
                    if (split[split.length - 1].equalsIgnoreCase(tClass.getSimpleName())) {
                        try {
                            return tClass.isInterface() ? Wires.tupleFor(tClass, stringBuilder.toString()) : this.classLookup().forName((CharSequence)className);
                        }
                        catch (ClassNotFoundRuntimeException e1) {
                            Jvm.warn().on(this.getClass(), "ClassNotFoundException class=" + className);
                            return Wires.tupleFor(tClass, className);
                        }
                    }
                    if (tClass.getClassLoader() == null) {
                        throw new IllegalArgumentException("Unable to find class " + stringBuilder);
                    }
                    return Wires.tupleFor(tClass, stringBuilder.toString());
                }
            }
            return Wires.dtoInterface(tClass) && Wires.GENERATE_TUPLES && ObjectUtils.implementationToUse((Class)tClass) == tClass ? Wires.tupleFor(tClass, null) : null;
        }

        @Override
        public boolean isTyped() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            return code == 33;
        }

        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (!TextWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            TextWire.this.bytes.readSkip((long)"type ".length());
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
            classNameConsumer.accept(t, stringBuilder);
            return TextWire.this;
        }

        @Override
        public ClassLookup classLookup() {
            return TextWire.this.classLookup();
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (!TextWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            TextWire.this.bytes.readSkip((long)"type ".length());
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
            try {
                return this.classLookup().forName((CharSequence)stringBuilder);
            }
            catch (ClassNotFoundRuntimeException e) {
                return unresolvedHandler.apply(stringBuilder, e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            long position0 = TextWire.this.bytes.readPosition();
            if (this.isNull()) {
                TextWire.this.consumePadding(1);
                return null;
            }
            if (TextWire.this.indentation() == 0 && TextWire.this.peekCode() != 123) {
                strategy.readUsing(null, object, this, BracketType.UNKNOWN);
                return object;
            }
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.typePrefix(null, (o, x) -> {});
            } else {
                if (code == 44) {
                    Jvm.warn().on(this.getClass(), "Expected a {} but was blank for type " + object.getClass());
                    TextWire.this.readCode();
                    return object;
                }
                if (code != 123) {
                    this.consumeValue();
                    long position00 = TextWire.this.bytes.readPosition();
                    String s = ((Bytes)TextWire.this.bytes.readPosition(position0)).toDebugString(128L);
                    TextWire.this.bytes.readPosition(position00);
                    throw new IORuntimeException("Trying to read marshallable " + object.getClass() + " at " + s + " expected to find a {");
                }
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                object = strategy.readUsing(null, object, this, BracketType.MAP);
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            TextWire.this.consumePadding(1);
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString((Bytes)TextWire.this.bytes, (long)1024L));
            }
            TextWire.this.consumePadding(1);
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Demarshallable demarshallable(@NotNull Class clazz) {
            Object object;
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.typePrefix(null, (o, x) -> {});
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + this.stringForCode(code));
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                object = Demarshallable.newInstance(clazz, TextWire.this);
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            TextWire.this.consumePadding(1);
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString((Bytes)TextWire.this.bytes, (long)1024L));
            }
            return object;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() {
            return (T)this.objectWithInferredType(null, SerializationStrategies.ANY_NESTED, null);
        }

        @Nullable
        <K, V> Map<K, V> map(@NotNull Class<K> kClass, @NotNull Class<V> vClass, @Nullable Map<K, V> usingMap) {
            TextWire.this.consumePadding();
            if (usingMap == null) {
                usingMap = new LinkedHashMap();
            } else {
                usingMap.clear();
            }
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            int code = TextWire.this.peekCode();
            switch (code) {
                case 33: {
                    return this.typedMap(kClass, vClass, usingMap, stringBuilder);
                }
                case 123: {
                    return this.marshallableAsMap(kClass, vClass, usingMap);
                }
                case 63: {
                    return TextWire.this.readAllAsMap(kClass, vClass, usingMap);
                }
            }
            throw new IORuntimeException("Unexpected code " + (char)code);
        }

        @Nullable
        private <K, V> Map<K, V> typedMap(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap, @NotNull StringBuilder sb) {
            TextWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
            @Nullable String str = WireInternal.INTERNER.intern((CharSequence)sb);
            if ("!!null".contentEquals(sb)) {
                this.text();
                return null;
            }
            if ("!!seqmap".contentEquals(sb)) {
                TextWire.this.consumePadding();
                int start = TextWire.this.readCode();
                if (start != 91) {
                    throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                }
                do {
                    this.marshallable((WireIn r) -> {
                        @Nullable E k = r.read(() -> "key").object(kClazz);
                        @Nullable @Nullable E v = r.read(() -> "value").object(vClass);
                        usingMap.put(k, v);
                    });
                } while (this.hasNextSequenceItem());
                return usingMap;
            }
            throw new IORuntimeException("Unsupported type :" + str);
        }

        @Override
        public boolean bool() {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                throw new NullPointerException("value is null");
            }
            if (ObjectUtils.isTrue((CharSequence)stringBuilder)) {
                return true;
            }
            if (ObjectUtils.isFalse((CharSequence)stringBuilder)) {
                return false;
            }
            Jvm.debug().on(this.getClass(), "Unable to parse '" + stringBuilder + "' as a boolean flag, assuming false");
            return false;
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            TextWire.this.consumePadding();
            TextWire.this.valueIn.skipType();
            switch (TextWire.this.peekCode()) {
                case 91: 
                case 123: {
                    Jvm.warn().on(this.getClass(), "Unable to read " + TextWire.this.valueIn.object() + " as a long.");
                    return 0L;
                }
            }
            long l = this.getALong();
            this.checkRewind();
            return l;
        }

        public void checkRewind() {
            int ch = this.peekBack();
            if (END_CHARS.get(ch)) {
                TextWire.this.bytes.readSkip(-1L);
            }
        }

        public void checkRewindDouble() {
            this.checkRewind();
        }

        @Override
        public double float64() {
            TextWire.this.consumePadding();
            TextWire.this.valueIn.skipType();
            switch (TextWire.this.peekCode()) {
                case 36: {
                    this.unsubstitutedNumber();
                    return 0.0;
                }
                case 91: 
                case 123: {
                    Jvm.warn().on(this.getClass(), "Unable to read " + TextWire.this.valueIn.object() + " as a double.");
                    return 0.0;
                }
            }
            double v = TextWire.this.bytes.parseDouble();
            this.checkRewindDouble();
            return v;
        }

        void skipType() {
            long peek = TextWire.this.bytes.peekUnsignedByte();
            if (peek == 33L) {
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.consumePadding();
            }
        }

        @Override
        public float float32() {
            return (float)this.float64();
        }

        @Override
        public boolean isNull() {
            TextWire.this.consumePadding();
            if (TextWire.this.peekStringIgnoreCase("!!null \"\"")) {
                TextWire.this.bytes.readSkip((long)"!!null \"\"".length());
                TextWire.this.consumePadding(1);
                return true;
            }
            return false;
        }

        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class type) {
            TextWire.this.consumePadding();
            @Nullable Object o = this.objectWithInferredType0(using, strategy, type);
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 58 && strategy.bracketType() != BracketType.NONE) {
                return this.readRestOfMap(using, o);
            }
            return o;
        }

        @NotNull
        Object readRestOfMap(Object using, Object o) {
            TextWire.this.readCode();
            TextWire.this.consumePadding();
            @Nullable Object value = this.objectWithInferredType0(using, SerializationStrategies.ANY_OBJECT, Object.class);
            @NotNull Map<K, V> map = using instanceof Map ? (Map)using : new LinkedHashMap();
            map.put(o, value);
            TextWire.this.readAllAsMap(Object.class, Object.class, map);
            return map;
        }

        @Nullable
        Object objectWithInferredType0(Object using, @NotNull SerializationStrategy strategy, Class type) {
            int code = TextWire.this.peekCode();
            switch (code) {
                case 63: {
                    return this.map(Object.class, Object.class, (Map)using);
                }
                case 33: {
                    return this.object(using, type);
                }
                case 45: {
                    if (TextWire.this.peekCodeNext() == 32) {
                        return TextWire.this.readList(TextWire.this.indentation(), null);
                    }
                    return TextWire.this.valueIn.readNumber();
                }
                case 91: {
                    return this.readSequence(strategy.type());
                }
                case 123: {
                    return TextWire.this.valueIn.marshallableAsMap(Object.class, Object.class);
                }
                case 93: {
                    throw new IORuntimeException("Unexpected ] at " + TextWire.this.bytes.toDebugString(32L));
                }
                case 125: {
                    throw new IORuntimeException("Unexpected } at " + TextWire.this.bytes.toDebugString(32L));
                }
                case 43: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return TextWire.this.valueIn.readNumber();
                }
            }
            if (using instanceof Bytes) {
                return TextWire.this.valueIn.textTo((Bytes)using);
            }
            if (using instanceof StringBuilder) {
                return TextWire.this.valueIn.textTo((StringBuilder)using);
            }
            @Nullable String text = TextWire.this.valueIn.text();
            if (text == null || Enum.class.isAssignableFrom(strategy.type())) {
                return text;
            }
            switch (text) {
                case "true": {
                    return Boolean.TRUE;
                }
                case "false": {
                    return Boolean.FALSE;
                }
            }
            return text;
        }

        @Nullable
        protected Object readNumber() {
            String s;
            @Nullable String ss = s = this.text();
            if (s == null || s.length() > 40) {
                return s;
            }
            if (s.contains("_")) {
                ss = s.replace("_", "");
            }
            try {
                return Long.decode(ss);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(ss);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        if (s.length() == 7 && s.charAt(1) == ':') {
                            return LocalTime.parse("0" + s);
                        }
                        if (s.length() == 8 && s.charAt(2) == ':') {
                            return LocalTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() == 10) {
                            return LocalDate.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() >= 22) {
                            return ZonedDateTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    return s;
                }
            }
        }

        @NotNull
        private Object readSequence(@NotNull Class clazz) {
            if (clazz == Object[].class || clazz == Object.class) {
                Object @NotNull [] list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.object(Object.class));
                    }
                });
                return clazz == Object[].class ? list.toArray() : list;
            }
            if (clazz == String[].class) {
                @NotNull ArrayList<E> list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list.toArray(new String[0]);
            }
            if (clazz == List.class) {
                @NotNull ArrayList<E> list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list;
            }
            if (clazz == Set.class) {
                @NotNull HashSet<E> list = new HashSet();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list;
            }
            throw new UnsupportedOperationException("Arrays of type " + clazz + " not supported.");
        }

        public String toString() {
            return TextWire.this.toString();
        }
    }

    static enum NoObject {
        NO_OBJECT;

    }
}

