/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGeneratedMethodReader
implements MethodReader {
    @Deprecated
    private static final boolean RETRY_UNKOWN_METHOD = Jvm.getBoolean((String)"retry.unknown.method", (boolean)true);
    private static final Consumer<MessageHistory> NO_OP_MH_CONSUMER = (Consumer)Mocker.ignored(Consumer.class, (Class[])new Class[0]);
    private static final MessageHistoryThreadLocal TEMP_MESSAGE_HISTORY = new MessageHistoryThreadLocal();
    protected final WireParselet debugLoggingParselet;
    private final MarshallableIn in;
    protected MessageHistory messageHistory;
    protected boolean dataEventProcessed;
    private boolean closeIn = false;
    private boolean closed;
    private Consumer<MessageHistory> historyConsumer = NO_OP_MH_CONSUMER;
    private Predicate predicate;

    public AbstractGeneratedMethodReader predicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    protected AbstractGeneratedMethodReader(MarshallableIn in, WireParselet debugLoggingParselet) {
        this.in = in;
        this.debugLoggingParselet = debugLoggingParselet;
    }

    protected static Method lookupMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            Jvm.setAccessible((AccessibleObject)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void historyConsumer(Consumer<MessageHistory> historyConsumer) {
        this.historyConsumer = historyConsumer;
    }

    protected Boolean readOneGenerated(WireIn wireIn) {
        return this.readOneCall(wireIn);
    }

    @Deprecated
    protected boolean readOneCall(WireIn wireIn) {
        return Boolean.TRUE.equals(this.readOneGenerated(wireIn));
    }

    protected Boolean readOneMetaGenerated(WireIn wireIn) {
        return this.readOneCallMeta(wireIn);
    }

    @Deprecated
    protected boolean readOneCallMeta(WireIn wireIn) {
        return Boolean.TRUE.equals(this.readOneMetaGenerated(wireIn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean readOne0(DocumentContext context) {
        if (context.isMetaData()) {
            return false;
        }
        Wire wireIn = context.wire();
        if (wireIn == null) {
            return false;
        }
        if (this.historyConsumer != NO_OP_MH_CONSUMER) {
            this.writeUnwrittenMessageHistory(context);
            this.messageHistory = null;
        }
        this.messageHistory().reset(context.sourceId(), context.index());
        try {
            wireIn.startEvent();
            wireIn.consumePadding();
            Bytes<?> bytes = wireIn.bytes();
            this.dataEventProcessed = false;
            Boolean decoded = false;
            while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
                long start = bytes.readPosition();
                Boolean read = this.readOneGenerated(wireIn);
                if (read == null && Boolean.FALSE.equals(decoded)) {
                    decoded = null;
                } else if (Boolean.TRUE.equals(read)) {
                    decoded = true;
                }
                if (this.restIgnored()) {
                    Boolean bl = decoded;
                    return bl;
                }
                wireIn.consumePadding();
                if (bytes.readPosition() != start) continue;
                this.logNonProgressWarning(bytes.readRemaining());
                Boolean bl = decoded;
                return bl;
            }
            wireIn.endEvent();
            Boolean bl = decoded;
            return bl;
        }
        finally {
            if (this.historyConsumer != NO_OP_MH_CONSUMER && this.dataEventProcessed) {
                this.swapMessageHistoryIfDirty();
            }
            this.messageHistory.reset();
        }
    }

    private void logNonProgressWarning(long bytes) {
        Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes + " bytes left.");
    }

    public Boolean readOneMeta(DocumentContext context) {
        Wire wireIn = context.wire();
        if (wireIn == null) {
            return false;
        }
        wireIn.startEvent();
        Bytes<?> bytes = wireIn.bytes();
        boolean decoded = false;
        while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
            long start = bytes.readPosition();
            Boolean read = this.readOneMetaGenerated(wireIn);
            if (read == null) {
                return decoded ? Boolean.TRUE : null;
            }
            if (read.booleanValue()) {
                decoded = true;
            }
            if (this.restIgnored()) break;
            wireIn.consumePadding();
            if (bytes.readPosition() != start) continue;
            this.logNonProgressWarning(bytes.readRemaining());
            break;
        }
        if (decoded) {
            wireIn.endEvent();
        }
        return decoded;
    }

    protected boolean restIgnored() {
        return false;
    }

    private void swapMessageHistoryIfDirty() {
        if (this.messageHistory.isDirty()) {
            this.messageHistory = AbstractGeneratedMethodReader.TEMP_MESSAGE_HISTORY.getAndSet(this.messageHistory);
            MessageHistory.set(this.messageHistory);
            assert (this.messageHistory != TEMP_MESSAGE_HISTORY.get());
        } else {
            TEMP_MESSAGE_HISTORY.get().reset();
        }
    }

    private void writeUnwrittenMessageHistory(DocumentContext context) {
        MessageHistory mh = TEMP_MESSAGE_HISTORY.get();
        if (mh.sources() != 0 && context.sourceId() != mh.lastSourceId() && mh.isDirty()) {
            this.historyConsumer.accept(mh);
        }
    }

    public boolean readOne() {
        this.throwExceptionIfClosed();
        if (!this.predicate.test(this)) {
            return false;
        }
        do {
            try (DocumentContext context = this.in.readingDocument();){
                Boolean ok;
                if (!context.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                if (context.isMetaData()) {
                    ok = this.readOneMeta(context);
                    if (Boolean.FALSE.equals(ok)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    ok = this.readOne0(context);
                    if (ok != null) {
                        boolean bl = ok;
                        return bl;
                    }
                }
            }
        } while (RETRY_UNKOWN_METHOD && !this.isClosing());
        return false;
    }

    public void throwExceptionIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        return null;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    protected <T> T checkRecycle(T o) {
        if (o == null || o.getClass().isArray()) {
            return null;
        }
        if (o instanceof Collection) {
            ((Collection)o).clear();
        }
        if (o instanceof Map) {
            ((Map)o).clear();
        }
        return o;
    }

    protected Object actualInvoke(Method method, Object o, Object[] objects) {
        try {
            return method.invoke(o, objects);
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private MessageHistory messageHistory() {
        if (this.messageHistory == null) {
            this.messageHistory = MessageHistory.get();
        }
        return this.messageHistory;
    }

    private static final class MessageHistoryThreadLocal {
        private final ThreadLocal<MessageHistory> messageHistoryTL = ThreadLocal.withInitial(() -> {
            @NotNull VanillaMessageHistory veh = new VanillaMessageHistory();
            veh.addSourceDetails(true);
            return veh;
        });

        private MessageHistoryThreadLocal() {
        }

        private MessageHistory getAndSet(MessageHistory mh) {
            MessageHistory result = this.messageHistoryTL.get();
            this.messageHistoryTL.set(mh);
            return result;
        }

        public MessageHistory get() {
            return this.messageHistoryTL.get();
        }
    }
}

