/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.net.URL;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.wire.BinaryMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentWritten;
import net.openhft.chronicle.wire.MarshallableOutBuilder;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

@DontChain
public interface MarshallableOut
extends DocumentWritten {
    public static MarshallableOutBuilder builder(URL url) {
        return new MarshallableOutBuilder(url);
    }

    @Override
    @NotNull
    default public DocumentContext writingDocument() throws UnrecoverableTimeoutException {
        return this.writingDocument(false);
    }

    @Override
    public DocumentContext writingDocument(boolean var1) throws UnrecoverableTimeoutException;

    @Override
    public DocumentContext acquireWritingDocument(boolean var1) throws UnrecoverableTimeoutException;

    default public boolean recordHistory() {
        return false;
    }

    default public void writeMessage(WireKey key, Object value) throws UnrecoverableTimeoutException {
        try (@NotNull DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            wire.write(key).object(value);
        }
    }

    default public void writeMessage(String eventName, Object value) throws UnrecoverableTimeoutException {
        try (@NotNull DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            wire.write(eventName).object(value);
        }
    }

    default public void writeDocument(@NotNull WriteMarshallable writer) throws UnrecoverableTimeoutException, InvalidMarshallableException {
        try (@NotNull DocumentContext dc = this.writingDocument(false);){
            try {
                Wire wire = dc.wire();
                writer.writeMarshallable(wire);
            }
            catch (Throwable t) {
                dc.rollbackOnClose();
                throw Jvm.rethrow((Throwable)t);
            }
        }
    }

    default public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException, InvalidMarshallableException {
        try (@NotNull DocumentContext dc = this.writingDocument();){
            marshallable.writeMarshallable(dc.wire().bytes());
        }
    }

    default public <T> void writeDocument(T t, @NotNull BiConsumer<ValueOut, T> writer) throws UnrecoverableTimeoutException, InvalidMarshallableException {
        try (@NotNull DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            writer.accept(wire.getValueOut(), (ValueOut)t);
        }
    }

    default public void writeText(@NotNull CharSequence text) throws UnrecoverableTimeoutException {
        try (@NotNull DocumentContext dc = this.writingDocument();){
            dc.wire().getValueOut().text(text);
        }
    }

    default public void writeMap(@NotNull Map<?, ?> map) throws UnrecoverableTimeoutException {
        try (@NotNull DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                wire.writeEvent(Object.class, entry.getKey()).object(Object.class, entry.getValue());
            }
        }
    }

    @NotNull
    default public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        return this.methodWriter(false, tClass, additional);
    }

    @Deprecated
    @NotNull
    default public <T> T methodWriter(boolean metaData, @NotNull Class<T> tClass, Class ... additional) {
        VanillaMethodWriterBuilder builder = (VanillaMethodWriterBuilder)this.methodWriterBuilder(metaData, tClass);
        Stream.of(additional).forEach(builder::addInterface);
        return builder.build();
    }

    @NotNull
    default public <T> MethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        return this.methodWriterBuilder(false, tClass);
    }

    @NotNull
    default public <T> MethodWriterBuilder<T> methodWriterBuilder(boolean metaData, @NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.BINARY_LIGHT, () -> new BinaryMethodWriterInvocationHandler(tClass, metaData, this));
        builder.marshallableOut(this);
        builder.metaData(metaData);
        if (this instanceof Closeable) {
            builder.onClose((Closeable)this);
        }
        return builder;
    }
}

