/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.reduction;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.LongBinaryOperator;
import java.util.function.LongSupplier;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.ToDoubleDocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import net.openhft.chronicle.wire.domestic.reduction.Reduction;
import org.jetbrains.annotations.NotNull;

public final class Reductions {
    private Reductions() {
    }

    public static Reduction<LongSupplier> reducingLong(@NotNull ToLongDocumentExtractor extractor, long identity, @NotNull LongBinaryOperator accumulator) {
        ObjectUtils.requireNonNull((Object)extractor);
        ObjectUtils.requireNonNull((Object)accumulator);
        return Reduction.ofLong(extractor).reducing(() -> new LongAccumulator(accumulator, identity), LongAccumulator::accumulate, LongAccumulator::get);
    }

    public static Reduction<DoubleSupplier> reducingDouble(@NotNull ToDoubleDocumentExtractor extractor, double identity, @NotNull DoubleBinaryOperator accumulator) {
        ObjectUtils.requireNonNull((Object)extractor);
        ObjectUtils.requireNonNull((Object)accumulator);
        return Reduction.ofDouble(extractor).reducing(() -> new DoubleAccumulator(accumulator, identity), DoubleAccumulator::accumulate, DoubleAccumulator::get);
    }

    public static Reduction<LongSupplier> counting() {
        return Reduction.ofLong((wire, index) -> 1L).reducing(LongAdder::new, LongAdder::add, LongAdder::sum);
    }

    public static final class Counting
    extends SelfDescribingMarshallable
    implements Reduction<LongSupplier> {
        private static final AtomicLongFieldUpdater<Counting> UPDATER = AtomicLongFieldUpdater.newUpdater(Counting.class, "counter");
        private volatile long counter;

        @Override
        public void onExcerpt(@NotNull Wire wire, long index) {
            UPDATER.getAndIncrement(this);
        }

        @Override
        @NotNull
        public LongSupplier reduction() {
            return () -> this.counter;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Counting that = (Counting)o;
            return this.counter == that.counter;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.counter);
        }
    }
}

