/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.util.function.Supplier;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;

public class ChronicleChannelSupplier
extends ChronicleChannelCfg<ChronicleChannelSupplier>
implements Supplier<ChronicleChannel> {
    private final ChronicleContext context;
    private final ChannelHandler handler;
    private String protocol;

    public ChronicleChannelSupplier(ChronicleContext context, ChannelHandler handler) {
        this.context = context;
        this.handler = handler;
    }

    @Override
    public ChronicleChannel get() {
        ChronicleChannel channel;
        this.handler.systemContext(this.context.systemContext());
        switch (this.protocol) {
            case "tcp": {
                channel = ChronicleChannel.newChannel(this.context.socketRegistry(), this, this.handler);
                break;
            }
            case "internal": {
                channel = this.handler.asInternalChannel(this.context, this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported protocol " + this.protocol);
            }
        }
        this.context.addCloseable(channel);
        return channel;
    }

    public String protocol() {
        return this.protocol;
    }

    public ChronicleChannelSupplier protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }
}

