/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.function.Function;
import net.openhft.chronicle.wire.TextMethodTester;

public interface YamlTester {
    public static YamlTester runTest(Class<?> implClass, String path) throws AssertionError {
        for (Constructor<?> cons : implClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes;
            if (cons.getParameterCount() != 1 || !(parameterTypes = cons.getParameterTypes())[0].isInterface()) continue;
            return YamlTester.runTest(out -> {
                try {
                    return cons.newInstance(out);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }, parameterTypes[0], path);
        }
        throw new IllegalArgumentException("Unable to find a constructor with one interface as an argument");
    }

    public static <T> YamlTester runTest(Function<T, Object> builder, Class<T> outClass, String path) throws AssertionError {
        try {
            return new TextMethodTester<T>(path + "/in.yaml", builder, outClass, path + "/out.yaml").setup(path + "/setup.yaml").run();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public String expected();

    public String actual();
}

