/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.ChronicleBitSet;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class LongArrayValueBitSet
extends AbstractCloseable
implements Marshallable,
ChronicleBitSet {
    private static final long WORD_MASK = -1L;
    private transient Pauser pauser;
    private LongArrayValues words;

    public LongArrayValueBitSet(long maxNumberOfBits) {
        this.words = new BinaryLongArrayReference((maxNumberOfBits + 64L - 1L) / 64L);
        this.disableThreadSafetyCheck(true);
    }

    public LongArrayValueBitSet(long maxNumberOfBits, Wire w) {
        this(maxNumberOfBits);
        this.writeMarshallable(w);
        this.readMarshallable(w);
    }

    private static int wordIndex(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        return (int)((long)bitIndex / 64L);
    }

    public static BitSet valueOf(byte[] bytes) {
        return BitSet.valueOf(ByteBuffer.wrap(bytes));
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public long getWord(int wordIndex) {
        return wordIndex < this.getWordsInUse() ? this.words.getValueAt((long)wordIndex) : 0L;
    }

    @Override
    public void setWord(int wordIndex, long bits) {
        this.expandTo(wordIndex);
        this.words.setValueAt((long)wordIndex, bits);
    }

    protected void performClose() {
        Closeable.closeQuietly((Object)this.words);
    }

    @Override
    public int getWordsInUse() {
        return Math.toIntExact(this.words.getUsed());
    }

    public void set(int wordIndex, long param, LongFunction function) {
        long value;
        long oldValue;
        this.throwExceptionIfClosed();
        Pauser internalPauser = this.pauser();
        internalPauser.reset();
        this.expandTo(wordIndex);
        while ((oldValue = this.words.getVolatileValueAt((long)wordIndex)) != (value = function.apply(oldValue, param)) && !this.words.compareAndSet((long)wordIndex, oldValue, value)) {
            internalPauser.pause();
        }
    }

    private Pauser pauser() {
        if (this.pauser == null) {
            this.pauser = Pauser.busy();
        }
        return this.pauser;
    }

    public void set(LongValue word, long newValue) {
        this.throwExceptionIfClosed();
        this.pauser.reset();
        long oldValue = word.getVolatileValue();
        while (!word.compareAndSwapValue(oldValue, newValue)) {
            this.pauser.pause();
        }
    }

    public byte[] toByteArray() {
        this.throwExceptionIfClosed();
        int n = Math.toIntExact(this.getWordsInUse());
        if (n == 0) {
            return new byte[0];
        }
        OnHeapBytes bytes = Bytes.allocateElasticOnHeap((int)Math.toIntExact((long)n * 8L));
        bytes.writeLong(this.words.getVolatileValueAt(0L));
        for (int i = 1; i < n; ++i) {
            bytes.writeLong(this.words.getValueAt((long)i));
        }
        return (byte[])bytes.underlyingObject();
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        long capacity = this.words.getCapacity();
        if ((long)wordsRequired <= capacity) {
            this.words.setMaxUsed((long)wordsRequired);
        } else if ((long)wordsRequired > capacity) {
            throw new UnsupportedOperationException("todo: it is not possible currently to expand this structure, because if its concurrent nature and have to implement cross process locking capacity: " + capacity + ", wordIndex: " + wordIndex);
        }
    }

    @Override
    public void flip(int bitIndex) {
        this.throwExceptionIfClosed();
        int wordIndex = LongArrayValueBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.caret(wordIndex, 1L << bitIndex);
    }

    private void caret(int wordIndex, long param) {
        this.set(wordIndex, param, (x, y) -> x ^ y);
    }

    private void and(int wordIndex, long param) {
        this.set(wordIndex, param, (x, y) -> x & y);
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        LongArrayValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = LongArrayValueBitSet.wordIndex(fromIndex);
        int endWordIndex = LongArrayValueBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.caret(startWordIndex, firstWordMask & lastWordMask);
        } else {
            this.caret(startWordIndex, firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.caret(i, -1L);
            }
            this.caret(endWordIndex, lastWordMask);
        }
    }

    @Override
    public void set(int bitIndex) {
        this.throwExceptionIfClosed();
        int wordIndex = LongArrayValueBitSet.wordIndex(bitIndex);
        this.pipe(wordIndex, 1L << bitIndex);
    }

    private void pipe(int wordIndex, long param) {
        this.set(wordIndex, param, (x, y) -> x | y);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        this.throwExceptionIfClosed();
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        LongArrayValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = LongArrayValueBitSet.wordIndex(fromIndex);
        int endWordIndex = LongArrayValueBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.pipe(startWordIndex, firstWordMask & lastWordMask);
        } else {
            this.pipe(startWordIndex, firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.setWord(i, -1L);
            }
            this.pipe(endWordIndex, lastWordMask);
        }
    }

    @Override
    public void clear(int bitIndex) {
        this.throwExceptionIfClosed();
        int wordIndex = LongArrayValueBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.getWordsInUse()) {
            return;
        }
        this.and(wordIndex, 1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        LongArrayValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = LongArrayValueBitSet.wordIndex(fromIndex);
        if (startWordIndex >= this.getWordsInUse()) {
            return;
        }
        int endWordIndex = LongArrayValueBitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= this.getWordsInUse()) {
            toIndex = this.length();
            endWordIndex = this.getWordsInUse() - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.and(startWordIndex, firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.and(startWordIndex, firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words.setOrderedValueAt((long)i, 0L);
            }
            this.and(endWordIndex, lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void clear() {
        this.throwExceptionIfClosed();
        int value = Math.toIntExact(this.getWordsInUse());
        while (value > 0) {
            this.words.setValueAt((long)(--value), 0L);
        }
        this.words.setUsed(0L);
    }

    @Override
    public boolean get(int bitIndex) {
        this.throwExceptionIfClosed();
        int wordIndex = LongArrayValueBitSet.wordIndex(bitIndex);
        return wordIndex < this.getWordsInUse() && (this.words.getValueAt((long)wordIndex) & 1L << bitIndex) != 0L;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        this.throwExceptionIfClosed();
        int u = LongArrayValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return -1;
        }
        long word = this.words.getVolatileValueAt((long)u) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.getWordsInUse()) {
                return -1;
            }
            word = this.words.getValueAt((long)u);
        }
        return Math.toIntExact((long)u * 64L + (long)Long.numberOfTrailingZeros(word));
    }

    @Override
    public int nextSetBit(int fromIndex, int toIndex) {
        this.throwExceptionIfClosed();
        int u = LongArrayValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return -1;
        }
        long word = this.words.getVolatileValueAt((long)u) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.getWordsInUse()) {
                return -1;
            }
            if ((long)u * 64L > (long)toIndex) {
                return -1;
            }
            word = this.words.getValueAt((long)u);
        }
        return Math.toIntExact((long)u * 64L + (long)Long.numberOfTrailingZeros(word));
    }

    @Override
    public int nextClearBit(int fromIndex) {
        this.throwExceptionIfClosed();
        int u = LongArrayValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return fromIndex;
        }
        long word = (this.words.getVolatileValueAt((long)u) ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.getWordsInUse()) {
                return (int)((long)this.getWordsInUse() * 64L);
            }
            word = this.words.getValueAt((long)u) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Math.toIntExact((long)u * 64L + (long)Long.numberOfTrailingZeros(word));
    }

    public int previousSetBit(int fromIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = LongArrayValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return this.length() - 1;
        }
        long word = this.words.getVolatileValueAt((long)u) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words.getValueAt((long)u);
        }
        return Math.toIntExact((long)(u + 1) * 64L - 1L - (long)Long.numberOfLeadingZeros(word));
    }

    public int previousClearBit(int fromIndex) {
        this.throwExceptionIfClosed();
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = LongArrayValueBitSet.wordIndex(fromIndex);
        if (u >= this.getWordsInUse()) {
            return fromIndex;
        }
        long word = (this.words.getVolatileValueAt((long)u) ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words.getValueAt((long)u) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Math.toIntExact((long)(u + 1) * 64L - 1L - (long)Long.numberOfLeadingZeros(word));
    }

    @Override
    public boolean intersects(ChronicleBitSet set) {
        this.throwExceptionIfClosed();
        for (int i = Math.min(this.getWordsInUse(), set.getWordsInUse()) - 1; i >= 0; --i) {
            if ((this.words.getVolatileValueAt((long)i) & set.getWord(i)) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cardinality() {
        this.throwExceptionIfClosed();
        long sum = 0L;
        for (int i = 0; i < this.getWordsInUse(); ++i) {
            sum += (long)Long.bitCount(this.words.getVolatileValueAt((long)i));
        }
        return (int)sum;
    }

    @Override
    public void and(ChronicleBitSet set) {
        this.throwExceptionIfClosed();
        if (this == set) {
            return;
        }
        OS.memory().loadFence();
        int value = Math.toIntExact(this.getWordsInUse());
        while (value > set.getWordsInUse()) {
            this.words.setValueAt((long)(--value), 0L);
        }
        for (int i = 0; i < value; ++i) {
            this.and(i, set.getWord(i));
        }
        OS.memory().storeFence();
    }

    @Override
    public void or(ChronicleBitSet set) {
        this.throwExceptionIfClosed();
        if (this == set) {
            return;
        }
        this.expandTo(set.getWordsInUse() - 1);
        long wordsInCommon = Math.min(this.getWordsInUse(), set.getWordsInUse());
        OS.memory().loadFence();
        int i = 0;
        while ((long)i < wordsInCommon) {
            this.pipe(i, set.getWord(i));
            ++i;
        }
        while (i < set.getWordsInUse()) {
            this.setWord(i, set.getWord(i));
            ++i;
        }
        OS.memory().storeFence();
    }

    @Override
    public void xor(ChronicleBitSet set) {
        int i;
        this.throwExceptionIfClosed();
        int wordsInUse = this.getWordsInUse();
        int wordsInUse2 = set.getWordsInUse();
        int wordsInCommon = Math.toIntExact(Math.min(wordsInUse, wordsInUse2));
        this.expandTo(wordsInUse2 - 1);
        OS.memory().loadFence();
        for (i = 0; i < wordsInCommon; ++i) {
            this.caret(i, set.getWord(i));
        }
        while (i < wordsInUse2) {
            this.words.setValueAt((long)i, set.getWord(i));
            ++i;
        }
        OS.memory().storeFence();
    }

    @Override
    public void andNot(ChronicleBitSet set) {
        this.throwExceptionIfClosed();
        OS.memory().loadFence();
        for (int i = Math.min(this.getWordsInUse(), set.getWordsInUse()) - 1; i >= 0; --i) {
            this.and(i, set.getWord(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        OS.memory().storeFence();
    }

    public int hashCode() {
        long h = 1234L;
        OS.memory().loadFence();
        int i = Math.toIntExact(this.getWordsInUse());
        while (--i >= 0) {
            h ^= this.words.getValueAt((long)i) * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public int size() {
        return Math.toIntExact(this.words.getCapacity() * 64L);
    }

    public boolean equals(Object obj) {
        this.throwExceptionIfClosed();
        if (!(obj instanceof ChronicleBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ChronicleBitSet set = (ChronicleBitSet)obj;
        OS.memory().loadFence();
        int max = Math.max(this.getWordsInUse(), set.getWordsInUse());
        for (int i = 0; i < max; ++i) {
            if (this.getWord(i) == set.getWord(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int numBits = Math.toIntExact(this.getWordsInUse() > 128 ? (long)this.cardinality() : (long)this.getWordsInUse() * 64L);
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        return b.toString();
    }

    public IntStream stream() {
        this.throwExceptionIfClosed();
        return StreamSupport.intStream(() -> {
            class BitSetIterator
            implements PrimitiveIterator.OfInt {
                int next;

                BitSetIterator() {
                    this.next = LongArrayValueBitSet.this.nextSetBit(0);
                }

                @Override
                public boolean hasNext() {
                    LongArrayValueBitSet.this.throwExceptionIfClosed();
                    return this.next != -1;
                }

                @Override
                public int nextInt() {
                    LongArrayValueBitSet.this.throwExceptionIfClosed();
                    if (this.next != -1) {
                        int ret = this.next;
                        this.next = LongArrayValueBitSet.this.nextSetBit(this.next + 1);
                        return ret;
                    }
                    throw new NoSuchElementException();
                }
            }
            return Spliterators.spliterator(new BitSetIterator(), (long)this.cardinality(), 21);
        }, 16469, false);
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        this.throwExceptionIfClosed();
        wire.write("words").int64array(this.words.getCapacity(), this.words);
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.disableThreadSafetyCheck(true);
        this.throwExceptionIfClosed();
        Closeable.closeQuietly((Object)this.words);
        wire.read("words").int64array(null, this, (t, a) -> {
            t.words = a;
        });
    }

    @Override
    public void copyFrom(ChronicleBitSet bitSet) {
        int i;
        OS.memory().loadFence();
        int wordsInUse = bitSet.getWordsInUse();
        long capacity = this.words.getCapacity();
        if ((long)wordsInUse > capacity) {
            throw new IllegalArgumentException("Too much data " + wordsInUse + " words > " + capacity);
        }
        for (i = this.getWordsInUse(); i > wordsInUse; --i) {
            this.words.setValueAt((long)i, 0L);
        }
        this.words.setUsed((long)wordsInUse);
        for (i = 0; i < wordsInUse; ++i) {
            this.words.setValueAt((long)i, bitSet.getWord(i));
        }
        OS.memory().storeFence();
    }

    @FunctionalInterface
    static interface LongFunction {
        public long apply(long var1, long var3);
    }
}

