/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextStopCharsTesters;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSONWire
extends TextWire {
    static final BytesStore COMMA = BytesStore.from((String)",");
    boolean useTypes;

    public JSONWire() {
        this((Bytes)Bytes.allocateElasticOnHeap());
    }

    public JSONWire(@NotNull Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
        this.trimFirstCurly(false);
    }

    public JSONWire(@NotNull Bytes bytes) {
        this(bytes, false);
    }

    @NotNull
    public static JSONWire from(@NotNull String text) {
        return new JSONWire(Bytes.from((String)text));
    }

    public static String asText(@NotNull Wire wire) {
        long pos = wire.bytes().readPosition();
        @NotNull JSONWire tw = new JSONWire((Bytes)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    static boolean isWrapper(Class<?> type) {
        return type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == Void.class;
    }

    public JSONWire useTypes(boolean outputTypes) {
        this.useTypes = outputTypes;
        return this;
    }

    public boolean useTypes() {
        return this.useTypes;
    }

    @Override
    @NotNull
    protected TextWire.TextValueOut createValueOut() {
        return new JSONValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new JSONValueIn(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double float64() {
                boolean isNull;
                JSONWire.this.consumePadding();
                JSONWire.this.valueIn.skipType();
                switch (JSONWire.this.peekCode()) {
                    case 91: 
                    case 123: {
                        Jvm.warn().on(this.getClass(), "Unable to read " + JSONWire.this.valueIn.object() + " as a double.");
                        return 0.0;
                    }
                }
                long l = JSONWire.this.bytes.readLimit();
                try {
                    JSONWire.this.bytes.readLimit(JSONWire.this.bytes.readPosition() + 4L);
                    isNull = "null".contentEquals((CharSequence)JSONWire.this.bytes);
                }
                finally {
                    JSONWire.this.bytes.readLimit(l);
                }
                if (isNull) {
                    JSONWire.this.bytes.readSkip((long)"null".length());
                    JSONWire.this.consumePadding();
                }
                double v = isNull ? Double.NaN : JSONWire.this.bytes.parseDouble();
                this.checkRewind();
                return v;
            }

            @Override
            public void checkRewind() {
                int ch = JSONWire.this.bytes.readUnsignedByte(JSONWire.this.bytes.readPosition() - 1L);
                if (ch == 58 || ch == 125 || ch == 93) {
                    JSONWire.this.bytes.readSkip(-1L);
                } else if (ch != 108 && ch > 70 && (ch < 97 || ch > 102)) {
                    throw new IllegalArgumentException("Unexpected character in number '" + (char)ch + '\'');
                }
            }
        };
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Quotes needsQuotesEscaped(@NotNull CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch >= ' ') continue;
            return Quotes.DOUBLE;
        }
        return Quotes.NONE;
    }

    @Override
    void escape(@NotNull CharSequence s) {
        this.bytes.writeUnsignedByte(34);
        if (this.needsQuotesEscaped(s) == Quotes.NONE) {
            this.bytes.appendUtf8(s);
        } else {
            this.escape0(s, Quotes.DOUBLE);
        }
        this.bytes.writeUnsignedByte(34);
    }

    @Override
    public ValueOut writeEvent(Class expectedType, Object eventKey) {
        return super.writeEvent(String.class, "" + eventKey);
    }

    @Override
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        int code = this.peekCode();
        if (code == 125) {
            sb.setLength(0);
            return sb;
        }
        if (code == 123) {
            if (this.valueIn.stack.level > 0) {
                throw new IORuntimeException("Expected field name, but got { at " + this.bytes.toDebugString(64L));
            }
            this.valueIn.pushState();
            this.bytes.readSkip(1L);
        }
        return super.readField(sb);
    }

    @Override
    @NotNull
    protected TextStopCharsTesters strictEndOfText() {
        return TextStopCharsTesters.STRICT_END_OF_TEXT_JSON;
    }

    class JSONValueIn
    extends TextWire.TextValueIn {
        JSONValueIn() {
            super(JSONWire.this);
        }

        @Override
        public String text() {
            @Nullable String text = super.text();
            return text == null || text.equals("null") ? null : text;
        }

        @Override
        protected boolean isASeparator(int nextChar) {
            return true;
        }

        @Override
        @Nullable
        public Object object() {
            return JSONWire.this.useTypes ? this.parseType() : super.object();
        }

        @Override
        @Nullable
        public <E> E object(@NotNull Class<E> clazz) {
            return (E)(JSONWire.this.useTypes ? this.parseType(null, clazz) : super.object(clazz));
        }

        @Override
        public <E> E object(@Nullable E using, @Nullable Class clazz) {
            return JSONWire.this.useTypes ? this.parseType(using, clazz) : super.object(using, clazz);
        }

        @Override
        public Class typePrefix() {
            return super.typePrefix();
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            return super.typePrefixOrObject(tClass);
        }

        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            return super.marshallable(object, strategy);
        }

        @Override
        public boolean isTyped() {
            return JSONWire.this.useTypes || super.isTyped();
        }

        private Object parseType() {
            if (!this.hasTypeDefinition()) {
                return super.object();
            }
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.setLength(0);
            this.wireIn().read(sb);
            Class clazz = JSONWire.this.classLookup().forName(sb.subSequence(1, sb.length()));
            return this.parseType(null, clazz);
        }

        private <E> E parseType(@Nullable E using, @NotNull Class clazz) {
            if (!this.hasTypeDefinition()) {
                return super.object(using, clazz);
            }
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.setLength(0);
            this.readTypeDefinition(sb);
            Class overrideClass = JSONWire.this.classLookup().forName(sb.subSequence(1, sb.length()));
            if (!clazz.isAssignableFrom(overrideClass)) {
                throw new ClassCastException("Unable to cast " + overrideClass.getName() + " to " + clazz.getName());
            }
            if (using != null && !overrideClass.isInstance(using)) {
                throw new ClassCastException("Unable to reuse a " + using.getClass().getName() + " as a " + overrideClass.getName());
            }
            E result = super.object(using, overrideClass);
            JSONWire.this.consumePadding();
            char endBracket = JSONWire.this.bytes.readChar();
            assert (endBracket == '}') : "Missing end bracket }, got " + endBracket + " from " + JSONWire.this.bytes;
            JSONWire.this.consumePadding(1);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTypeDefinition() {
            long readPos = JSONWire.this.bytes.readPosition();
            try {
                JSONWire.this.consumePadding();
                if (JSONWire.this.bytes.readChar() != '{') {
                    boolean bl = false;
                    return bl;
                }
                JSONWire.this.consumePadding();
                if (JSONWire.this.bytes.readChar() != '\"') {
                    boolean bl = false;
                    return bl;
                }
                JSONWire.this.consumePadding();
                boolean bl = JSONWire.this.bytes.readChar() == '@';
                return bl;
            }
            finally {
                JSONWire.this.bytes.readPosition(readPos);
            }
        }

        void readTypeDefinition(StringBuilder sb) {
            JSONWire.this.consumePadding();
            if (JSONWire.this.bytes.readChar() != '{') {
                throw new IORuntimeException("Expected { but got " + JSONWire.this.bytes);
            }
            JSONWire.this.consumePadding();
            this.text(sb);
            JSONWire.this.consumePadding();
            char colon = JSONWire.this.bytes.readChar();
            assert (colon == ':') : "Expected : but got " + colon;
        }

        public boolean useTypes() {
            return JSONWire.this.useTypes;
        }
    }

    class JSONValueOut
    extends TextWire.TextValueOut {
        JSONValueOut() {
            super(JSONWire.this);
        }

        @Override
        @NotNull
        public String nullOut() {
            return "null";
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@Nullable CharSequence type) {
            return this.text(type);
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            if (JSONWire.this.useTypes) {
                this.startBlock('{');
                JSONWire.this.bytes.append((CharSequence)"\"@");
                JSONWire.this.bytes.append(typeName);
                JSONWire.this.bytes.append((CharSequence)"\":");
            }
            return this;
        }

        @Override
        public void endTypePrefix() {
            super.endTypePrefix();
            if (JSONWire.this.useTypes) {
                this.endBlock(true, '}');
            }
        }

        @Override
        public void elementSeparator() {
            this.sep = COMMA;
        }

        @Override
        protected void asTestQuoted(String s, Quotes quotes) {
            JSONWire.this.bytes.append('\"');
            JSONWire.this.escape0(s, quotes);
            JSONWire.this.bytes.append('\"');
        }

        @Override
        protected void popState() {
        }

        @Override
        protected void pushState() {
            this.leaf = true;
        }

        @Override
        protected void afterOpen() {
            this.sep = TextWire.EMPTY;
        }

        @Override
        protected void afterClose() {
        }

        @Override
        protected void addNewLine(long pos) {
        }

        @Override
        protected void newLine() {
        }

        @Override
        protected void endField() {
            this.sep = COMMA;
        }

        @Override
        protected void fieldValueSeperator() {
            JSONWire.this.bytes.writeUnsignedByte(58);
        }

        @Override
        public void writeComment(@NotNull CharSequence s) {
        }

        @Override
        protected String doubleToString(double d) {
            return Double.isNaN(d) ? "null" : super.doubleToString(d);
        }

        @Override
        protected String floatToString(float f) {
            return Float.isNaN(f) ? "null" : super.floatToString(f);
        }

        @Override
        @NotNull
        public WireOut rawText(CharSequence value) {
            JSONWire.this.bytes.writeByte((byte)34);
            WireOut wireOut = super.rawText(value);
            JSONWire.this.bytes.writeByte((byte)34);
            return wireOut;
        }

        @Override
        @NotNull
        public WireOut date(LocalDate localDate) {
            return this.text(localDate.toString());
        }

        @Override
        @NotNull
        public WireOut dateTime(LocalDateTime localDateTime) {
            return this.text(localDateTime.toString());
        }

        @Override
        @NotNull
        public <V> WireOut object(@NotNull Class<V> expectedType, V v) {
            return JSONWire.this.useTypes ? super.object(v) : super.object(expectedType, v);
        }

        @Override
        @NotNull
        public ValueOut typePrefix(Class type) {
            if (type.isPrimitive() || JSONWire.isWrapper(type) || type.isEnum()) {
                return this;
            }
            return super.typePrefix(type);
        }

        @Override
        @NotNull
        public <K, V> WireOut marshallable(@Nullable Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass, boolean leaf) {
            return super.marshallable(map, String.class, vClass, leaf);
        }

        @Override
        @NotNull
        public WireOut time(LocalTime localTime) {
            return super.time(localTime);
        }
    }
}

