/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class Base85LongConverter
implements LongConverter {
    public static final int MAX_LENGTH = LongConverter.maxParseLength(85);
    public static final Base85LongConverter INSTANCE = new Base85LongConverter();
    private static final String CHARS = "0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz\"#$%&'()*+,-./ ";
    private static final char[] DECODE = "0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz\"#$%&'()*+,-./ ".toCharArray();
    private static final byte[] ENCODE = new byte[128];
    private static final int BASE = 85;

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            byte b = ENCODE[text.charAt(i)];
            if (b < 0) continue;
            v = v * 85L + (long)b;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        if (value < 0L) {
            long hi = value >>> 32;
            long h2 = hi / 85L;
            long mod = hi % 85L;
            long val2 = (mod << 32) + (value & 0xFFFFFFFFL);
            int l2 = (int)(val2 / 85L);
            int v = (int)(val2 % 85L);
            text.append(DECODE[v]);
            value = (h2 << 32) + ((long)l2 & 0xFFFFFFFFL);
        }
        while (value != 0L) {
            int v = (int)(value % 85L);
            value /= 85L;
            text.append(DECODE[v]);
        }
        StringUtils.reverse((StringBuilder)text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }

    static {
        assert (DECODE.length == 85);
        Arrays.fill(ENCODE, (byte)-1);
        for (int i = 0; i < DECODE.length; ++i) {
            char c = DECODE[i];
            Base85LongConverter.ENCODE[c] = (byte)i;
        }
    }
}

