/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumInterner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.core.util.SerializableConsumer;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.core.util.SerializablePredicate;
import net.openhft.chronicle.core.util.SerializableUpdater;
import net.openhft.chronicle.core.util.SerializableUpdaterWithArg;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaFieldInfo;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.internal.FromStringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WireInternal
extends Enum<WireInternal> {
    static final StringInterner INTERNER;
    static final StringBuilderPool SBP;
    static final StringBuilderPool ASBP;
    static final ThreadLocal<WeakReference<Bytes>> BYTES_TL;
    static final ThreadLocal<WeakReference<Bytes>> BYTES_F2S_TL;
    static final ThreadLocal<WeakReference<Wire>> BINARY_WIRE_TL;
    static final ThreadLocal<WeakReference<Bytes>> ABYTES_TL;
    static final StackTraceElement[] NO_STE;
    static final Set<Class> INTERNABLE;
    static final Map<Class, ObjectInterner> OBJECT_INTERNERS;
    private static final Field DETAILED_MESSAGE;
    private static final Field STACK_TRACE;
    private static final /* synthetic */ WireInternal[] $VALUES;

    public static WireInternal[] values() {
        return (WireInternal[])$VALUES.clone();
    }

    public static WireInternal valueOf(String name) {
        return Enum.valueOf(WireInternal.class, name);
    }

    static void addAliases() {
    }

    @NotNull
    public static <E extends Enum<E>> E internEnum(@NotNull Class<E> eClass, @NotNull CharSequence cs) {
        return (E)((EnumInterner)EnumInterner.ENUM_INTERNER.get(eClass)).intern(cs);
    }

    static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    static StringBuilder acquireAnotherStringBuilder(CharSequence cs) {
        StringBuilder sb = ASBP.acquireStringBuilder();
        assert (sb != cs);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeData(@NotNull WireOut wireOut, boolean metaData, boolean notComplete, @NotNull WriteMarshallable writer) {
        long position;
        if (notComplete) {
            Jvm.warn().on(WireInternal.class, "Writing an incomplete document is deprecated, this feature will be removed in a future release.");
        }
        wireOut.getValueOut().resetBetweenDocuments();
        assert (wireOut.startUse());
        try {
            @NotNull Bytes<?> bytes = wireOut.bytes();
            position = bytes.writePositionForHeader(wireOut.usePadding());
            int metaDataBit = metaData ? 0x40000000 : 0;
            int len0 = metaDataBit | Integer.MIN_VALUE | 0;
            bytes.writeOrderedInt(len0);
            writer.writeMarshallable(wireOut);
            long position1 = bytes.writePosition();
            int length = bytes instanceof HexDumpBytes ? metaDataBit | Wires.toIntU30((int)position1 - (int)position - 4, "Document length %,d out of 30-bit int range.") : metaDataBit | Wires.toIntU30(position1 - position - 4L, "Document length %,d out of 30-bit int range.");
            if (wireOut.usePadding()) {
                bytes.testAndSetInt(position, len0, length | (notComplete ? Integer.MIN_VALUE : 0));
            } else {
                bytes.writeInt(position, length | (notComplete ? Integer.MIN_VALUE : 0));
            }
        }
        finally {
            assert (wireOut.endUse());
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readData(long offset, @NotNull WireIn wireIn, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) {
        @NotNull Bytes<?> bytes = wireIn.bytes();
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readLimit(bytes.isElastic() ? bytes.capacity() : bytes.realCapacity());
            bytes.readPosition(offset);
            boolean bl = WireInternal.readData(wireIn, metaDataConsumer, dataConsumer);
            return bl;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readData(@NotNull WireIn wireIn, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) {
        @NotNull Bytes<?> bytes = wireIn.bytes();
        boolean read = false;
        while (true) {
            bytes.readPositionForHeader(wireIn.usePadding());
            if (bytes.readRemaining() < 4L) break;
            long position = bytes.readPosition();
            int header = bytes.readVolatileInt(position);
            if (!WireInternal.isKnownLength(header)) {
                return read;
            }
            bytes.readSkip(4L);
            int len = Wires.lengthOf(header);
            if (Wires.isData(header)) {
                if (dataConsumer == null) {
                    return false;
                }
                bytes.readWithLength((long)len, b -> dataConsumer.readMarshallable(wireIn));
                return true;
            }
            if (metaDataConsumer == null) {
                bytes.readSkip((long)len);
            } else {
                if ((long)len > bytes.readRemaining()) {
                    throw new BufferUnderflowException();
                }
                long limit0 = bytes.readLimit();
                long limit = bytes.readPosition() + (long)len;
                try {
                    bytes.readLimit(limit);
                    metaDataConsumer.readMarshallable(wireIn);
                }
                finally {
                    bytes.readLimit(limit0);
                    bytes.readPosition(limit);
                }
            }
            if (dataConsumer == null) {
                return true;
            }
            read = true;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rawReadData(@NotNull WireIn wireIn, @NotNull ReadMarshallable dataConsumer) {
        @NotNull Bytes<?> bytes = wireIn.bytes();
        int header = bytes.readInt();
        assert (Wires.isReady(header) && Wires.isData(header));
        int len = Wires.lengthOf(header);
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + (long)len;
        try {
            bytes.readLimit(limit);
            dataConsumer.readMarshallable(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
        }
    }

    private static boolean isKnownLength(long len) {
        return (len & Integer.MAX_VALUE) != 0L;
    }

    public static Throwable throwable(@NotNull ValueIn valueIn, boolean appendCurrentStack) {
        @Nullable Class type = valueIn.typePrefix();
        Throwable throwable = (Throwable)ObjectUtils.newInstance((Class)type);
        return WireInternal.throwable(valueIn, appendCurrentStack, throwable);
    }

    protected static Throwable throwable(@NotNull ValueIn valueIn, boolean appendCurrentStack, Throwable throwable) {
        Throwable finalThrowable = throwable;
        @NotNull ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>();
        valueIn.marshallable(m -> {
            @Nullable String message = m.read(() -> "message").text();
            if (message != null) {
                try {
                    DETAILED_MESSAGE.set(finalThrowable, message);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            m.read(() -> "stackTrace").sequence(stes, (stes0, stackTrace) -> {
                while (stackTrace.hasNextSequenceItem()) {
                    stackTrace.marshallable(r -> {
                        @Nullable String declaringClass = r.read(() -> "class").text();
                        @Nullable @Nullable String methodName = r.read(() -> "method").text();
                        @NotNull @Nullable String fileName = r.read(() -> "file").text();
                        int lineNumber = r.read(() -> "line").int32();
                        stes0.add(new StackTraceElement(declaringClass, methodName, fileName, lineNumber));
                    });
                }
            });
        });
        if (appendCurrentStack) {
            stes.add(new StackTraceElement("~ remote", "tcp ~", "", 0));
            StackTraceElement[] stes2 = Thread.currentThread().getStackTrace();
            int first = 6;
            int last = Jvm.trimLast((int)first, (StackTraceElement[])stes2);
            for (int i = first; i <= last; ++i) {
                stes.add(stes2[i]);
            }
        }
        try {
            STACK_TRACE.set(finalThrowable, stes.toArray(NO_STE));
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return throwable;
    }

    @Nullable
    static String merge(@Nullable String a, @Nullable String b) {
        return a == null ? b : (b == null ? a : a + " " + b);
    }

    @Deprecated
    public static void compress(@NotNull ValueOut out, @NotNull String compression, String str) {
        Bytes<?> bytes = Wires.acquireBytes();
        bytes.writeUtf8(str);
        Bytes bytes2 = Wires.acquireAnotherBytes();
        Compression.compress((CharSequence)compression, bytes, (Bytes)bytes2);
        out.bytes(compression, (BytesStore)bytes2);
    }

    static <T> T intern(Class<T> tClass, Object o) {
        if (INTERNABLE.contains(tClass) && o instanceof String) {
            String s = (String)o;
            if (tClass == String.class) {
                return (T)INTERNER.intern((CharSequence)s);
            }
            ObjectInterner interner = OBJECT_INTERNERS.computeIfAbsent(tClass, ObjectInterner::new);
            return interner.intern(s);
        }
        return (T)ObjectUtils.convertTo(tClass, (Object)o);
    }

    static {
        $VALUES = new WireInternal[0];
        INTERNER = new StringInterner(Integer.getInteger("wire.interner.size", 4096).intValue());
        SBP = new StringBuilderPool();
        ASBP = new StringBuilderPool();
        BYTES_TL = new ThreadLocal();
        BYTES_F2S_TL = new ThreadLocal();
        BINARY_WIRE_TL = new ThreadLocal();
        ABYTES_TL = new ThreadLocal();
        NO_STE = new StackTraceElement[0];
        INTERNABLE = new HashSet<Class>(Arrays.asList(String.class, UUID.class, DayOfWeek.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZonedDateTime.class));
        OBJECT_INTERNERS = new ConcurrentHashMap<Class, ObjectInterner>();
        DETAILED_MESSAGE = Jvm.getField(Throwable.class, (String)"detailMessage");
        STACK_TRACE = Jvm.getField(Throwable.class, (String)"stackTrace");
        ClassAliasPool.CLASS_ALIASES.addAlias(WireSerializedLambda.class, "SerializedLambda");
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableFunction.class, "Function");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableBiFunction.class, "BiFunction");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableConsumer.class, "Consumer");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializablePredicate.class, "Predicate");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableUpdater.class, "Updater");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableUpdaterWithArg.class, "UpdaterWithArg");
        ClassAliasPool.CLASS_ALIASES.addAlias(VanillaFieldInfo.class, "FieldInfo");
        ClassAliasPool.CLASS_ALIASES.addAlias(WireSerializedLambda.class, "SerializedLambda");
        ClassAliasPool.CLASS_ALIASES.addAlias((Class[])INTERNABLE.stream().toArray(Class[]::new));
    }

    static class ObjectInterner<T>
    extends FromStringInterner<T> {
        final Class<T> tClass;

        ObjectInterner(Class<T> tClass) {
            super(256);
            this.tClass = tClass;
        }

        @Override
        @NotNull
        protected T getValue(String s) throws IORuntimeException {
            return (T)ObjectUtils.convertTo(this.tClass, (Object)s);
        }
    }
}

