/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import net.openhft.chronicle.wire.LongConverter;

public class NanoTimestampLongConverter
implements LongConverter {
    public static final NanoTimestampLongConverter INSTANCE = new NanoTimestampLongConverter();
    final DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    @Override
    public long parse(CharSequence text) {
        try {
            TemporalAccessor parse = this.dtf.parse(text);
            long time = parse.getLong(ChronoField.EPOCH_DAY) * 86400000000000L;
            if (parse.isSupported(ChronoField.NANO_OF_DAY)) {
                time += parse.getLong(ChronoField.NANO_OF_DAY);
            } else if (parse.isSupported(ChronoField.MICRO_OF_DAY)) {
                time += parse.getLong(ChronoField.MICRO_OF_DAY) * 1000L;
            } else if (parse.isSupported(ChronoField.MILLI_OF_DAY)) {
                time += parse.getLong(ChronoField.MILLI_OF_DAY) * 1000000L;
            } else if (parse.isSupported(ChronoField.SECOND_OF_DAY)) {
                time += parse.getLong(ChronoField.SECOND_OF_DAY) * 1000000000L;
            }
            return time;
        }
        catch (DateTimeParseException dtpe) {
            try {
                long number = Long.parseLong(text.toString());
                if ((double)number < 3.1E10) {
                    if (number != 0L) {
                        System.out.println("In input data, replace " + text + " with a real date.");
                    }
                } else if ((double)number < 3.1E13) {
                    System.out.println("In input data, replace " + text + " with " + this.asString(number * 1000000L));
                } else if ((double)number < 3.1E16) {
                    System.out.println("In input data, replace " + text + " with " + this.asString(number * 1000L));
                } else {
                    System.out.println("In input data, replace " + text + " with " + this.asString(number));
                }
                return number;
            }
            catch (NumberFormatException e) {
                throw dtpe;
            }
        }
    }

    @Override
    public void append(StringBuilder text, long value) {
        if (value <= 0L) {
            text.append(value);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(value / 1000000000L, (int)(value % 1000000000L), ZoneOffset.UTC);
        this.dtf.formatTo(ldt, text);
    }
}

