/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.CountingDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.RawText;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class TextMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    @NotNull
    private final Supplier<MarshallableOut> marshallableOutSupplier;
    private final CountingDocumentContext context = new CountingDocumentContext();
    private final Map<Method, Consumer<Object[]>> visitorConverter = new LinkedHashMap<Method, Consumer<Object[]>>();
    private boolean metaData;

    TextMethodWriterInvocationHandler(@NotNull MarshallableOut marshallableOut) {
        this(() -> marshallableOut);
    }

    public TextMethodWriterInvocationHandler(@NotNull Supplier<MarshallableOut> marshallableOutSupplier) {
        this.marshallableOutSupplier = marshallableOutSupplier;
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("writingDocument") && method.getParameterCount() == 0) {
            MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
            this.context.count = 0;
            return this.context.dc(marshallableOut.writingDocument(this.metaData));
        }
        return super.doInvoke(proxy, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleInvoke(Method method, Object[] args) {
        this.visitorConverter.computeIfAbsent(method, this::buildConverter).accept(args);
        DocumentContext dc = this.context.dc();
        boolean chained = method.getReturnType().isInterface();
        if (dc == null) {
            MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
            dc = marshallableOut.writingDocument(this.metaData);
            if (chained) {
                this.context.dc(dc);
            }
            this.context.local = true;
        }
        try {
            Wire wire = dc.wire();
            this.handleInvoke(method, args, wire);
        }
        catch (Throwable t) {
            dc.rollbackOnClose();
            Jvm.rethrow((Throwable)t);
        }
        finally {
            if (!chained) {
                if (this.context.local) {
                    dc.close();
                    this.context.dc(null);
                    this.context.local = false;
                } else {
                    ++this.context.count;
                }
            }
        }
    }

    private Consumer<Object[]> buildConverter(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length <= 0) {
            return NoOp.INSTANCE;
        }
        for (Annotation anno : parameterAnnotations[0]) {
            if (anno instanceof LongConversion) {
                LongConversion longConversion = (LongConversion)anno;
                LongConverter ic = (LongConverter)ObjectUtils.newInstance(longConversion.value());
                return a -> {
                    if (a[0] instanceof Number) {
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ic.append(sb, ((Number)a[0]).longValue());
                        a[0] = new RawText(sb);
                    }
                };
            }
            if (!(anno instanceof IntConversion)) continue;
            IntConversion intConversion = (IntConversion)anno;
            IntConverter ic = (IntConverter)ObjectUtils.newInstance(intConversion.value());
            return a -> {
                if (a[0] instanceof Number) {
                    StringBuilder sb = Wires.acquireStringBuilder();
                    ic.append(sb, ((Number)a[0]).intValue());
                    a[0] = new RawText(sb);
                }
            };
        }
        return NoOp.INSTANCE;
    }

    static enum NoOp implements Consumer<Object[]>
    {
        INSTANCE;


        @Override
        public void accept(Object[] objects) {
        }
    }
}

