/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptor;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMethodTester<T> {
    private static final boolean REGRESS_TESTS = Jvm.getBoolean((String)"regress.tests");
    private final String input;
    private final Class<T> outputClass;
    private final String output;
    private final Function<T, Object> componentFunction;
    private BiConsumer<MethodReader, T> exceptionHandlerSetup;
    private String genericEvent;
    private String setup;
    private Function<String, String> afterRun;
    private String expected;
    private String actual;
    private String[] retainLast;
    private MethodWriterListener methodWriterListener;
    private MethodReaderInterceptorReturns methodReaderInterceptorReturns;
    private long timeoutMS = 25L;
    private UpdateInterceptor updateInterceptor;

    public TextMethodTester(String input, Function<T, Object> componentFunction, Class<T> outputClass, String output) {
        this.input = input;
        this.outputClass = outputClass;
        this.output = output;
        this.componentFunction = componentFunction;
    }

    public String[] retainLast() {
        return this.retainLast;
    }

    @NotNull
    public TextMethodTester retainLast(String ... retainLast) {
        this.retainLast = retainLast;
        return this;
    }

    public String setup() {
        return this.setup;
    }

    @NotNull
    public TextMethodTester setup(String setup) {
        this.setup = setup;
        return this;
    }

    public Function<String, String> afterRun() {
        return this.afterRun;
    }

    @NotNull
    public TextMethodTester afterRun(Function<String, String> afterRun) {
        this.afterRun = afterRun;
        return this;
    }

    public BiConsumer<MethodReader, T> exceptionHandlerSetup() {
        return this.exceptionHandlerSetup;
    }

    public TextMethodTester exceptionHandlerSetup(BiConsumer<MethodReader, T> exceptionHandlerSetup) {
        this.exceptionHandlerSetup = exceptionHandlerSetup;
        return this;
    }

    public String genericEvent() {
        return this.genericEvent;
    }

    public TextMethodTester genericEvent(String genericEvent) {
        this.genericEvent = genericEvent;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TextMethodTester run() throws IOException {
        String originalExpected;
        Object[] components;
        Object component;
        Wire wire2;
        block41: {
            Object[] objectArray;
            wire2 = this.createWire((Bytes)Bytes.allocateElasticOnHeap());
            MethodWriterBuilder<T> methodWriterBuilder = wire2.methodWriterBuilder(this.outputClass);
            if (this.methodWriterListener != null) {
                UpdateInterceptor interceptor = (name, o) -> this.methodWriterListener.onWrite(name, new Object[]{o});
                methodWriterBuilder.updateInterceptor(interceptor);
            }
            if (this.updateInterceptor != null) {
                methodWriterBuilder.updateInterceptor(this.updateInterceptor);
            }
            if (this.genericEvent != null) {
                methodWriterBuilder.genericEvent(this.genericEvent);
            }
            Object writer0 = methodWriterBuilder.get();
            Object writer = this.retainLast == null ? writer0 : this.cachedMethodWriter(writer0);
            component = this.componentFunction.apply(writer);
            if (component instanceof Object[]) {
                objectArray = (Object[])component;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = component;
            }
            components = objectArray;
            if (this.setup != null) {
                Wire wire0 = this.createWire(BytesUtil.readFile((String)this.setup));
                MethodReader reader0 = wire0.methodReaderBuilder().methodReaderInterceptorReturns(this.methodReaderInterceptorReturns).warnMissing(true).build(components);
                while (reader0.readOne()) {
                    wire2.bytes().clear();
                }
                wire2.bytes().clear();
            }
            Wire wire = this.createWire(BytesUtil.readFile((String)this.input));
            this.expected = this.retainLast == null ? BytesUtil.readFile((String)this.output).toString().trim().replace("\r", "") : this.loadLastValues().toString().trim();
            originalExpected = this.expected;
            MethodReader reader = wire.methodReaderBuilder().methodReaderInterceptorReturns(this.methodReaderInterceptorReturns).warnMissing(true).build(components);
            if (this.exceptionHandlerSetup != null) {
                this.exceptionHandlerSetup.accept(reader, (MethodReader)writer);
            }
            TextMethodWriterInvocationHandler.ENABLE_EOD = false;
            try {
                long pos = -1L;
                while (reader.readOne()) {
                    if (pos == wire.bytes().readPosition()) {
                        Jvm.warn().on(this.getClass(), "Bailing out of malformed message");
                        break;
                    }
                    Bytes<?> bytes2 = wire2.bytes();
                    if (this.retainLast == null) {
                        int last;
                        if (bytes2.writePosition() > 0L && (last = bytes2.peekUnsignedByte(bytes2.writePosition() - 1L)) >= 32) {
                            bytes2.append('\n');
                        }
                        bytes2.append((CharSequence)"---\n");
                    }
                    pos = bytes2.readPosition();
                }
                if (this.retainLast != null) {
                    wire2.bytes().clear();
                }
                if (this.retainLast == null) break block41;
                CachedInvocationHandler invocationHandler = (CachedInvocationHandler)Proxy.getInvocationHandler(writer);
                try {
                    invocationHandler.flush();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            finally {
                TextMethodWriterInvocationHandler.ENABLE_EOD = true;
            }
        }
        if (component instanceof Closeable) {
            Closeable.closeQuietly((Object[])components);
        }
        this.actual = wire2.toString().trim();
        if (REGRESS_TESTS) {
            Jvm.pause((long)100L);
            this.expected = this.actual = wire2.toString().trim();
        } else {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + this.timeoutMS && this.actual.length() < this.expected.length()) {
                Jvm.pause((long)25L);
                this.actual = wire2.toString().trim();
            }
        }
        if (this.afterRun != null) {
            this.expected = this.afterRun.apply(this.expected);
            this.actual = this.afterRun.apply(this.actual);
        }
        if (REGRESS_TESTS && !originalExpected.equals(this.expected)) {
            String output2;
            System.err.println("The expected output for " + this.output + " has been updated, check your commits");
            try {
                output2 = BytesUtil.findFile((String)this.output);
            }
            catch (FileNotFoundException fnfe) {
                try {
                    output2 = BytesUtil.findFile((String)this.input.replace("in.yaml", "out.yaml"));
                }
                catch (FileNotFoundException e) {
                    throw fnfe;
                }
            }
            try (FileWriter fw = new FileWriter(output2);){
                String actual2;
                String string = actual2 = this.actual.endsWith("\n") ? this.actual : this.actual + "\n";
                if (OS.isWindows()) {
                    actual2 = actual2.replace("\n", "\r\n");
                }
                fw.write(actual2);
            }
        }
        return this;
    }

    protected Wire createWire(Bytes bytes) {
        return new TextWire(bytes).useTextDocuments().addTimeStamps(true);
    }

    @NotNull
    protected StringBuilder loadLastValues() throws IOException {
        Wire wireOut = this.createWire(BytesUtil.readFile((String)this.output));
        TreeMap<String, String> events = new TreeMap<String, String>();
        this.consumeDocumentSeparator(wireOut);
        while (wireOut.hasMore()) {
            StringBuilder event = new StringBuilder();
            long start = wireOut.bytes().readPosition();
            Map<String, Object> m = wireOut.read(event).marshallableAsMap(String.class, Object.class);
            assert (m != null);
            StringBuilder key = new StringBuilder(event);
            for (String s : this.retainLast) {
                key.append(",").append(m.get(s));
            }
            long end = wireOut.bytes().readPosition();
            BytesStore bytesStore = wireOut.bytes().subBytes(start, end - start);
            events.put(key.toString(), bytesStore.toString().trim());
            bytesStore.releaseLast();
            this.consumeDocumentSeparator(wireOut);
        }
        StringBuilder expected2 = new StringBuilder();
        for (String s : events.values()) {
            expected2.append(s.replace("\r", "")).append("\n");
        }
        return expected2;
    }

    private void consumeDocumentSeparator(@NotNull Wire wireOut) {
        if (wireOut.bytes().peekUnsignedByte() == 45) {
            wireOut.bytes().readSkip(3L);
        }
    }

    @NotNull
    private T cachedMethodWriter(T writer0) {
        Class[] interfaces = new Class[]{this.outputClass};
        return (T)Proxy.newProxyInstance(this.outputClass.getClassLoader(), interfaces, (InvocationHandler)new CachedInvocationHandler(writer0));
    }

    public String expected() {
        return this.expected;
    }

    public String actual() {
        return this.actual;
    }

    @Deprecated
    public TextMethodTester<T> methodWriterListener(MethodWriterListener methodWriterListener) {
        this.methodWriterListener = methodWriterListener;
        return this;
    }

    public TextMethodTester<T> updateInterceptor(UpdateInterceptor updateInterceptor) {
        this.updateInterceptor = updateInterceptor;
        return this;
    }

    @Deprecated
    public TextMethodTester<T> methodReaderInterceptor(MethodReaderInterceptor methodReaderInterceptor) {
        this.methodReaderInterceptorReturns = (m, o, a, i) -> {
            methodReaderInterceptor.intercept(m, o, a, i);
            return null;
        };
        return this;
    }

    public TextMethodTester<T> methodReaderInterceptorReturns(MethodReaderInterceptorReturns methodReaderInterceptorReturns) {
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        return this;
    }

    public TextMethodTester<T> timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    @Deprecated
    class CachedInvocationHandler
    implements InvocationHandler {
        private final Map<String, Invocation> cache = new TreeMap<String, Invocation>();
        private final T writer0;

        public CachedInvocationHandler(T writer0) {
            this.writer0 = writer0;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, @NotNull Method method, @Nullable Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (args != null && args.length == 1 && args[0] instanceof Marshallable) {
                StringBuilder key = new StringBuilder();
                key.append(method.getName());
                Marshallable m = (Marshallable)args[0];
                try {
                    for (String s : TextMethodTester.this.retainLast) {
                        key.append(",").append(m.getField(s, Object.class));
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                args[0] = m.deepCopy();
                this.cache.put(key.toString(), new Invocation(method, args));
            } else {
                method.invoke(this.writer0, args);
            }
            return null;
        }

        public void flush() throws InvocationTargetException, IllegalAccessException {
            for (Invocation invocation : this.cache.values()) {
                invocation.method.invoke(this.writer0, invocation.args);
            }
        }
    }

    @Deprecated
    static class Invocation {
        Method method;
        Object[] args;

        public Invocation(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }
    }
}

