/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Annotations;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import net.openhft.chronicle.wire.MethodWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ReflectionUtil;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaMethodReader
implements MethodReader {
    static final Object[] NO_ARGS = new Object[0];
    static final Logger LOGGER = LoggerFactory.getLogger(VanillaMethodReader.class);
    static final Object IGNORED = new Object();
    private static final boolean DONT_THROW_ON_OVERLOAD = Jvm.getBoolean((String)"chronicle.mr_overload_dont_throw");
    private static final String[] metaIgnoreList = new String[]{"header", "index", "index2index", "roll"};
    private final MarshallableIn in;
    @NotNull
    private final WireParser wireParser;
    private final MessageHistory messageHistory = MessageHistory.get();
    private boolean closeIn = false;
    private boolean closed;
    private MethodReaderInterceptorReturns methodReaderInterceptorReturns;

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object ... objects) {
        this(in, ignoreDefault, defaultParselet, VanillaWireParser.SKIP_READABLE_BYTES, methodReaderInterceptorReturns, objects);
    }

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object ... objects) {
        this.in = in;
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        if (objects[0] instanceof WireParselet) {
            defaultParselet = (WireParselet)objects[0];
        }
        this.wireParser = WireParser.wireParser(defaultParselet, fieldNumberParselet);
        @NotNull HashSet<String> methodsSignaturesHandled = new HashSet<String>();
        @NotNull HashSet<String> methodsNamesHandled = new HashSet<String>();
        MethodFilterOnFirstArg methodFilterOnFirstArg = null;
        for (Object o : objects) {
            if (o instanceof MethodFilterOnFirstArg) {
                if (methodFilterOnFirstArg != null) {
                    Jvm.warn().on(this.getClass(), "Multiple filters on first arg not supported, only the first one is applied.");
                } else {
                    methodFilterOnFirstArg = (MethodFilterOnFirstArg)o;
                }
            }
            Class<?> oClass = o.getClass();
            Object[] context = new Object[]{null};
            Supplier<Object> original = () -> o;
            Supplier<Object> inarray = () -> context[0];
            LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
            for (Class<?> anInterface : ReflectionUtil.interfaces(oClass)) {
                this.addParsletsFor(interfaces, anInterface, ignoreDefault, methodsNamesHandled, methodsSignaturesHandled, methodFilterOnFirstArg, o, context, original, inarray);
            }
        }
        if (this.wireParser.lookup("history") == null) {
            this.wireParser.registerOnce(() -> "history", (s, v) -> v.marshallable(this.messageHistory));
        }
    }

    private static LongConversion longConversionForFirstParam(Method m) {
        Annotation[][] annotations = m.getParameterAnnotations();
        if (annotations == null || annotations.length < 1 || annotations[0].length < 1) {
            return null;
        }
        for (Annotation annotation : annotations[0]) {
            if (!(annotation instanceof LongConversion)) continue;
            return (LongConversion)annotation;
        }
        return null;
    }

    private static void invokeMethodWithOneLong(Object o, Object[] context, @NotNull Method m, String name, MethodHandle mh, Object[] argArr, CharSequence s, ValueIn v, MethodReaderInterceptorReturns methodReaderInterceptor) {
        block12: {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s, v);
                }
                long arg = 0L;
                if (v.isBinary()) {
                    arg = v.int64();
                } else {
                    LongConversion lc = VanillaMethodReader.longConversionForFirstParam(m);
                    if (lc == null) {
                        arg = v.int64();
                    } else {
                        String text = v.text();
                        if (text != null && !text.isEmpty()) {
                            LongConverter longConverter = (LongConverter)ObjectUtils.newInstance(lc.value());
                            arg = longConverter.parse(text);
                        }
                    }
                }
                try {
                    if (methodReaderInterceptor != null) {
                        argArr[0] = arg;
                        Object intercept = methodReaderInterceptor.intercept(m, o, argArr, VanillaMethodReader::actualInvoke);
                        context[0] = intercept == null ? o : intercept;
                        break block12;
                    }
                    mh.invokeExact(arg);
                }
                catch (Throwable e) {
                    Throwable cause = e.getCause();
                    String msg = "Failure to dispatch message: " + m.getName() + " " + Arrays.asList(argArr);
                    if (cause instanceof IllegalArgumentException) {
                        Jvm.warn().on(o.getClass(), msg + " " + cause);
                        break block12;
                    }
                    Jvm.warn().on(o.getClass(), msg, cause);
                }
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + argArr[0], (Throwable)i);
            }
        }
    }

    private static Object actualInvoke(Method method, Object o, Object[] objects) throws InvocationTargetException {
        try {
            return method.invoke(o, objects);
        }
        catch (IllegalAccessException iae) {
            throw Jvm.rethrow((Throwable)iae);
        }
    }

    protected static void logMessage(@NotNull CharSequence s, @NotNull ValueIn v) {
        String rest;
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        @NotNull String name = s.toString();
        if (v.wireIn() instanceof BinaryWire) {
            Bytes bytes = Bytes.elasticByteBuffer((int)((int)(v.wireIn().bytes().readRemaining() * 3L / 2L + 64L)));
            long pos = v.wireIn().bytes().readPosition();
            v.wireIn().copyTo(new TextWire(bytes));
            v.wireIn().bytes().readPosition(pos);
            rest = bytes.toString();
            bytes.releaseLast();
        } else {
            rest = v.toString();
        }
        if (rest.endsWith("\n")) {
            rest = rest.substring(0, rest.length() - 1);
        }
        LOGGER.debug("read " + name + " - " + rest);
    }

    private void addParsletsFor(Set<Class> interfaces, Class<?> oClass, boolean ignoreDefault, Set<String> methodNamesHandled, Set<String> methodsSignaturesHandled, MethodFilterOnFirstArg methodFilterOnFirstArg, Object o, Object[] context, Supplier contextSupplier, Supplier nextContext) {
        if (!interfaces.add(oClass)) {
            return;
        }
        block6: for (Method m : oClass.getMethods()) {
            Class<?> declaringClass = m.getDeclaringClass();
            if (declaringClass == Object.class || Modifier.isStatic(m.getModifiers()) || ignoreDefault && declaringClass.isInterface() || "ignoreMethodBasedOnFirstArg".equals(m.getName()) || !methodsSignaturesHandled.add(this.signature(m))) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!methodNamesHandled.add(m.getName())) {
                    String previous = methodsSignaturesHandled.stream().filter(signature -> signature.contains(" " + m.getName() + " ")).findFirst().orElseThrow(() -> new IllegalStateException());
                    String msg = m.toString() + " previous: " + previous;
                    if (DONT_THROW_ON_OVERLOAD) {
                        Jvm.warn().on(this.getClass(), "Unable to support overloaded methods, ignoring " + msg);
                        continue;
                    }
                    throw new IllegalStateException("MethodReader does not support overloaded methods. Method: " + msg);
                }
                Class[] parameterTypes = m.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        this.addParseletForMethod(o, context, contextSupplier, m);
                        continue block6;
                    }
                    case 1: {
                        this.addParseletForMethod(o, context, contextSupplier, m, parameterTypes[0]);
                        continue block6;
                    }
                    default: {
                        if (methodFilterOnFirstArg == null) {
                            this.addParseletForMethod(o, context, contextSupplier, m, parameterTypes);
                            continue block6;
                        }
                        this.addParseletForMethod(o, context, contextSupplier, m, parameterTypes, methodFilterOnFirstArg);
                    }
                }
            }
        }
        for (Method m : oClass.getMethods()) {
            Class<?> returnType = m.getReturnType();
            if (!returnType.isInterface() || Jvm.dontChain(returnType)) continue;
            this.addParsletsFor(interfaces, returnType, ignoreDefault, methodNamesHandled, methodsSignaturesHandled, methodFilterOnFirstArg, null, context, nextContext, nextContext);
        }
    }

    private String signature(Method m) {
        return m.getReturnType() + " " + m.getName() + " " + Arrays.toString(m.getParameterTypes());
    }

    @NotNull
    public VanillaMethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    public void addParseletForMethod(Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m, Class<?> parameterType) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        String name = m.getName();
        if (parameterType == Long.TYPE && o2 != null) {
            try {
                MethodHandle mh = MethodHandles.lookup().unreflect(m).bindTo(o2);
                Object[] argArr = new Object[]{null};
                MethodWireKey key = this.createWireKey(m, name);
                this.wireParser.registerOnce(key, (s, v) -> VanillaMethodReader.invokeMethodWithOneLong(o2, context, m, name, mh, argArr, s, v, this.methodReaderInterceptorReturns));
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(o2.getClass(), "Unable to unreflect " + m, (Throwable)e);
            }
        } else if (parameterType.isPrimitive() || parameterType.isInterface() || !ReadMarshallable.class.isAssignableFrom(parameterType)) {
            Object[] argArr = new Object[]{null};
            MethodWireKey key = this.createWireKey(m, name);
            this.wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$7(argArr, parameterType, (Supplier)contextSupplier, m, context, o2, name, arg_0, arg_1));
        } else {
            ReadMarshallable arg;
            try {
                Constructor<?> constructor = parameterType.getDeclaredConstructor(new Class[0]);
                Jvm.setAccessible(constructor);
                arg = (ReadMarshallable)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                try {
                    arg = (ReadMarshallable)OS.memory().allocateInstance(parameterType);
                }
                catch (InstantiationException e1) {
                    throw Jvm.rethrow((Throwable)e1);
                }
            }
            ReadMarshallable[] argArr = new ReadMarshallable[]{arg};
            MethodWireKey key = this.createWireKey(m, name);
            this.wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$8(argArr, parameterType, (Supplier)contextSupplier, m, context, o2, name, arg_0, arg_1));
        }
    }

    private Class<?> contextClass(Supplier contextSupplier) {
        Object o = contextSupplier.get();
        return o == null ? VanillaMethodReader.class : o.getClass();
    }

    public void addParseletForMethod(Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        String name = m.getName();
        MethodWireKey key = this.createWireKey(m, name);
        this.wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$9((Supplier)contextSupplier, m, context, o2, name, arg_0, arg_1));
    }

    @NotNull
    protected MethodWireKey createWireKey(@NotNull Method m, String name) {
        MethodId annotation = (MethodId)Annotations.getAnnotation((Method)m, MethodId.class);
        return new MethodWireKey(name, annotation == null ? name.hashCode() : Maths.toInt32((long)annotation.value()));
    }

    public void addParseletForMethod(Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m, @NotNull Class[] parameterTypes) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        @NotNull Object[] args = new Object[parameterTypes.length];
        @NotNull BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            for (Class clazz : parameterTypes) {
                a[i] = v.object(this.checkRecycle(a[i]), clazz);
                ++i;
            }
        };
        String name = m.getName();
        MethodWireKey key = this.createWireKey(m, name);
        this.wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$11(args, sequenceReader, (Supplier)contextSupplier, m, context, o2, name, arg_0, arg_1));
    }

    private <T> T checkRecycle(T o) {
        if (o instanceof Collection) {
            ((Collection)o).clear();
            return o;
        }
        return (T)(o instanceof Marshallable ? o : null);
    }

    public void addParseletForMethod(Object o2, Object[] context, Supplier contextSupplier, @NotNull Method m, @NotNull Class[] parameterTypes, MethodFilterOnFirstArg methodFilterOnFirstArg) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)m);
        @NotNull Object[] args = new Object[parameterTypes.length];
        @NotNull BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            boolean ignored = false;
            for (Class clazz : parameterTypes) {
                if (ignored) {
                    v.skipValue();
                } else {
                    a[i] = v.object(this.checkRecycle(a[i]), clazz);
                }
                if (i == 0 && methodFilterOnFirstArg.ignoreMethodBasedOnFirstArg(m.getName(), a[0])) {
                    a[0] = IGNORED;
                    ignored = true;
                }
                ++i;
            }
        };
        String name = m.getName();
        MethodWireKey key = this.createWireKey(m, name);
        this.wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$13(args, sequenceReader, (Supplier)contextSupplier, m, context, o2, name, arg_0, arg_1));
    }

    protected Object invoke(Object o, @NotNull Method m, Object[] args) {
        try {
            if (this.methodReaderInterceptorReturns != null) {
                return this.methodReaderInterceptorReturns.intercept(m, o, args, VanillaMethodReader::actualInvoke);
            }
            return m.invoke(o, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            String msg = "Failure to dispatch message: " + m.getName() + " " + Arrays.asList(args);
            if (cause instanceof IllegalArgumentException) {
                Jvm.warn().on(o.getClass(), msg + " " + cause);
            } else {
                Jvm.warn().on(o.getClass(), msg, cause);
            }
            return null;
        }
    }

    public boolean readOne() {
        this.throwExceptionIfClosed();
        return this.readOne0();
    }

    public boolean lazyReadOne() {
        this.throwExceptionIfClosed();
        if (!this.in.peekDocument()) {
            return false;
        }
        return this.readOne0();
    }

    private boolean readOne0() {
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (context.isMetaData()) {
                this.readOneMetaData(context);
                boolean bl = true;
                return bl;
            }
            assert (context.isData());
            this.messageHistory.reset(context.sourceId(), context.index());
            this.wireParser.accept(context.wire());
        }
        return true;
    }

    private boolean readOneMetaData(DocumentContext context) {
        StringBuilder sb = Wires.acquireStringBuilder();
        Wire wire = context.wire();
        Bytes<?> bytes = wire.bytes();
        long r = bytes.readPosition();
        wire.readEventName(sb);
        for (String s : metaIgnoreList) {
            if (!s.contentEquals(sb)) continue;
            return false;
        }
        bytes.readPosition(r);
        this.wireParser.accept(wire);
        return true;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        this.throwExceptionIfClosed();
        return this.methodReaderInterceptorReturns;
    }

    @NotNull
    protected WireParser wireParser() {
        return this.wireParser;
    }

    private /* synthetic */ void lambda$addParseletForMethod$13(Object[] args, BiConsumer sequenceReader, Supplier contextSupplier, Method m, Object[] context, Object o2, String name, CharSequence s, ValueIn v) {
        try {
            if (Jvm.isDebug()) {
                VanillaMethodReader.logMessage(s, v);
            }
            v.sequence(args, sequenceReader);
            if (args[0] == IGNORED) {
                args[0] = null;
                return;
            }
            Object invoke = this.invoke(contextSupplier.get(), m, args);
            if (invoke != null) {
                context[0] = invoke;
            }
            if (o2 != null) {
                context[0] = o2;
            }
        }
        catch (Exception i) {
            Jvm.warn().on(this.contextClass(contextSupplier), "Failure to dispatch message: " + name + " " + Arrays.toString(args), (Throwable)i);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$11(Object[] args, BiConsumer sequenceReader, Supplier contextSupplier, Method m, Object[] context, Object o2, String name, CharSequence s, ValueIn v) {
        try {
            if (Jvm.isDebug()) {
                VanillaMethodReader.logMessage(s, v);
            }
            v.sequence(args, sequenceReader);
            Object invoke = this.invoke(contextSupplier.get(), m, args);
            if (invoke != null) {
                context[0] = invoke;
            }
            if (o2 != null) {
                context[0] = o2;
            }
        }
        catch (Exception i) {
            Jvm.warn().on(this.contextClass(contextSupplier), "Failure to dispatch message: " + name + " " + Arrays.toString(args), (Throwable)i);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$9(Supplier contextSupplier, Method m, Object[] context, Object o2, String name, CharSequence s, ValueIn v) {
        try {
            if (Jvm.isDebug()) {
                VanillaMethodReader.logMessage(s, v);
            }
            v.skipValue();
            Object invoke = this.invoke(contextSupplier.get(), m, NO_ARGS);
            if (invoke != null) {
                context[0] = invoke;
            }
            if (o2 != null) {
                context[0] = o2;
            }
        }
        catch (Exception i) {
            Jvm.warn().on(this.contextClass(contextSupplier), "Failure to dispatch message: " + name + "()", (Throwable)i);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$8(ReadMarshallable[] argArr, Class parameterType, Supplier contextSupplier, Method m, Object[] context, Object o2, String name, CharSequence s, ValueIn v) {
        try {
            if (Jvm.isDebug()) {
                VanillaMethodReader.logMessage(s, v);
            }
            argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType);
            Object invoke = this.invoke(contextSupplier.get(), m, argArr);
            if (invoke != null) {
                context[0] = invoke;
            } else if (o2 != null) {
                context[0] = o2;
            }
        }
        catch (Throwable t) {
            Jvm.warn().on(this.contextClass(contextSupplier), "Failure to dispatch message: " + name + " " + argArr[0], t);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$7(Object[] argArr, Class parameterType, Supplier contextSupplier, Method m, Object[] context, Object o2, String name, CharSequence s, ValueIn v) {
        try {
            if (Jvm.isDebug()) {
                VanillaMethodReader.logMessage(s, v);
            }
            argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType);
            Object invoke = this.invoke(contextSupplier.get(), m, argArr);
            if (invoke != null) {
                context[0] = invoke;
            } else if (o2 != null) {
                context[0] = o2;
            }
        }
        catch (Exception i) {
            Jvm.warn().on(this.contextClass(contextSupplier), "Failure to dispatch message: " + name + " " + argArr[0], (Throwable)i);
        }
    }
}

