/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesComment;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractCommonMarshallable;
import net.openhft.chronicle.wire.CharConversion;
import net.openhft.chronicle.wire.CharConverter;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.CommentAnnotationNotifier;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireMarshallerForUnexpectedFields;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireMarshaller<T> {
    public static final Class[] UNEXPECTED_FIELDS_PARAMETER_TYPES = new Class[]{Object.class, ValueIn.class};
    private static final FieldAccess[] NO_FIELDS = new FieldAccess[0];
    public static final ClassLocal<WireMarshaller> WIRE_MARSHALLER_CL = ClassLocal.withInitial(tClass -> Throwable.class.isAssignableFrom((Class<?>)tClass) ? WireMarshaller.ofThrowable(tClass) : WireMarshaller.of(tClass));
    private static final StringBuilderPool RSBP = new StringBuilderPool();
    private static final StringBuilderPool WSBP = new StringBuilderPool();
    @NotNull
    final FieldAccess[] fields;
    static final StringBuilderPool SBP = new StringBuilderPool();
    final TreeMap<CharSequence, FieldAccess> fieldMap = new TreeMap(WireMarshaller::compare);
    private final boolean isLeaf;
    @Nullable
    private final T defaultValue;

    protected WireMarshaller(@NotNull Class<T> tClass, @NotNull FieldAccess[] fields, boolean isLeaf) {
        this(fields, isLeaf, WireMarshaller.defaultValueForType(tClass));
    }

    private WireMarshaller(@NotNull FieldAccess[] fields, boolean isLeaf, @Nullable T defaultValue) {
        this.fields = fields;
        this.isLeaf = isLeaf;
        this.defaultValue = defaultValue;
        for (FieldAccess field : fields) {
            this.fieldMap.put(field.key.name(), field);
        }
    }

    @NotNull
    public static <T> WireMarshaller<T> of(@NotNull Class<T> tClass) {
        if (tClass.isInterface() || tClass.isEnum()) {
            return new WireMarshaller<T>(tClass, NO_FIELDS, true);
        }
        @NotNull LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        WireMarshaller.getAllField(tClass, map);
        FieldAccess[] fields = (FieldAccess[])map.values().stream().map(FieldAccess::create).toArray(FieldAccess[]::new);
        Map<String, Long> fieldCount = Stream.of(fields).collect(Collectors.groupingBy(f -> f.field.getName(), Collectors.counting()));
        fieldCount.forEach((n, c) -> {
            if (c > 1L) {
                Jvm.warn().on(tClass, "Has " + c + " fields called '" + n + "'");
            }
        });
        boolean isLeaf = Stream.of(fields).noneMatch(c -> WireMarshaller.isCollection(c.field.getType()) && !Boolean.TRUE.equals(c.isLeaf) || WriteMarshallable.class.isAssignableFrom(c.field.getType()));
        return WireMarshaller.overridesUnexpectedFields(tClass) ? new WireMarshallerForUnexpectedFields<T>(tClass, fields, isLeaf) : new WireMarshaller<T>(tClass, fields, isLeaf);
    }

    private static <T> boolean overridesUnexpectedFields(Class<T> tClass) {
        try {
            Method method = tClass.getMethod("unexpectedField", UNEXPECTED_FIELDS_PARAMETER_TYPES);
            return method.getDeclaringClass() != ReadMarshallable.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @NotNull
    private static <T> WireMarshaller<T> ofThrowable(@NotNull Class<T> tClass) {
        @NotNull LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        WireMarshaller.getAllField(tClass, map);
        FieldAccess[] fields = (FieldAccess[])map.values().stream().map(FieldAccess::create).toArray(FieldAccess[]::new);
        boolean isLeaf = false;
        return new WireMarshaller<T>(tClass, fields, isLeaf);
    }

    private static boolean isCollection(@NotNull Class<?> c) {
        return c.isArray() || Collection.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c);
    }

    public static void getAllField(@NotNull Class clazz, @NotNull Map<String, Field> map) {
        if (clazz != Object.class && clazz != AbstractCommonMarshallable.class) {
            WireMarshaller.getAllField(clazz.getSuperclass(), map);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            String name = field.getName();
            if (name.equals("this$0")) {
                Jvm.warn().on(WireMarshaller.class, "Found this$0, in " + clazz + " which will be ignored!");
                continue;
            }
            Jvm.setAccessible((AccessibleObject)field);
            map.put(name, field);
        }
    }

    private static <T> T defaultValueForType(@NotNull Class<T> tClass) {
        return (T)(ObjectUtils.isConcreteClass(tClass) && !tClass.getName().startsWith("java") && !tClass.isEnum() && !tClass.isArray() ? ObjectUtils.newInstance(tClass) : null);
    }

    public WireMarshaller<T> excludeFields(String ... fieldNames) {
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fieldNames));
        return new WireMarshaller<T>((FieldAccess[])Stream.of(this.fields).filter(f -> !fieldSet.contains(f.field.getName())).toArray(FieldAccess[]::new), this.isLeaf, this.defaultValue);
    }

    public void writeMarshallable(T t, @NotNull WireOut out) {
        BytesComment<?> bytes = out.bytesComment();
        bytes.indent(1);
        try {
            boolean retainsComments = bytes.retainsComments();
            for (FieldAccess field : this.fields) {
                if (retainsComments) {
                    bytes.comment((CharSequence)field.field.getName());
                }
                field.write(t, out);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        bytes.indent(-1);
    }

    public void writeMarshallable(T t, Bytes bytes) {
        for (FieldAccess field : this.fields) {
            try {
                field.getAsBytes(t, bytes);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public void writeMarshallable(T t, @NotNull WireOut out, T previous, boolean copy) {
        try {
            for (FieldAccess field : this.fields) {
                field.write(t, out, previous, copy);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static int compare(CharSequence cs0, CharSequence cs1) {
        int len = Math.min(cs0.length(), cs1.length());
        for (int i = 0; i < len; ++i) {
            int cmp = Character.compare(cs0.charAt(i), cs1.charAt(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(cs0.length(), cs1.length());
    }

    public void readMarshallable(T t, @NotNull WireIn in, T defaults, boolean overwrite) {
        if (in.hintReadInputOrder()) {
            this.readMarshallableInputOrder(t, in, defaults, overwrite);
        } else {
            this.readMarshallableDTOOrder(t, in, defaults, overwrite);
        }
    }

    public void readMarshallableDTOOrder(T t, @NotNull WireIn in, T defaults, boolean overwrite) {
        try {
            for (FieldAccess field : this.fields) {
                ValueIn vin = in.read(field.key);
                field.readValue(t, defaults, vin, overwrite);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void readMarshallableInputOrder(T t, @NotNull WireIn in, T defaults, boolean overwrite) {
        try {
            StringBuilder sb = SBP.acquireStringBuilder();
            for (int i = 0; i < this.fields.length; ++i) {
                ValueIn vin;
                boolean more = in.hasMore();
                FieldAccess field = this.fields[i];
                ValueIn valueIn = vin = more ? in.read(sb) : null;
                if (more && this.matchesFieldName(sb, field)) {
                    field.readValue(t, defaults, in.getValueIn(), overwrite);
                    continue;
                }
                while (i < this.fields.length) {
                    FieldAccess field2 = this.fields[i];
                    field2.copy(defaults, t);
                    ++i;
                }
                if (vin == null || sb.length() <= 0) {
                    return;
                }
                do {
                    FieldAccess fieldAccess;
                    if ((fieldAccess = this.fieldMap.get(sb)) == null) {
                        vin.skipValue();
                    } else {
                        fieldAccess.readValue(t, defaults, vin, overwrite);
                    }
                    vin = in.read(sb);
                } while (in.hasMore());
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean matchesFieldName(StringBuilder sb, FieldAccess field) {
        return sb.length() == 0 || StringUtils.isEqual((CharSequence)field.field.getName(), (CharSequence)sb);
    }

    public void writeKey(T t, Bytes bytes) {
        try {
            this.fields[0].getAsBytes(t, bytes);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isEqual(Object o1, Object o2) {
        for (FieldAccess field : this.fields) {
            if (field.isEqual(o1, o2)) continue;
            return false;
        }
        return true;
    }

    public Object getField(Object o, String name) throws NoSuchFieldException {
        try {
            for (FieldAccess field : this.fields) {
                if (!field.field.getName().equals(name)) continue;
                return field.field.get(o);
            }
            throw new NoSuchFieldException(name);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setField(Object o, String name, Object value) throws NoSuchFieldException {
        try {
            for (FieldAccess field : this.fields) {
                @NotNull Field field2 = field.field;
                if (!field2.getName().equals(name)) continue;
                value = ObjectUtils.convertTo(field2.getType(), (Object)value);
                field2.set(o, value);
                return;
            }
            throw new NoSuchFieldException(name);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public T defaultValue() {
        return this.defaultValue;
    }

    public void reset(T o) {
        try {
            for (FieldAccess field : this.fields) {
                field.copy(this.defaultValue, o);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    static class DoubleFieldAccess
    extends FieldAccess {
        DoubleFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.float64(UnsafeMemory.UNSAFE.getDouble(o, this.offset));
            } else {
                write.float64(UnsafeMemory.UNSAFE.getDouble(o, this.offset), UnsafeMemory.UNSAFE.getDouble(previous, this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            double v = overwrite ? read.float64() : read.float64(UnsafeMemory.UNSAFE.getDouble(o, this.offset));
            UnsafeMemory.UNSAFE.putDouble(o, this.offset, v);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeDouble(UnsafeMemory.UNSAFE.getDouble(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return Maths.same((double)UnsafeMemory.UNSAFE.getDouble(o, this.offset), (double)UnsafeMemory.UNSAFE.getDouble(o2, this.offset));
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putDouble(to, this.offset, UnsafeMemory.UNSAFE.getDouble(from, this.offset));
        }
    }

    static class LongConversionFieldAccess
    extends FieldAccess {
        @NotNull
        private final LongConverter longConverter;

        LongConversionFieldAccess(@NotNull Field field, @NotNull LongConversion longConversion) {
            super(field);
            this.longConverter = (LongConverter)ObjectUtils.newInstance(longConversion.value());
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            long aLong = UnsafeMemory.UNSAFE.getLong(o, this.offset);
            if (write.isBinary()) {
                write.int64(aLong);
            } else {
                StringBuilder sb = WSBP.acquireStringBuilder();
                this.longConverter.append(sb, aLong);
                write.rawText(sb);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            long i;
            if (read.isBinary()) {
                i = read.int64();
            } else {
                StringBuilder sb = RSBP.acquireStringBuilder();
                read.text(sb);
                i = this.longConverter.parse(sb);
            }
            UnsafeMemory.UNSAFE.putLong(o, this.offset, i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            StringBuilder sb = WSBP.acquireStringBuilder();
            bytes.readUtf8((Appendable)sb);
            long i = this.longConverter.parse(sb);
            bytes.writeLong(i);
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getLong(o, this.offset) == UnsafeMemory.UNSAFE.getLong(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putLong(to, this.offset, UnsafeMemory.UNSAFE.getLong(from, this.offset));
        }
    }

    static class LongFieldAccess
    extends FieldAccess {
        LongFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.int64(UnsafeMemory.UNSAFE.getLong(o, this.offset));
            } else {
                write.int64(UnsafeMemory.UNSAFE.getLong(o, this.offset), UnsafeMemory.UNSAFE.getLong(previous, this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            long i = overwrite ? read.int64() : read.int64(UnsafeMemory.UNSAFE.getLong(o, this.offset));
            UnsafeMemory.UNSAFE.putLong(o, this.offset, i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeLong(UnsafeMemory.UNSAFE.getLong(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getLong(o, this.offset) == UnsafeMemory.UNSAFE.getLong(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putLong(to, this.offset, UnsafeMemory.UNSAFE.getLong(from, this.offset));
        }
    }

    static class FloatFieldAccess
    extends FieldAccess {
        FloatFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.float32(UnsafeMemory.UNSAFE.getFloat(o, this.offset));
            } else {
                write.float32(UnsafeMemory.UNSAFE.getFloat(o, this.offset), UnsafeMemory.UNSAFE.getFloat(previous, this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            float v = overwrite ? read.float32() : read.float32(UnsafeMemory.UNSAFE.getFloat(o, this.offset));
            UnsafeMemory.UNSAFE.putFloat(o, this.offset, v);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeFloat(UnsafeMemory.UNSAFE.getFloat(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return Maths.same((float)UnsafeMemory.UNSAFE.getFloat(o, this.offset), (float)UnsafeMemory.UNSAFE.getFloat(o2, this.offset));
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putFloat(to, this.offset, UnsafeMemory.UNSAFE.getFloat(from, this.offset));
        }
    }

    static class IntConversionFieldAccess
    extends FieldAccess {
        @NotNull
        private final IntConverter intConverter;

        IntConversionFieldAccess(@NotNull Field field, @NotNull IntConversion intConversion) {
            super(field);
            this.intConverter = (IntConverter)ObjectUtils.newInstance(intConversion.value());
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            int anInt = this.getInt(o);
            if (write.isBinary()) {
                write.int32(anInt);
            } else {
                StringBuilder sb = WSBP.acquireStringBuilder();
                this.intConverter.append(sb, anInt);
                write.rawText(sb);
            }
        }

        protected int getInt(Object o) {
            return UnsafeMemory.UNSAFE.getInt(o, this.offset);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            int i;
            if (read.isBinary()) {
                i = read.int32();
            } else {
                StringBuilder sb = RSBP.acquireStringBuilder();
                read.text(sb);
                i = this.intConverter.parse(sb);
            }
            this.putInt(o, i);
        }

        protected void putInt(Object o, int i) {
            UnsafeMemory.UNSAFE.putInt(o, this.offset, i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            StringBuilder sb = WSBP.acquireStringBuilder();
            bytes.readUtf8((Appendable)sb);
            int i = this.intConverter.parse(sb);
            bytes.writeInt(i);
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return this.getInt(o) == this.getInt(o2);
        }

        @Override
        protected void copy(Object from, Object to) {
            this.putInt(to, this.getInt(from));
        }
    }

    static class CharConversionFieldAccess
    extends CharFieldAccess {
        @NotNull
        private final CharConverter intConverter;

        CharConversionFieldAccess(@NotNull Field field, @NotNull CharConversion charConversion) {
            super(field);
            this.intConverter = (CharConverter)ObjectUtils.newInstance(charConversion.value());
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            StringBuilder sb = WSBP.acquireStringBuilder();
            this.intConverter.append(sb, this.getChar(o));
            write.rawText(sb);
        }

        protected char getChar(Object o) {
            return UnsafeMemory.UNSAFE.getChar(o, this.offset);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            StringBuilder sb = RSBP.acquireStringBuilder();
            read.text(sb);
            char i = this.intConverter.parse(sb);
            this.putChar(o, i);
        }

        protected void putChar(Object o, char i) {
            UnsafeMemory.UNSAFE.putChar(o, this.offset, i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            StringBuilder sb = WSBP.acquireStringBuilder();
            bytes.readUtf8((Appendable)sb);
            char i = this.intConverter.parse(sb);
            bytes.writeInt((int)i);
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return this.getChar(o) == this.getChar(o2);
        }

        @Override
        protected void copy(Object from, Object to) {
            this.putChar(to, this.getChar(from));
        }
    }

    static class ShortIntConversionFieldAccess
    extends IntConversionFieldAccess {
        public ShortIntConversionFieldAccess(@NotNull Field field, @NotNull IntConversion intConversion) {
            super(field, intConversion);
        }

        @Override
        protected int getInt(Object o) {
            return UnsafeMemory.UNSAFE.getShort(o, this.offset) & 0xFFFF;
        }

        @Override
        protected void putInt(Object o, int i) {
            UnsafeMemory.UNSAFE.putShort(o, this.offset, (short)i);
        }
    }

    static class ByteIntConversionFieldAccess
    extends IntConversionFieldAccess {
        public ByteIntConversionFieldAccess(@NotNull Field field, @NotNull IntConversion intConversion) {
            super(field, intConversion);
        }

        @Override
        protected int getInt(Object o) {
            return UnsafeMemory.UNSAFE.getByte(o, this.offset) & 0xFF;
        }

        @Override
        protected void putInt(Object o, int i) {
            UnsafeMemory.UNSAFE.putByte(o, this.offset, (byte)i);
        }
    }

    static class IntegerFieldAccess
    extends FieldAccess {
        IntegerFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, @Nullable Object previous) {
            if (previous == null) {
                write.int32(UnsafeMemory.UNSAFE.getInt(o, this.offset));
            } else {
                write.int32(UnsafeMemory.UNSAFE.getInt(o, this.offset), UnsafeMemory.UNSAFE.getInt(previous, this.offset));
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            int i = overwrite ? read.int32() : read.int32(UnsafeMemory.UNSAFE.getInt(o, this.offset));
            UnsafeMemory.UNSAFE.putInt(o, this.offset, i);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeInt(UnsafeMemory.UNSAFE.getInt(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getInt(o, this.offset) == UnsafeMemory.UNSAFE.getInt(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putInt(to, this.offset, UnsafeMemory.UNSAFE.getInt(from, this.offset));
        }
    }

    static class CharFieldAccess
    extends FieldAccess {
        CharFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            @NotNull StringBuilder sb = WSBP.acquireStringBuilder();
            sb.append(UnsafeMemory.UNSAFE.getChar(o, this.offset));
            write.text(sb);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            String text = read.text();
            if (text == null || text.length() < 1) {
                if (overwrite) {
                    text = "\u0000";
                } else {
                    return;
                }
            }
            UnsafeMemory.UNSAFE.putChar(o, this.offset, text.charAt(0));
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeUnsignedShort((int)UnsafeMemory.UNSAFE.getChar(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getChar(o, this.offset) == UnsafeMemory.UNSAFE.getChar(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putChar(to, this.offset, UnsafeMemory.UNSAFE.getChar(from, this.offset));
        }
    }

    static class ShortFieldAccess
    extends FieldAccess {
        ShortFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.int16(UnsafeMemory.UNSAFE.getShort(o, this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.UNSAFE.putShort(o, this.offset, read.int16());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeShort(UnsafeMemory.UNSAFE.getShort(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getShort(o, this.offset) == UnsafeMemory.UNSAFE.getShort(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putShort(to, this.offset, UnsafeMemory.UNSAFE.getShort(from, this.offset));
        }
    }

    static class ByteFieldAccess
    extends FieldAccess {
        ByteFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.int8(UnsafeMemory.UNSAFE.getByte(o, this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.UNSAFE.putByte(o, this.offset, read.int8());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeByte(UnsafeMemory.UNSAFE.getByte(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getByte(o, this.offset) == UnsafeMemory.UNSAFE.getByte(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putByte(to, this.offset, UnsafeMemory.UNSAFE.getByte(from, this.offset));
        }
    }

    static class BooleanFieldAccess
    extends FieldAccess {
        BooleanFieldAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.bool(UnsafeMemory.UNSAFE.getBoolean(o, this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.UNSAFE.putBoolean(o, this.offset, read.bool());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeBoolean(UnsafeMemory.UNSAFE.getBoolean(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o, Object o2) {
            return UnsafeMemory.UNSAFE.getBoolean(o, this.offset) == UnsafeMemory.UNSAFE.getBoolean(o2, this.offset);
        }

        @Override
        protected void copy(Object from, Object to) {
            UnsafeMemory.UNSAFE.putBoolean(to, this.offset, UnsafeMemory.UNSAFE.getBoolean(from, this.offset));
        }
    }

    static class MapFieldAccess
    extends FieldAccess {
        @NotNull
        final Supplier<Map> collectionSupplier;
        private final Class<?> type;
        @NotNull
        private final Class keyType;
        @NotNull
        private final Class valueType;

        MapFieldAccess(@NotNull Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == Map.class ? LinkedHashMap::new : (this.type == SortedMap.class || this.type == NavigableMap.class ? TreeMap::new : this.newInstance());
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                @NotNull ParameterizedType pType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                this.keyType = MapFieldAccess.extractClass(actualTypeArguments[0]);
                this.valueType = MapFieldAccess.extractClass(actualTypeArguments[1]);
            } else {
                this.keyType = Object.class;
                this.valueType = Object.class;
            }
        }

        @NotNull
        private Supplier<Map> newInstance() {
            return () -> {
                try {
                    return (Map)this.type.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
            };
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Map map = (Map)this.field.get(o);
            write.marshallable(map, this.keyType, this.valueType, Boolean.TRUE.equals(this.isLeaf));
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            Map fromMap = (Map)this.field.get(from);
            if (fromMap == null) {
                this.field.set(to, null);
                return;
            }
            Map map = (Map)this.field.get(to);
            if (map == null) {
                map = this.collectionSupplier.get();
                this.field.set(to, map);
            } else if (!map.isEmpty()) {
                map.clear();
            }
            map.clear();
            map.putAll(fromMap);
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            Map map = (Map)this.field.get(o);
            if (map == null) {
                map = this.collectionSupplier.get();
                this.field.set(o, map);
            } else if (!map.isEmpty()) {
                map.clear();
            }
            if (read.marshallableAsMap(this.keyType, this.valueType, map) == null) {
                this.field.set(o, null);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static class StringCollectionFieldAccess
    extends FieldAccess {
        @NotNull
        final Supplier<Collection> collectionSupplier;
        private final Class<?> type;
        @NotNull
        private BiConsumer<Collection, ValueIn> seqConsumer = (c, in2) -> {
            Bytes<?> bytes = in2.wireIn().bytes();
            while (in2.hasNextSequenceItem()) {
                long start = bytes.readPosition();
                c.add(in2.text());
                long end = bytes.readPosition();
                if (start != end) continue;
                int ch = bytes.readUnsignedByte(start);
                throw new IORuntimeException("Expected a ] but found " + ch + " '" + (char)ch + "'");
            }
        };

        public StringCollectionFieldAccess(@NotNull Field field, Boolean isLeaf, @Nullable Supplier<Collection> collectionSupplier, Class<?> type) {
            super(field, isLeaf);
            this.collectionSupplier = collectionSupplier == null ? this.newInstance() : collectionSupplier;
            this.type = type;
        }

        private Supplier<Collection> newInstance() {
            return () -> {
                try {
                    return (Collection)this.type.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
            };
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Collection c = (Collection)this.field.get(o);
            if (c == null) {
                write.nu11();
                return;
            }
            write.sequence(c, (coll, out) -> {
                if (coll instanceof RandomAccess) {
                    @NotNull List list = (List)coll;
                    @NotNull int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        out.text((String)list.get(i));
                    }
                } else {
                    for (String element : coll) {
                        out.text(element);
                    }
                }
            });
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            Collection coll = (Collection)this.field.get(o);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(o, coll);
            } else if (!coll.isEmpty()) {
                coll.clear();
            }
            boolean sequenced = read.sequence(coll, this.seqConsumer);
            if (overwrite & !sequenced) {
                this.field.set(o, null);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static class CollectionFieldAccess
    extends FieldAccess {
        @NotNull
        final Supplier<Collection> collectionSupplier;
        private final Class componentType;
        private final Class<?> type;
        private BiConsumer<Object, ValueOut> sequenceGetter;

        public CollectionFieldAccess(@NotNull Field field, Boolean isLeaf, @Nullable Supplier<Collection> collectionSupplier, Class componentType, Class<?> type) {
            super(field, isLeaf);
            this.collectionSupplier = collectionSupplier == null ? this.newInstance() : collectionSupplier;
            this.componentType = componentType;
            this.type = type;
            this.sequenceGetter = (o, out) -> {
                Collection coll;
                try {
                    coll = (Collection)field.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                if (coll instanceof RandomAccess) {
                    @NotNull List list = (List)coll;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        out.object(componentType, list.get(i));
                    }
                } else if (coll == null) {
                    try {
                        field.set(coll, null);
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                } else {
                    for (Object element : coll) {
                        out.object(componentType, element);
                    }
                }
            };
        }

        @NotNull
        static FieldAccess of(@NotNull Field field) {
            Class componentType;
            Boolean isLeaf = null;
            Class<?> type = field.getType();
            Supplier<Collection> collectionSupplier = type == List.class || type == Collection.class ? ArrayList::new : (type == SortedSet.class || type == NavigableSet.class ? TreeSet::new : (type == Set.class ? LinkedHashSet::new : null));
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                @NotNull ParameterizedType pType = (ParameterizedType)genericType;
                Type type0 = pType.getActualTypeArguments()[0];
                componentType = CollectionFieldAccess.extractClass(type0);
                isLeaf = !Throwable.class.isAssignableFrom(componentType) && ((WireMarshaller)WIRE_MARSHALLER_CL.get(componentType)).isLeaf;
            } else {
                componentType = Object.class;
            }
            return componentType == String.class ? new StringCollectionFieldAccess(field, true, collectionSupplier, type) : new CollectionFieldAccess(field, isLeaf, collectionSupplier, componentType, type);
        }

        private Supplier<Collection> newInstance() {
            return () -> {
                try {
                    return (Collection)this.type.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
            };
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Collection c = (Collection)this.field.get(o);
            if (c == null) {
                write.nu11();
                return;
            }
            write.sequence(o, this.sequenceGetter);
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            Collection fromColl = (Collection)this.field.get(from);
            if (fromColl == null) {
                this.field.set(to, null);
                return;
            }
            Collection coll = (Collection)this.field.get(to);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(to, coll);
            }
            coll.clear();
            coll.addAll(fromColl);
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            Collection coll = (Collection)this.field.get(o);
            if (coll == null) {
                coll = this.collectionSupplier.get();
                this.field.set(o, coll);
            }
            if (!read.sequence(coll, (c, in2) -> {
                if (!c.isEmpty()) {
                    c.clear();
                }
                while (in2.hasNextSequenceItem()) {
                    c.add(in2.object(this.componentType));
                }
            })) {
                Collection defaultColl = (Collection)this.field.get(defaults);
                if (defaultColl == null) {
                    this.field.set(o, null);
                } else {
                    coll.clear();
                    if (!defaultColl.isEmpty()) {
                        coll.addAll(defaultColl);
                    }
                }
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean sameValue(Object o, Object o2) throws IllegalAccessException {
            return super.sameValue(o, o2);
        }
    }

    static class EnumSetFieldAccess
    extends FieldAccess {
        private final Object[] values;
        private final BiConsumer<Object, ValueOut> sequenceGetter;
        private final Class componentType;
        private final Supplier<EnumSet> enumSetSupplier;
        private BiConsumer<EnumSet, ValueIn> addAll;

        EnumSetFieldAccess(@NotNull Field field, Boolean isLeaf, Object[] values, Class componentType) {
            super(field, isLeaf);
            this.values = values;
            this.componentType = componentType;
            this.enumSetSupplier = () -> EnumSet.noneOf(this.componentType);
            this.sequenceGetter = (o, out) -> EnumSetFieldAccess.sequenceGetter(o, out, this.values, this.field, this.componentType);
            this.addAll = this::addAll;
        }

        private static void sequenceGetter(Object o, ValueOut out, Object[] values, Field field, Class componentType) {
            EnumSet coll;
            try {
                coll = (EnumSet)field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            for (int i = values.length - 1; i != -1; --i) {
                if (!coll.contains(values[i])) continue;
                out.object(componentType, values[i]);
            }
        }

        @Override
        protected void getValue(Object o, ValueOut write, Object previous) throws IllegalAccessException {
            @NotNull Collection c = (Collection)this.field.get(o);
            if (c == null) {
                write.nu11();
                return;
            }
            write.sequence(o, this.sequenceGetter);
        }

        @Override
        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            EnumSet coll = (EnumSet)this.field.get(o);
            if (coll == null) {
                coll = this.enumSetSupplier.get();
                this.field.set(o, coll);
            }
            if (!read.sequence(coll, this.addAll)) {
                Collection defaultColl = (Collection)this.field.get(defaults);
                if (defaultColl == null) {
                    this.field.set(o, null);
                } else {
                    coll.clear();
                    if (!defaultColl.isEmpty()) {
                        coll.addAll(defaultColl);
                    }
                }
            }
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            EnumSet fromColl = (EnumSet)this.field.get(from);
            if (fromColl == null) {
                this.field.set(to, null);
                return;
            }
            EnumSet coll = (EnumSet)this.field.get(to);
            if (coll == null) {
                coll = this.enumSetSupplier.get();
                this.field.set(to, coll);
            }
            coll.clear();
            for (int i = this.values.length - 1; i != -1; --i) {
                if (!fromColl.contains(this.values[i])) continue;
                coll.add(this.values[i]);
            }
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }

        private void addAll(EnumSet c, ValueIn in2) {
            if (!c.isEmpty()) {
                c.clear();
            }
            while (in2.hasNextSequenceItem()) {
                c.add(in2.asEnum(this.componentType));
            }
        }
    }

    static class ArrayFieldAccess
    extends FieldAccess {
        private final Class componentType;
        private final Class objectType;

        ArrayFieldAccess(@NotNull Field field) {
            super(field);
            this.componentType = field.getType().getComponentType();
            this.objectType = ObjectUtils.primToWrapper((Class)this.componentType);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            Object arr = this.field.get(o);
            boolean leaf = write.swapLeaf(true);
            if (arr == null) {
                write.nu11();
            } else {
                write.sequence(arr, (array, out) -> {
                    int len = Array.getLength(array);
                    for (int i = 0; i < len; ++i) {
                        out.object(this.objectType, Array.get(array, i));
                    }
                });
            }
            write.swapLeaf(leaf);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) throws IllegalAccessException {
            Object arr = this.field.get(o);
            if (read.isNull()) {
                if (arr != null) {
                    this.field.set(o, null);
                }
                return;
            }
            @NotNull ArrayList<E> list = new ArrayList();
            read.sequence(list, (l, in) -> {
                while (in.hasNextSequenceItem()) {
                    l.add(in.object(this.componentType));
                }
            });
            Object arr2 = Array.newInstance(this.componentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(arr2, i, list.get(i));
            }
            this.field.set(o, arr2);
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEqual(Object o1, Object o2) {
            try {
                int len2;
                Object a1 = this.field.get(o1);
                Object a2 = this.field.get(o2);
                if (a1 == null) {
                    return a2 == null;
                }
                if (a2 == null) {
                    return false;
                }
                if (a1.getClass() != a2.getClass()) {
                    return false;
                }
                int len1 = Array.getLength(a1);
                if (len1 != (len2 = Array.getLength(a2))) {
                    return false;
                }
                for (int i = 0; i < len1; ++i) {
                    if (Objects.equals(Array.get(a1, i), Array.get(a2, i))) continue;
                    return false;
                }
                return true;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class BytesFieldAccess
    extends FieldAccess {
        BytesFieldAccess(@NotNull Field field) {
            super(field, false);
        }

        @Override
        protected void getValue(@NotNull Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            Bytes bytesField = (Bytes)this.field.get(o);
            write.bytes((BytesStore)bytesField);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            WireIn wireIn;
            @NotNull Bytes bytes = (Bytes)UnsafeMemory.UNSAFE.getObject(o, this.offset);
            if (bytes == null) {
                bytes = Bytes.elasticHeapByteBuffer((int)128);
                UnsafeMemory.UNSAFE.putObject(o, this.offset, bytes);
            }
            if ((wireIn = read.wireIn()) instanceof TextWire) {
                wireIn.consumePadding();
                if (wireIn.bytes().startsWith(TextWire.BINARY)) {
                    this.decodeBytes(read, bytes);
                    return;
                }
            }
            if (read.textTo(bytes) == null) {
                UnsafeMemory.UNSAFE.putObject(o, this.offset, null);
            }
        }

        private void decodeBytes(@NotNull ValueIn read, Bytes bytes) {
            @NotNull StringBuilder sb0 = RSBP.acquireStringBuilder();
            read.text(sb0);
            String s = WireInternal.INTERNER.intern((CharSequence)sb0);
            byte[] decode = Base64.getDecoder().decode(s);
            bytes.clear();
            bytes.write(decode);
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) throws IllegalAccessException {
            Bytes bytesField = (Bytes)this.field.get(o);
            bytes.write((BytesStore)bytesField);
        }

        @Override
        protected void copy(Object from, Object to) {
            Bytes fromBytes = (Bytes)UnsafeMemory.UNSAFE.getObject(from, this.offset);
            Bytes toBytes = (Bytes)UnsafeMemory.UNSAFE.getObject(to, this.offset);
            if (fromBytes == null) {
                UnsafeMemory.UNSAFE.putObject(to, this.offset, null);
                return;
            }
            if (toBytes == null) {
                toBytes = Bytes.elasticByteBuffer();
                UnsafeMemory.UNSAFE.putObject(to, this.offset, toBytes);
            }
            toBytes.clear();
            toBytes.write((BytesStore)fromBytes);
        }
    }

    static class StringBuilderFieldAccess
    extends FieldAccess {
        public StringBuilderFieldAccess(@NotNull Field field) {
            super(field, true);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            @NotNull CharSequence cs = (CharSequence)UnsafeMemory.UNSAFE.getObject(o, this.offset);
            write.text(cs);
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            @NotNull StringBuilder sb = (StringBuilder)UnsafeMemory.UNSAFE.getObject(o, this.offset);
            if (sb == null) {
                sb = new StringBuilder();
                UnsafeMemory.UNSAFE.putObject(o, this.offset, sb);
            }
            if (read.textTo(sb) == null) {
                UnsafeMemory.UNSAFE.putObject(o, this.offset, null);
            }
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeUtf8((CharSequence)UnsafeMemory.UNSAFE.getObject(o, this.offset));
        }

        @Override
        protected boolean sameValue(Object o1, Object o2) throws IllegalAccessException {
            return StringUtils.isEqual((StringBuilder)((StringBuilder)this.field.get(o1)), (CharSequence)((StringBuilder)this.field.get(o2)));
        }

        @Override
        protected void copy(Object from, Object to) {
            StringBuilder fromSequence = (StringBuilder)UnsafeMemory.UNSAFE.getObject(from, this.offset);
            StringBuilder toSequence = (StringBuilder)UnsafeMemory.UNSAFE.getObject(to, this.offset);
            if (fromSequence == null) {
                UnsafeMemory.UNSAFE.putObject(to, this.offset, null);
                return;
            }
            if (toSequence == null) {
                toSequence = new StringBuilder();
                UnsafeMemory.UNSAFE.putObject(to, this.offset, toSequence);
            }
            toSequence.setLength(0);
            toSequence.append((CharSequence)fromSequence);
        }
    }

    static class StringFieldAccess
    extends FieldAccess {
        StringFieldAccess(@NotNull Field field) {
            super(field, false);
        }

        @Override
        protected void getValue(Object o, @NotNull ValueOut write, Object previous) {
            write.text((String)UnsafeMemory.UNSAFE.getObject(o, this.offset));
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) {
            UnsafeMemory.UNSAFE.putObject(o, this.offset, read.text());
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) {
            bytes.writeUtf8((String)UnsafeMemory.UNSAFE.getObject(o, this.offset));
        }

        @Override
        protected void copy(Object from, Object to) throws IllegalAccessException {
            super.copy(from, to);
        }
    }

    static class ObjectFieldAccess
    extends FieldAccess {
        private final Class type;

        ObjectFieldAccess(@NotNull Field field, Boolean isLeaf) {
            super(field, isLeaf);
            this.type = field.getType();
        }

        @Override
        protected void getValue(@NotNull Object o, @NotNull ValueOut write, Object previous) throws IllegalAccessException {
            Boolean wasLeaf = null;
            if (this.isLeaf != null) {
                wasLeaf = write.swapLeaf(this.isLeaf);
            }
            assert (o != null);
            write.object(this.type, this.field.get(o));
            if (wasLeaf != null) {
                write.swapLeaf(wasLeaf);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull ValueIn read, boolean overwrite) throws IllegalAccessException {
            block4: {
                long pos = read.wireIn().bytes().readPosition();
                try {
                    Object using = ObjectUtils.isImmutable((Class)this.type) == ObjectUtils.Immutability.NO ? this.field.get(o) : null;
                    Object object = read.object(using, this.type);
                    this.field.set(o, object);
                }
                catch (Exception e) {
                    read.wireIn().bytes().readPosition(pos);
                    Object object = null;
                    try {
                        object = read.object();
                    }
                    catch (Exception ex) {
                        object = ex;
                    }
                    Jvm.warn().on(this.getClass(), "Unable to parse field: " + this.field.getName() + ", as a marshallable as it is " + object);
                    if (!overwrite) break block4;
                    this.field.set(o, ObjectUtils.defaultValue(this.field.getType()));
                }
            }
        }

        @Override
        public void getAsBytes(Object o, @NotNull Bytes bytes) throws IllegalAccessException {
            bytes.writeUtf8(String.valueOf(this.field.get(o)));
        }
    }

    static class LongValueAccess
    extends FieldAccess {
        LongValueAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write, Object previous) throws IllegalAccessException {
            LongValue f = (LongValue)this.field.get(o);
            long value = f == null ? 0L : f.getValue();
            write.int64forBinding(value);
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) throws IllegalAccessException {
            LongValue f = (LongValue)this.field.get(o);
            if (f == null) {
                f = read.wireIn().newLongReference();
                this.field.set(o, f);
            }
            read.int64(f);
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static class IntValueAccess
    extends FieldAccess {
        IntValueAccess(@NotNull Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, ValueOut write, Object previous) throws IllegalAccessException {
            IntValue f = (IntValue)this.field.get(o);
            int value = f == null ? 0 : f.getValue();
            write.int32forBinding(value);
        }

        @Override
        protected void setValue(Object o, ValueIn read, boolean overwrite) throws IllegalAccessException {
            IntValue f = (IntValue)this.field.get(o);
            if (f == null) {
                f = read.wireIn().newIntReference();
                this.field.set(o, f);
            }
            read.int32(f);
        }

        @Override
        public void getAsBytes(Object o, Bytes bytes) {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class FieldAccess {
        @NotNull
        final Field field;
        final long offset;
        @NotNull
        final WireKey key;
        Comment commentAnnotation;
        Boolean isLeaf;

        FieldAccess(@NotNull Field field) {
            this(field, null);
        }

        FieldAccess(@NotNull Field field, Boolean isLeaf) {
            this.field = field;
            this.offset = UnsafeMemory.UNSAFE.objectFieldOffset(field);
            this.key = field::getName;
            this.isLeaf = isLeaf;
            try {
                this.commentAnnotation = field.getAnnotation(Comment.class);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Nullable
        public static Object create(@NotNull Field field) {
            Class<?> type = field.getType();
            if (type.isArray()) {
                return new ArrayFieldAccess(field);
            }
            if (EnumSet.class.isAssignableFrom(type)) {
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    @NotNull ParameterizedType pType = (ParameterizedType)genericType;
                    Type type0 = pType.getActualTypeArguments()[0];
                    Class componentType = FieldAccess.extractClass(type0);
                    boolean isLeaf = !Throwable.class.isAssignableFrom(componentType) && ((WireMarshaller)WIRE_MARSHALLER_CL.get(componentType)).isLeaf;
                    try {
                        Method method = Class.class.getDeclaredMethod("enumConstantDirectory", new Class[0]);
                        Jvm.setAccessible((AccessibleObject)method);
                        Map values = (Map)method.invoke((Object)componentType, new Object[0]);
                        return new EnumSetFieldAccess(field, isLeaf, values.values().toArray(), componentType);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException("Could not get enum constant directory");
            }
            if (Collection.class.isAssignableFrom(type)) {
                return CollectionFieldAccess.of(field);
            }
            if (Map.class.isAssignableFrom(type)) {
                return new MapFieldAccess(field);
            }
            switch (type.getName()) {
                case "boolean": {
                    return new BooleanFieldAccess(field);
                }
                case "byte": {
                    IntConversion intConversion = field.getAnnotation(IntConversion.class);
                    return intConversion == null ? new ByteFieldAccess(field) : new ByteIntConversionFieldAccess(field, intConversion);
                }
                case "char": {
                    CharConversion charConversion = field.getAnnotation(CharConversion.class);
                    return charConversion == null ? new CharFieldAccess(field) : new CharConversionFieldAccess(field, charConversion);
                }
                case "short": {
                    IntConversion intConversion = field.getAnnotation(IntConversion.class);
                    return intConversion == null ? new ShortFieldAccess(field) : new ShortIntConversionFieldAccess(field, intConversion);
                }
                case "int": {
                    IntConversion intConversion = field.getAnnotation(IntConversion.class);
                    return intConversion == null ? new IntegerFieldAccess(field) : new IntConversionFieldAccess(field, intConversion);
                }
                case "float": {
                    return new FloatFieldAccess(field);
                }
                case "long": {
                    LongConversion longConversion = field.getAnnotation(LongConversion.class);
                    return longConversion == null ? new LongFieldAccess(field) : new LongConversionFieldAccess(field, longConversion);
                }
                case "double": {
                    return new DoubleFieldAccess(field);
                }
                case "java.lang.String": {
                    return new StringFieldAccess(field);
                }
                case "java.lang.StringBuilder": {
                    return new StringBuilderFieldAccess(field);
                }
                case "net.openhft.chronicle.bytes.Bytes": {
                    return new BytesFieldAccess(field);
                }
            }
            Boolean isLeaf = null;
            if (IntValue.class.isAssignableFrom(type)) {
                return new IntValueAccess(field);
            }
            if (LongValue.class.isAssignableFrom(type)) {
                return new LongValueAccess(field);
            }
            if (WireMarshaller.class.isAssignableFrom(type)) {
                isLeaf = ((WireMarshaller)WIRE_MARSHALLER_CL.get(type)).isLeaf;
            } else if (WireMarshaller.isCollection(type)) {
                isLeaf = false;
            }
            return new ObjectFieldAccess(field, isLeaf);
        }

        @NotNull
        static Class extractClass(Type type0) {
            if (type0 instanceof Class) {
                return (Class)type0;
            }
            if (type0 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type0).getRawType();
            }
            return Object.class;
        }

        @NotNull
        public String toString() {
            return "FieldAccess{field=" + this.field + ", isLeaf=" + this.isLeaf + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(Object o, @NotNull WireOut out) throws IllegalAccessException {
            ValueOut valueOut = out.write(this.field.getName());
            if (valueOut instanceof CommentAnnotationNotifier && this.commentAnnotation != null) {
                CommentAnnotationNotifier notifier = (CommentAnnotationNotifier)((Object)valueOut);
                notifier.hasPrecedingComment(true);
                try {
                    this.getValue(o, valueOut, null);
                    out.writeComment(String.format(this.commentAnnotation.value(), this.field.get(o)));
                }
                finally {
                    notifier.hasPrecedingComment(false);
                }
                return;
            }
            this.getValue(o, valueOut, null);
        }

        void write(Object o, @NotNull WireOut out, Object previous, boolean copy) throws IllegalAccessException {
            if (this.sameValue(o, previous)) {
                return;
            }
            ValueOut write = out.write(this.field.getName());
            this.getValue(o, write, previous);
            if (copy) {
                this.copy(o, previous);
            }
        }

        protected boolean sameValue(Object o, Object o2) throws IllegalAccessException {
            Object v1 = this.field.get(o);
            Object v2 = this.field.get(o2);
            if (v1 instanceof CharSequence && v2 instanceof CharSequence) {
                return StringUtils.isEqual((CharSequence)((CharSequence)v1), (CharSequence)((CharSequence)v2));
            }
            return Objects.equals(v1, v2);
        }

        protected void copy(Object from, Object to) throws IllegalAccessException {
            UnsafeMemory.UNSAFE.putObject(to, this.offset, UnsafeMemory.UNSAFE.getObject(from, this.offset));
        }

        protected abstract void getValue(Object var1, ValueOut var2, Object var3) throws IllegalAccessException;

        protected void readValue(Object o, Object defaults, ValueIn read, boolean overwrite) throws IllegalAccessException {
            if (read instanceof DefaultValueIn) {
                if (overwrite) {
                    this.copy(defaults, o);
                }
            } else {
                long pos = read.wireIn().bytes().readPosition();
                try {
                    this.setValue(o, read, overwrite);
                }
                catch (Exception e) {
                    read.wireIn().bytes().readPosition(pos);
                    StringBuilder sb = RSBP.acquireStringBuilder();
                    read.text(sb);
                    Jvm.warn().on(this.getClass(), "Failed to read '" + this.field.getName() + "' with '" + sb + "' taking default", (Throwable)e);
                    this.copy(defaults, o);
                }
            }
        }

        protected abstract void setValue(Object var1, ValueIn var2, boolean var3) throws IllegalAccessException;

        public abstract void getAsBytes(Object var1, Bytes var2) throws IllegalAccessException;

        public boolean isEqual(Object o1, Object o2) {
            try {
                return this.sameValue(o1, o2);
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
    }
}

