/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Type;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface WireKey {
    public static boolean checkKeys(@NotNull WireKey[] keys) {
        @NotNull HashMap<Integer, WireKey> codes = new HashMap<Integer, WireKey>();
        for (WireKey key : keys) {
            WireKey pkey = codes.put(key.code(), key);
            if (pkey != null) {
                throw new AssertionError((Object)(pkey + " and " + key + " have the same code " + key.code()));
            }
        }
        return true;
    }

    public static int toCode(@NotNull CharSequence cs) {
        @NotNull String s = cs.toString();
        if (s.length() > 0 && Character.isDigit(s.charAt(0))) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return s.hashCode();
    }

    @NotNull
    public CharSequence name();

    default public int code() {
        return WireKey.toCode(this.name());
    }

    default public Type type() {
        @Nullable Object o = this.defaultValue();
        return o == null ? Void.class : o.getClass();
    }

    @Nullable
    default public Object defaultValue() {
        return null;
    }

    default public boolean contentEquals(@NotNull CharSequence c) {
        return this.toString().contentEquals(c);
    }
}

