/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import net.openhft.chronicle.wire.SharedDocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.utils.JavaSouceCodeFormatter;
import net.openhft.compiler.CompilerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMethodWriter {
    static final boolean DUMP_CODE = Boolean.getBoolean("dumpCode");
    private static final String SHARED_DOCUMENT_CONTEXT = SharedDocumentContext.class.getSimpleName();
    private static final String DOCUMENT_CONTEXT_HOLDER = DocumentContextHolder.class.getSimpleName();
    private static final String GENERATE_METHOD_WRITER = GenerateMethodWriter.class.getSimpleName();
    private static final String DOCUMENT_CONTEXT = DocumentContext.class.getSimpleName();
    private static final String MARSHALLABLE_OUT = MarshallableOut.class.getSimpleName();
    private static final String METHOD_ID = MethodId.class.getSimpleName();
    private static final String VALUE_OUT = ValueOut.class.getSimpleName();
    private static final String CLOSEABLE = Closeable.class.getSimpleName();
    private static final String MARSHALLABLE = Marshallable.class.getSimpleName();
    private static final String METHOD_READER = MethodReader.class.getSimpleName();
    private final boolean metaData;
    private final boolean useMethodId;
    private final String packageName;
    private final Set<Class> interfaces;
    private final String className;
    private final ClassLoader classLoader;
    private final WireType wireType;
    private final String genericEvent;
    private ConcurrentMap<Class, String> methodWritersMap = new ConcurrentHashMap<Class, String>();
    private boolean hasMethodWriterListener;
    private AtomicInteger indent = new AtomicInteger();

    private GenerateMethodWriter(String packageName, Set<Class> interfaces, String className, ClassLoader classLoader, WireType wireType, String genericEvent, boolean hasMethodWriterListener, boolean metaData, boolean useMethodId) {
        this.packageName = packageName;
        this.interfaces = interfaces;
        this.className = className;
        this.classLoader = classLoader;
        this.wireType = wireType;
        this.genericEvent = genericEvent;
        this.hasMethodWriterListener = hasMethodWriterListener;
        this.metaData = metaData;
        this.useMethodId = useMethodId;
    }

    @Nullable
    public static Class newClass(String packageName, Set<Class> interfaces, String className, ClassLoader classLoader, WireType wireType, String genericEvent, boolean hasMethodWriterListener, boolean metaData, boolean useMethodId) {
        return new GenerateMethodWriter(packageName, interfaces, className, classLoader, wireType, genericEvent, hasMethodWriterListener, metaData, useMethodId).createClass();
    }

    public static DocumentContext acquireDocumentContext(boolean metaData, ThreadLocal<DocumentContextHolder> documentContextTL, MarshallableOut out) {
        DocumentContextHolder contextHolder = documentContextTL.get();
        if (!contextHolder.isClosed()) {
            return contextHolder;
        }
        contextHolder.documentContext(out.writingDocument(metaData));
        return contextHolder;
    }

    public static void addComment(Bytes<?> bytes, Object arg) {
        if (arg instanceof Marshallable) {
            bytes.comment((CharSequence)arg.getClass().getSimpleName());
        } else {
            bytes.comment((CharSequence)String.valueOf(arg));
        }
    }

    @NotNull
    private Appendable methodSignature(Method dm, int len) throws IOException {
        JavaSouceCodeFormatter result = new JavaSouceCodeFormatter(this.indent);
        for (int j = 0; j < len; ++j) {
            Parameter p = dm.getParameters()[j];
            String className = p.getType().getTypeName().replace('$', '.');
            Optional<String> intConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == IntConversion.class).map(x -> ((IntConversion)x).value().getName()).findFirst();
            Optional<String> longConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == LongConversion.class).map(x -> ((LongConversion)x).value().getName()).findFirst();
            if (intConversion.isPresent()) {
                result.append("@IntConversion(").append(intConversion.get()).append(".class) ");
            } else {
                longConversion.ifPresent(s -> {
                    try {
                        result.append("@LongConversion(").append((CharSequence)s).append(".class) ");
                    }
                    catch (Exception w) {
                        throw Jvm.rethrow((Throwable)w);
                    }
                });
            }
            result.append("final ");
            result.append(className);
            result.append(' ').append(p.getName());
            if (j == len - 1) break;
            result.append(',');
        }
        return result;
    }

    private static CharSequence toString(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return "bool";
        }
        if (Byte.TYPE.equals(type)) {
            return "writeByte";
        }
        if (Character.TYPE.equals(type)) {
            return "character";
        }
        if (Short.TYPE.equals(type)) {
            return "int16";
        }
        if (Integer.TYPE.equals(type)) {
            return "fixedInt32";
        }
        if (Long.TYPE.equals(type)) {
            return "fixedInt64";
        }
        if (Float.TYPE.equals(type)) {
            return "fixedFloat32";
        }
        if (Double.TYPE.equals(type)) {
            return "fixedFloat64";
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return "marshallable";
        }
        return "object";
    }

    private Class createClass() {
        JavaSouceCodeFormatter interfaceMethods = new JavaSouceCodeFormatter(1);
        JavaSouceCodeFormatter imports = new JavaSouceCodeFormatter();
        try {
            imports.append("package " + this.packageName + ";\n\nimport net.openhft.chronicle.wire.*;\nimport " + IntConversion.class.getName() + ";\nimport " + LongConversion.class.getName() + ";\nimport " + GenerateMethodWriter.class.getName() + ";\nimport " + MessageHistory.class.getName() + ";\nimport " + MethodReader.class.getName() + ";\nimport " + MethodId.class.getName() + ";\nimport " + GenerateMethodWriter.class.getName() + ";\nimport " + DocumentContext.class.getName() + ";\nimport " + SharedDocumentContext.class.getName() + ";\nimport " + MethodWriterInvocationHandlerSupplier.class.getName() + ";\nimport " + Jvm.class.getName() + ";\nimport " + Closeable.class.getName() + ";\nimport " + DocumentContextHolder.class.getName() + ";\nimport " + MethodWriterListener.class.getName() + ";\nimport java.lang.reflect.InvocationHandler;\nimport java.lang.reflect.Method;\nimport java.util.stream.IntStream;\nimport java.util.ArrayList;\nimport java.util.List;\n\n");
            imports.append("public final class ").append(this.className).append(" implements ");
            for (Class interfaceClazz : this.interfaces) {
                String interfaceName = this.nameForClass(interfaceClazz);
                imports.append(interfaceName);
                imports.append(",");
                if (!interfaceClazz.isInterface()) {
                    throw new IllegalArgumentException("expecting and interface instead of class=" + interfaceClazz.getName());
                }
                for (Method dm : interfaceClazz.getMethods()) {
                    if (dm.isDefault() || Modifier.isStatic(dm.getModifiers()) || dm.getName().equals("documentContext") && dm.getParameterTypes().length == 1 && dm.getParameterTypes()[0] == ThreadLocal.class && SharedDocumentContext.class.isAssignableFrom(dm.getReturnType())) continue;
                    interfaceMethods.append(this.createMethod(dm, interfaceClazz));
                }
            }
            imports.setLength(imports.length() - 1);
            imports.append("{\n\n");
            imports.append(this.constructorAndFields(this.className));
            imports.append(this.methodDocumentContext());
            imports.append(interfaceMethods);
            imports.append("\n}\n");
            if (DUMP_CODE) {
                System.out.println(imports);
            }
            return CompilerUtils.CACHED_COMPILER.loadFromJava(this.classLoader, this.packageName + '.' + this.className, imports.toString());
        }
        catch (LinkageError e) {
            try {
                return Class.forName(this.packageName + '.' + this.className, true, this.classLoader);
            }
            catch (ClassNotFoundException x) {
                throw Jvm.rethrow((Throwable)x);
            }
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + imports, e));
        }
    }

    @NotNull
    private String nameForClass(Class interfaceClazz) {
        return interfaceClazz.getName().replace('$', '.');
    }

    private CharSequence constructorAndFields(String className) {
        StringBuilder result = new StringBuilder("// result\n");
        result.append("private transient final ").append(CLOSEABLE).append(" closeable;\n");
        result.append("private transient final MethodWriterListener methodWriterListener;\n");
        result.append("private transient final ").append(MARSHALLABLE_OUT).append(" out;\n");
        result.append("private transient ThreadLocal<").append(DOCUMENT_CONTEXT_HOLDER).append("> documentContextTL = ThreadLocal.withInitial(").append(DOCUMENT_CONTEXT).append("Holder::new);\n");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            result.append(String.format("private ThreadLocal %s = new ThreadLocal();\n", e.getValue()));
        }
        result.append("\n");
        return result.append(String.format("// constructor\npublic %s(" + MARSHALLABLE_OUT + " out, " + CLOSEABLE + " closeable, MethodWriterListener methodWriterListener) {\nthis.methodWriterListener = methodWriterListener;\nthis.out = out;\nthis.closeable = closeable;\n}\n\n", className));
    }

    private CharSequence methodDocumentContext() {
        return "// method documentContext\n@Override\npublic <T extends " + SHARED_DOCUMENT_CONTEXT + "> T documentContext(final ThreadLocal<" + DOCUMENT_CONTEXT_HOLDER + "> documentContextTL) {\nthis.documentContextTL = documentContextTL; \nreturn (T)this;\n}\n";
    }

    private CharSequence createMethod(Method dm, Class<?> interfaceClazz) throws IOException {
        if (Modifier.isStatic(dm.getModifiers())) {
            return "";
        }
        if (dm.getParameterTypes().length == 0 && dm.isDefault()) {
            return "";
        }
        if ("writingDocument".contentEquals(dm.getName()) && dm.getReturnType() == DocumentContext.class && dm.getParameterCount() == 0) {
            return this.createMethodWritingDocument();
        }
        int len = dm.getParameters().length;
        Class<?> returnType = dm.getReturnType();
        String typeName = this.nameForClass(returnType);
        StringBuilder body = new StringBuilder();
        String methodIDAnotation = "";
        if (dm.getReturnType() == Void.TYPE && "close".equals(dm.getName()) && dm.getParameterCount() == 0) {
            body.append("if (this.closeable != null){\n this.closeable.close();\n}\n");
        } else {
            String eventName;
            body.append(String.format("final " + DOCUMENT_CONTEXT + " dc = " + GENERATE_METHOD_WRITER + ".acquire" + DOCUMENT_CONTEXT + "(%s,this.documentContextTL,this.out);\n", this.metaData)).append((CharSequence)this.recordHistory());
            int startJ = 0;
            if (dm.getParameterCount() > 0 && dm.getName().equals(this.genericEvent)) {
                eventName = dm.getParameters()[0].getName();
                startJ = 1;
            } else {
                eventName = '\"' + dm.getName() + '\"';
            }
            this.retainsComments(dm, body);
            methodIDAnotation = this.writeEventNameOrId(dm, body, eventName);
            if (dm.getParameterCount() - startJ == 1) {
                this.addFieldComments(dm, body);
            }
            if (this.hasMethodWriterListener && dm.getParameterCount() > 0) {
                this.createMethodWriterListener(dm, body);
            } else if (dm.getParameters().length > 0) {
                this.writeArrayOfParameters(dm, len, body, startJ);
            }
            if (dm.getParameterTypes().length == 0) {
                body.append("valueOut.text(\"\");\n");
            }
            if (returnType == Void.class || returnType == Void.TYPE || returnType.isPrimitive()) {
                body.append("dc.close();\n");
            }
        }
        return String.format("\n%s public %s %s(%s){\n %s%s}\n", methodIDAnotation, typeName, dm.getName(), this.methodSignature(dm, len), body, this.methodReturn(dm, interfaceClazz));
    }

    @NotNull
    private CharSequence createMethodWritingDocument() {
        return "public " + DOCUMENT_CONTEXT + " writingDocument(){\n return " + GENERATE_METHOD_WRITER + ".acquire" + DOCUMENT_CONTEXT + "(false,this.documentContextTL,this.out);\n}\n";
    }

    private void retainsComments(Method dm, StringBuilder body) {
        body.append(String.format("if (dc.wire().bytes().retainsComments()){\n dc.wire().bytes().comment(\"%s\");\n}\n", dm.getName()));
    }

    private String writeEventNameOrId(Method dm, StringBuilder body, String eventName) {
        Optional methodId;
        String methodID = "";
        Optional<Object> optional = methodId = this.useMethodId ? Arrays.stream(dm.getAnnotations()).filter(f -> f instanceof MethodId).findFirst() : Optional.empty();
        if (this.wireType != WireType.TEXT && this.wireType != WireType.YAML && methodId.isPresent()) {
            long value = ((MethodId)methodId.get()).value();
            body.append(String.format("final " + VALUE_OUT + " valueOut = dc.wire().writeEventId(%d);\n", value));
            methodID = String.format("@" + METHOD_ID + "(%d)\n", value);
        } else {
            body.append(String.format("final " + VALUE_OUT + " valueOut = dc.wire().writeEventName(%s);\n", eventName));
        }
        return methodID;
    }

    private void writeArrayOfParameters(Method dm, int len, StringBuilder body, int startJ) {
        if (dm.getParameterTypes().length > startJ + 1) {
            body.append("valueOut.array(v -> {\n");
        }
        for (int j = startJ; j < len; ++j) {
            Optional<String> longConversion;
            Parameter p = dm.getParameters()[j];
            Optional<String> intConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == IntConversion.class).map(x -> ((IntConversion)x).value().getName()).findFirst();
            String name = intConversion.orElseGet(() -> GenerateMethodWriter.lambda$writeArrayOfParameters$10(longConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == LongConversion.class).map(x -> ((LongConversion)x).value().getName()).findFirst()));
            if (!(name.isEmpty() || WireType.TEXT != this.wireType && WireType.YAML != this.wireType)) {
                body.append(String.format("//todo improve this\nvalueOut.rawText(new %s().asText(%s));\n", name, p.getName()));
                continue;
            }
            if (p.getType().isPrimitive() || CharSequence.class.isAssignableFrom(p.getType())) {
                body.append(String.format("%s.%s(%s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", GenerateMethodWriter.toString(p.getType()), p.getName()));
                continue;
            }
            this.writeValue(dm, body, startJ, p);
        }
        if (dm.getParameterTypes().length > startJ + 1) {
            body.append("}, Object[].class);\n");
        }
    }

    private void writeValue(Method dm, StringBuilder body, int startJ, Parameter p) {
        String className = p.getType().getTypeName().replace('$', '.');
        boolean closeIfBlock = false;
        if (Marshallable.class.isAssignableFrom(p.getType())) {
            body.append(String.format("if (%s.getClass() == %s.class){\n", p.getName(), className)).append(String.format("%s.marshallable(%s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", p.getName())).append("} else {\n");
            closeIfBlock = true;
        }
        body.append(String.format("%s.object(%s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", p.getName()));
        if (closeIfBlock) {
            body.append("}\n");
        }
    }

    private void addFieldComments(Method dm, StringBuilder body) {
        body.append(String.format("if (dc.wire().bytes().retainsComments()){\n " + GENERATE_METHOD_WRITER + ".addComment(dc.wire().bytes(), %s);\n}\n", dm.getParameters()[0].getName()));
    }

    private void createMethodWriterListener(Method dm, StringBuilder body) {
        body.append("Object[] args$$ = new Object[]{\n");
        for (int i1 = 0; i1 < dm.getParameters().length; ++i1) {
            body.append("(Object)").append(dm.getParameters()[i1].getName());
            if (i1 >= dm.getParameters().length - 1) continue;
            body.append(",\n");
        }
        body.append("\n};\n");
        body.append(String.format("this.methodWriterListener.onWrite(\"%s\",args$$);\n", dm.getName()));
        if (dm.getParameterCount() == 1) {
            if (Marshallable.class.isAssignableFrom(dm.getParameterTypes()[0])) {
                body.append(String.format("if (args$$[0].getClass() == %s.class){\n", dm.getParameterTypes()[0].getName().replace('$', '.')));
                body.append("valueOut.marshallable((").append(MARSHALLABLE).append(")args$$[0]);\n");
                body.append("} else {\n");
                body.append("valueOut.object(args$$[0]);\n}\n");
            } else {
                body.append("valueOut.object(args$$[0]);\n");
            }
        } else {
            body.append("valueOut.object(args$$);\n");
        }
    }

    private StringBuilder recordHistory() {
        StringBuilder result = new StringBuilder();
        result.append("// record history\n");
        result.append("if (out.recordHistory()){\n").append("dc.wire().writeEventName(").append(METHOD_READER).append(".HISTORY).marshallable(MessageHistory.get());\n}\n");
        return result;
    }

    private StringBuilder methodReturn(Method dm, Class<?> interfaceClazz) {
        StringBuilder result = new StringBuilder();
        if (dm.getReturnType() == Void.class || dm.getReturnType() == Void.TYPE) {
            return result;
        }
        if (dm.getReturnType().isAssignableFrom(interfaceClazz) || dm.getReturnType() == interfaceClazz) {
            result.append("return this;\n");
        } else if (dm.getReturnType().isInterface()) {
            String index = this.methodWritersMap.computeIfAbsent(dm.getReturnType(), k -> "methodWriter" + k.getSimpleName() + "TL");
            result.append("// method return\n");
            result.append(String.format("%s result = (%s)%s.get();\n", dm.getReturnType().getName(), dm.getReturnType().getName(), index));
            result.append(String.format("if ( result == null) {\nresult = out.methodWriter(%s.class);\n %s.set(result);\n }\n", dm.getReturnType().getName(), index));
            result.append(String.format("return ((%s)result).documentContext(documentContextTL);\n", SHARED_DOCUMENT_CONTEXT));
        } else if (!dm.getReturnType().isPrimitive()) {
            result.append("return null;\n");
        } else if (dm.getReturnType() == Boolean.TYPE) {
            result.append("return false;\n");
        } else if (dm.getReturnType() == Byte.TYPE) {
            result.append("return (byte)0;\n");
        } else {
            result.append("return 0;\n");
        }
        return result;
    }

    private static /* synthetic */ String lambda$writeArrayOfParameters$10(Optional longConversion) {
        return longConversion.orElse("");
    }
}

