/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public interface WireParser
extends Consumer<WireIn> {
    public static final FieldNumberParselet SKIP_READABLE_BYTES = WireParser::skipReadable;

    @NotNull
    public static WireParser wireParser(WireParselet defaultConsumer) {
        return new VanillaWireParser(defaultConsumer, SKIP_READABLE_BYTES);
    }

    @NotNull
    public static WireParser wireParser(@NotNull WireParselet defaultConsumer, @NotNull FieldNumberParselet fieldNumberParselet) {
        return new VanillaWireParser(defaultConsumer, fieldNumberParselet);
    }

    public static void skipReadable(long ignoreMethodId, WireIn wire) {
        Bytes<?> bytes = wire.bytes();
        bytes.readPosition(bytes.readLimit());
    }

    public WireParselet getDefaultConsumer();

    public void parseOne(@NotNull WireIn var1);

    @Override
    default public void accept(@NotNull WireIn wireIn) {
        wireIn.startEvent();
        Bytes<?> bytes = wireIn.bytes();
        while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
            long start = bytes.readPosition();
            this.parseOne(wireIn);
            wireIn.consumePadding();
            if (bytes.readPosition() != start) continue;
            Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes.readRemaining() + " bytes left.");
            break;
        }
        wireIn.endEvent();
    }

    public WireParselet lookup(CharSequence var1);

    @NotNull
    default public VanillaWireParser registerOnce(WireKey key, WireParselet valueInConsumer) {
        CharSequence name = key.name();
        if (this.lookup(name) != null) {
            Jvm.warn().on(this.getClass(), "Unable to register multiple methods for " + name + " ignoring one.");
        } else {
            this.register(key, valueInConsumer);
        }
        return (VanillaWireParser)this;
    }

    @NotNull
    default public VanillaWireParser register(WireKey key, WireParselet valueInConsumer) {
        return this.register(key.toString(), valueInConsumer);
    }

    @NotNull
    public VanillaWireParser register(String var1, WireParselet var2);
}

