/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.compiler.CompilerUtils;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;

public enum GeneratedProxyClass {


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class from(String packageName, Set<Class> interfaces, String className) {
        Class<GeneratedProxyClass> interfaceClazz;
        int maxArgs = 0;
        ArrayList<Method> methods = new ArrayList<Method>();
        StringBuilder sb = new StringBuilder("package " + packageName + ";\n\nimport net.openhft.chronicle.core.Jvm;\nimport java.lang.reflect.InvocationHandler;\nimport java.lang.reflect.Method;\nimport java.util.ArrayList;\nimport java.util.List;\n");
        sb.append("public class " + className + " implements ");
        Iterator<Class> iterator = interfaces.iterator();
        StringBuilder methodArray = new StringBuilder();
        int count = 0;
        while (iterator.hasNext()) {
            interfaceClazz = iterator.next();
            String interfaceName = interfaceClazz.getName().replace("$", ".");
            sb.append(interfaceName);
            if (!interfaceClazz.isInterface()) {
                throw new IllegalArgumentException("expecting and interface instead of class=" + interfaceClazz.getName());
            }
            for (int i = 0; i < interfaceClazz.getMethods().length; ++i) {
                Method dm = interfaceClazz.getMethods()[i];
                if (dm.isDefault()) continue;
                if (dm.getExceptionTypes().length > 0) {
                    return null;
                }
                if (dm.getGenericReturnType() instanceof TypeVariableImpl) {
                    return null;
                }
                if (methods.contains(dm)) continue;
                maxArgs = Math.max(maxArgs, dm.getParameterCount());
                methods.add(dm);
                methodArray.append("\n");
                methodArray.append("    //").append(GeneratedProxyClass.createMethodSignature(dm, dm.getReturnType()));
                methodArray.append("    methods[" + count++ + "]=" + interfaceClazz.getName().replace("$", ".") + ".class.getMethods()[" + i + "];\n");
            }
            if (!iterator.hasNext()) break;
            sb.append(",\n              ");
        }
        sb.append(" {\n\n");
        GeneratedProxyClass.addFieldsAndConstructor(maxArgs, methods, sb, className, methodArray);
        GeneratedProxyClass.createProxyMethods(methods, sb);
        sb.append("}\n");
        try {
            interfaceClazz = GeneratedProxyClass.class;
            synchronized (GeneratedProxyClass.class) {
                // ** MonitorExit[interfaceClazz] (shouldn't be in output)
                return CompilerUtils.CACHED_COMPILER.loadFromJava(GeneratedProxyClass.class.getClassLoader(), packageName + "." + className, sb.toString());
            }
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + "\n" + sb.toString(), e));
        }
    }

    private static void addFieldsAndConstructor(int maxArgs, List<Method> declaredMethods, StringBuilder sb, String className, StringBuilder methodArray) {
        sb.append("  private final Object proxy;\n  private final InvocationHandler handler;\n  private Method[] methods = new  Method[" + declaredMethods.size() + "];\n");
        sb.append("  private List<Object[]> args = new ArrayList<Object[]>(" + (maxArgs + 1) + ");\n\n");
        sb.append("  public " + className + "(Object proxy, InvocationHandler handler) {\n    this.proxy = proxy;\n    this.handler = handler;\n");
        for (int j = 0; j <= maxArgs; ++j) {
            sb.append("    args.add(new Object[" + j + "]);\n");
        }
        sb.append((CharSequence)methodArray);
        sb.append("  }\n\n");
    }

    private static void createProxyMethods(List<Method> declaredMethods, StringBuilder sb) {
        int methodIndex = -1;
        for (Method dm : declaredMethods) {
            Class<?> returnType = dm.getReturnType();
            sb.append(GeneratedProxyClass.createMethodSignature(dm, returnType));
            sb.append("    Method method = this.methods[" + ++methodIndex + "];\n");
            sb.append("    Object[] a = this.args.get(" + dm.getParameterCount() + ");\n");
            GeneratedProxyClass.assignParametersToArgs(sb, dm);
            GeneratedProxyClass.callInvoke(sb, returnType);
        }
    }

    private static void callInvoke(StringBuilder sb, Class<?> returnType) {
        sb.append("    try {\n      ");
        if (returnType != Void.TYPE) {
            sb.append("return (" + returnType.getName() + ")");
        }
        sb.append(" handler.invoke(proxy,method,a);\n    } catch (Throwable throwable) {\n       throw Jvm.rethrow(throwable);\n    }\n  }\n");
    }

    private static void assignParametersToArgs(StringBuilder sb, Method dm) {
        int len = dm.getParameters().length;
        for (int j = 0; j < len; ++j) {
            String paramName = dm.getParameters()[j].getName();
            sb.append("    a[" + j + "] = " + paramName + ";\n");
        }
    }

    private static CharSequence createMethodSignature(Method dm, Class<?> returnType) {
        int len = dm.getParameters().length;
        StringBuilder result = new StringBuilder();
        String typeName = returnType.getName();
        result.append("  public ").append(typeName + " ").append(dm.getName()).append("(");
        for (int j = 0; j < len; ++j) {
            Parameter p = dm.getParameters()[j];
            result.append(p.getType().getTypeName().replace("$", ".") + " " + p.getName());
            if (j == len - 1) break;
            result.append(",");
        }
        result.append(") {\n");
        return result;
    }
}

