/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterInterceptor;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.GeneratedProxyClass;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodWriterBuilder<T>
implements Supplier<T>,
MethodWriterBuilder<T> {
    private final List<Class> interfaces = new ArrayList<Class>();
    @NotNull
    private final MethodWriterInvocationHandler handler;
    private ClassLoader classLoader;
    private static Map<Set<Class>, Class> setOfClassesToClassName = new ConcurrentHashMap<Set<Class>, Class>();
    private static AtomicLong proxyCount = new AtomicLong();
    private Class<?> proxyClass;

    public VanillaMethodWriterBuilder(@NotNull Class<T> tClass, @NotNull MethodWriterInvocationHandler handler) {
        this.interfaces.add(Closeable.class);
        this.interfaces.add(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handler = handler;
    }

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        this.interfaces.add(additionalClass);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handler.recordHistory(recordHistory);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterListener(MethodWriterListener methodWriterListener) {
        this.handler.methodWriterListener(methodWriterListener);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptor(MethodWriterInterceptor methodWriterInterceptor) {
        this.handler.methodWriterInterceptor(methodWriterInterceptor);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.handler.onClose(closeable);
        return this;
    }

    @NotNull
    public T build() {
        return this.get();
    }

    private static Class generatedProxyClass(Set<Class> interfaces) {
        return GeneratedProxyClass.from(interfaces, "Proxy" + proxyCount.incrementAndGet());
    }

    @Override
    @NotNull
    public T get() {
        if (this.proxyClass != null) {
            Constructor<?>[] constructors = this.proxyClass.getConstructors();
            try {
                Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
                Object proxy = Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
                return (T)constructors[0].newInstance(proxy, this.handler);
            }
            catch (Exception e) {
                Jvm.debug().on(this.getClass(), (Throwable)e);
            }
        }
        try {
            Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
            Object proxy = Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
            HashSet interfaces = new HashSet();
            Collections.addAll(interfaces, interfacesArr);
            Class o = setOfClassesToClassName.computeIfAbsent(interfaces, VanillaMethodWriterBuilder::generatedProxyClass);
            Constructor<?> constructor = o.getConstructors()[0];
            return (T)constructor.newInstance(proxy, this.handler);
        }
        catch (Throwable e) {
            Jvm.debug().on(this.getClass(), e);
            Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
            return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
        }
    }

    public MethodWriterBuilder<T> genericEvent(String genericEvent) {
        this.handler.genericEvent(genericEvent);
        return this;
    }

    public MethodWriterBuilder<T> useMethodIds(boolean useMethodIds) {
        this.handler.useMethodIds(useMethodIds);
        return this;
    }

    public Class<?> proxyClass() {
        return this.proxyClass;
    }

    public MethodWriterBuilder<T> proxyClass(Class<?> proxyClass) {
        if (proxyClass.isInterface()) {
            throw new IllegalArgumentException("expecting a class rather than an interface, proxyClass=" + proxyClass);
        }
        this.proxyClass = proxyClass;
        return this;
    }
}

