/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.wire.AbstractLongValueBitSet;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class BinaryLongValueBitSet
extends AbstractLongValueBitSet {
    public BinaryLongValueBitSet(LongReference[] words) {
        super(words);
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        int numberOfLongValues = wire.read("numberOfLongValues").int32();
        BinaryIntReference wordsInUse = new BinaryIntReference();
        Bytes<?> bytes = wire.bytes();
        wordsInUse.bytesStore(Objects.requireNonNull(bytes.bytesStore()), bytes.readPosition(), 4L);
        this.wordsInUse = wordsInUse;
        bytes.readSkip(4L);
        this.words = new BinaryLongReference[numberOfLongValues];
        for (int i = 0; i < numberOfLongValues; ++i) {
            BinaryLongReference ref = new BinaryLongReference();
            ref.bytesStore(Objects.requireNonNull(bytes.bytesStore()), bytes.readPosition(), 8L);
            this.words[i] = ref;
            bytes.readSkip(8L);
        }
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write("numberOfLongValues").int32(this.words.length);
        wire.bytes().writeSkip(4L);
        wire.bytes().writeSkip((long)(this.words.length * 8));
    }

    @Override
    @NotNull
    protected IntValue newIntValue() {
        return new BinaryIntReference();
    }
}

