/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodReaderInterceptor;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodReader
implements Closeable {
    static final Object[] NO_ARGS = new Object[0];
    static final Logger LOGGER = LoggerFactory.getLogger(MethodReader.class);
    public static final String HISTORY = "history";
    private final MarshallableIn in;
    @NotNull
    private final WireParser<Void> wireParser;
    private boolean closeIn = false;
    private boolean closed;
    private MethodReaderInterceptor methodReaderInterceptor;

    public MethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, MethodReaderInterceptor methodReaderInterceptor, Object ... objects) {
        this.in = in;
        this.methodReaderInterceptor = methodReaderInterceptor;
        if (objects[0] instanceof WireParselet) {
            defaultParselet = (WireParselet)objects[0];
        }
        this.wireParser = WireParser.wireParser(defaultParselet);
        HashSet<String> methodsHandled = new HashSet<String>();
        for (Object o : objects) {
            block7: for (Method m : o.getClass().getMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || ignoreDefault && m.getDeclaringClass().isInterface()) continue;
                try {
                    Object.class.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!methodsHandled.add(m.getName())) continue;
                    Class[] parameterTypes = m.getParameterTypes();
                    switch (parameterTypes.length) {
                        case 0: {
                            this.addParseletForMethod(o, m);
                            continue block7;
                        }
                        case 1: {
                            this.addParseletForMethod(o, m, parameterTypes[0]);
                            continue block7;
                        }
                        default: {
                            this.addParseletForMethod(o, m, parameterTypes);
                        }
                    }
                }
            }
        }
        if (this.wireParser.lookup(HISTORY) == null) {
            this.wireParser.register(() -> HISTORY, (s, v, $) -> v.marshallable(MessageHistory.get()));
        }
    }

    static void logMessage(@NotNull CharSequence s, @NotNull ValueIn v) {
        String rest;
        String name = s.toString();
        if (v.wireIn() instanceof BinaryWire) {
            Bytes bytes = Bytes.elasticByteBuffer((int)((int)(v.wireIn().bytes().readRemaining() * 3L / 2L + 64L)));
            long pos = v.wireIn().bytes().readPosition();
            v.wireIn().copyTo(new TextWire(bytes));
            v.wireIn().bytes().readPosition(pos);
            rest = bytes.toString();
            bytes.release();
        } else {
            rest = v.toString();
        }
        LOGGER.debug("read " + name + " - " + rest);
    }

    @NotNull
    public MethodReader closeIn(boolean closeIn) {
        this.closeIn = closeIn;
        return this;
    }

    private static Object actualInvoke(Method method, Object o, Object[] objects) throws InvocationTargetException {
        try {
            return method.invoke(o, objects);
        }
        catch (IllegalAccessException iae) {
            throw Jvm.rethrow((Throwable)iae);
        }
    }

    public void addParseletForMethod(Object o, @NotNull Method m, Class<?> parameterType) {
        m.setAccessible(true);
        String name = m.getName();
        if (parameterType.isInterface() || !ReadMarshallable.class.isAssignableFrom(parameterType)) {
            Object[] argArr = new Object[]{null};
            this.wireParser.register(m::getName, (s, v, $) -> {
                try {
                    if (Jvm.isDebug()) {
                        MethodReader.logMessage(s, v);
                    }
                    argArr[0] = v.object(argArr[0], parameterType);
                    this.invoke(o, m, argArr);
                }
                catch (Exception i) {
                    Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + argArr[0], (Throwable)i);
                }
            });
        } else {
            ReadMarshallable arg;
            try {
                Constructor<?> constructor = parameterType.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                arg = (ReadMarshallable)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                try {
                    arg = (ReadMarshallable)OS.memory().allocateInstance(parameterType);
                }
                catch (InstantiationException e1) {
                    throw Jvm.rethrow((Throwable)e1);
                }
            }
            ReadMarshallable[] argArr = new ReadMarshallable[]{arg};
            this.wireParser.register(m::getName, (s, v, $) -> {
                try {
                    if (Jvm.isDebug() && LOGGER.isDebugEnabled()) {
                        MethodReader.logMessage(s, v);
                    }
                    argArr[0] = v.object(argArr[0], parameterType);
                    this.invoke(o, m, argArr);
                }
                catch (Throwable t) {
                    Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + argArr[0], t);
                }
            });
        }
    }

    public void addParseletForMethod(Object o, @NotNull Method m) {
        m.setAccessible(true);
        String name = m.getName();
        this.wireParser.register(m::getName, (s, v, $) -> {
            try {
                if (Jvm.isDebug()) {
                    MethodReader.logMessage(s, v);
                }
                v.skipValue();
                this.invoke(o, m, NO_ARGS);
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + "()", (Throwable)i);
            }
        });
    }

    public void addParseletForMethod(Object o, @NotNull Method m, @NotNull Class[] parameterTypes) {
        m.setAccessible(true);
        Object[] args = new Object[parameterTypes.length];
        BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            for (Class clazz : parameterTypes) {
                a[i++] = v.object(clazz);
            }
        };
        String name = m.getName();
        this.wireParser.register(m::getName, (s, v, $) -> {
            try {
                if (Jvm.isDebug()) {
                    MethodReader.logMessage(s, v);
                }
                v.sequence(args, sequenceReader);
                this.invoke(o, m, args);
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + Arrays.toString(args), (Throwable)i);
            }
        });
    }

    private void invoke(Object o, @NotNull Method m, Object[] args) throws IllegalAccessException {
        try {
            if (this.methodReaderInterceptor != null) {
                this.methodReaderInterceptor.intercept(m, o, args, MethodReader::actualInvoke);
            } else {
                m.invoke(o, args);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            String msg = "Failure to dispatch message: " + m.getName() + " " + Arrays.asList(args);
            if (cause instanceof IllegalArgumentException) {
                Jvm.warn().on(o.getClass(), msg + " " + cause);
            }
            Jvm.warn().on(o.getClass(), msg, cause);
        }
    }

    public boolean readOne() {
        MessageHistory history = MessageHistory.get();
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isData()) {
                boolean bl = false;
                return bl;
            }
            history.reset(context.sourceId(), context.index());
            this.wireParser.accept(context.wire(), null);
        }
        return true;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MethodReaderInterceptor methodReaderInterceptor() {
        return this.methodReaderInterceptor;
    }
}

