/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.core.util.CharSequenceComparator;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import org.jetbrains.annotations.NotNull;

public class VanillaWireParser<O>
implements WireParser<O> {
    private final Map<CharSequence, WireParselet<O>> namedConsumer = new TreeMap<CharSequence, WireParselet<O>>((Comparator<CharSequence>)CharSequenceComparator.INSTANCE);
    private final Map<Integer, WireParselet<O>> numberedConsumer = new HashMap<Integer, WireParselet<O>>();
    private final WireParselet<O> defaultConsumer;

    public VanillaWireParser(WireParselet<O> defaultConsumer) {
        this.defaultConsumer = defaultConsumer;
    }

    @Override
    public WireParselet getDefaultConsumer() {
        return this.defaultConsumer;
    }

    @Override
    @NotNull
    public VanillaWireParser<O> register(@NotNull WireKey key, WireParselet<O> valueInConsumer) {
        this.namedConsumer.put(key.name(), valueInConsumer);
        this.numberedConsumer.put(key.code(), valueInConsumer);
        return this;
    }

    @Override
    public WireParselet<O> lookup(CharSequence name) {
        return this.namedConsumer.get(name);
    }

    @Override
    public WireParselet<O> lookup(int number) {
        return this.numberedConsumer.get(number);
    }
}

