/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodWriterInvocationHandler;
import net.openhft.chronicle.wire.MethodWriterListener;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMethodWriterInvocationHandler
extends AbstractInvocationHandler
implements MethodWriterInvocationHandler {
    private final Map<Method, Class[]> parameterMap = new ConcurrentHashMap<Method, Class[]>();
    protected boolean recordHistory;
    protected String genericEvent = "";
    private MethodWriterListener methodWriterListener;

    public AbstractMethodWriterInvocationHandler() {
        super(HashMap::new);
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (this.methodWriterListener != null) {
            this.methodWriterListener.onWrite(method.getName(), args);
        }
        this.handleInvoke(method, args);
        return ObjectUtils.defaultValue(method.getReturnType());
    }

    @Override
    public void genericEvent(String genericEvent) {
        this.genericEvent = genericEvent;
    }

    protected abstract void handleInvoke(Method var1, Object[] var2);

    protected void handleInvoke(@NotNull Method method, Object[] args, Wire wire) {
        String methodName;
        if (this.recordHistory) {
            wire.write("history").marshallable(MessageHistory.get());
        }
        if ((methodName = method.getName()).equals(this.genericEvent)) {
            this.writeGenericEvent(wire, method, args);
            return;
        }
        this.writeEvent(wire, method, methodName, args);
    }

    private void writeEvent(Wire wire, @NotNull Method method, String methodName, Object[] args) {
        ValueOut valueOut = wire.writeEventName(methodName);
        Class[] parameterTypes = this.parameterMap.computeIfAbsent(method, Method::getParameterTypes);
        switch (parameterTypes.length) {
            case 0: {
                valueOut.text("");
                break;
            }
            case 1: {
                valueOut.object(parameterTypes[0], args[0]);
                break;
            }
            default: {
                Class[] finalParameterTypes = parameterTypes;
                valueOut.sequence(args, (a, v) -> {
                    for (int i = 0; i < finalParameterTypes.length; ++i) {
                        v.object(finalParameterTypes[i], a[i]);
                    }
                });
            }
        }
    }

    private void writeGenericEvent(Wire wire, @NotNull Method method, Object[] args) {
        ValueOut valueOut = wire.writeEventName(args[0].toString());
        Class[] parameterTypes = this.parameterMap.computeIfAbsent(method, Method::getParameterTypes);
        switch (parameterTypes.length) {
            case 1: {
                valueOut.text("");
                break;
            }
            case 2: {
                valueOut.object(parameterTypes[1], args[1]);
                break;
            }
            default: {
                Class[] finalParameterTypes = parameterTypes;
                valueOut.sequence(args, (a, v) -> {
                    for (int i = 1; i < finalParameterTypes.length; ++i) {
                        v.object(finalParameterTypes[i], a[i]);
                    }
                });
            }
        }
    }

    @Override
    public void recordHistory(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    @Override
    public void methodWriterListener(MethodWriterListener methodWriterListener) {
        this.methodWriterListener = methodWriterListener;
    }
}

