/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodWriterInvocationHandler
implements InvocationHandler {
    @NotNull
    private final MarshallableOut appender;
    private final Map<Method, Class[]> parameterMap = new ConcurrentHashMap<Method, Class[]>();
    private boolean recordHistory;
    private Closeable closeable;

    MethodWriterInvocationHandler(@NotNull MarshallableOut appender) {
        this.appender = appender;
        this.recordHistory = appender.recordHistory();
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (declaringClass == Closeable.class && method.getName().equals("close")) {
            Closeable.closeQuietly((Object)this.closeable);
            return null;
        }
        try (DocumentContext context = this.appender.writingDocument();){
            Wire wire = context.wire();
            if (this.recordHistory) {
                wire.write("history").marshallable(MessageHistory.get());
            }
            ValueOut valueOut = wire.writeEventName(method.getName());
            Class[] parameterTypes = this.parameterMap.get(method);
            if (parameterTypes == null) {
                parameterTypes = method.getParameterTypes();
                this.parameterMap.put(method, parameterTypes);
            }
            switch (parameterTypes.length) {
                case 0: {
                    valueOut.text("");
                    break;
                }
                case 1: {
                    valueOut.object(parameterTypes[0], args[0]);
                    break;
                }
                default: {
                    Class[] finalParameterTypes = parameterTypes;
                    valueOut.sequence(v -> {
                        for (int i = 0; i < finalParameterTypes.length; ++i) {
                            v.object(finalParameterTypes[i], args[i]);
                        }
                    });
                }
            }
            wire.padToCacheAlign();
        }
        return ObjectUtils.defaultValue(method.getReturnType());
    }

    public void recordHistory(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    public void onClose(Closeable closeable) {
        this.closeable = closeable;
    }
}

