/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.util.Bit8StringInterner;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.bytes.util.UTF8StringInterner;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueInStack;
import net.openhft.chronicle.wire.ValueInState;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryWire
extends AbstractWire
implements Wire {
    private static final UTF8StringInterner UTF8 = new UTF8StringInterner(4096);
    private static final Bit8StringInterner BIT8 = new Bit8StringInterner(1024);
    private final FixedBinaryValueOut fixedValueOut = new FixedBinaryValueOut();
    @NotNull
    private final FixedBinaryValueOut valueOut;
    private final BinaryValueIn valueIn;
    private final boolean numericFields;
    private final boolean fieldLess;
    private final int compressedSize;
    private final WriteDocumentContext writeContext = new WriteDocumentContext(this);
    private final ReadDocumentContext readContext = new ReadDocumentContext(this);
    private final StringBuilder stringBuilder = new StringBuilder();
    DefaultValueIn defaultValueIn;
    private String compression;

    public BinaryWire(Bytes bytes) {
        this(bytes, false, false, false, Integer.MAX_VALUE, "binary", true);
    }

    public BinaryWire(Bytes bytes, boolean fixed, boolean numericFields, boolean fieldLess, int compressedSize, String compression, boolean supportDelta) {
        super(bytes, false);
        this.numericFields = numericFields;
        this.fieldLess = fieldLess;
        this.compressedSize = compressedSize;
        this.valueOut = this.getFixedBinaryValueOut(fixed);
        this.compression = compression;
        this.valueIn = supportDelta ? new DeltaValueIn() : new BinaryValueIn();
    }

    public static BinaryWire binaryOnly(Bytes bytes) {
        return new BinaryWire(bytes, false, false, false, Integer.MAX_VALUE, "binary", false);
    }

    StringBuilder acquireStringBuilder() {
        this.stringBuilder.setLength(0);
        return this.stringBuilder;
    }

    @NotNull
    protected FixedBinaryValueOut getFixedBinaryValueOut(boolean fixed) {
        return fixed ? this.fixedValueOut : new BinaryValueOut();
    }

    @NotNull
    protected BinaryValueIn getBinaryValueIn() {
        return new DeltaValueIn();
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.valueIn.resetState();
        this.valueOut.resetState();
    }

    public boolean fieldLess() {
        return this.fieldLess;
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext readingDocument() {
        this.readContext.start();
        return this.readContext;
    }

    @Override
    public DocumentContext readingDocument(long readLocation) {
        Bytes<?> bytes = this.bytes();
        long readPosition = bytes.readPosition();
        long readLimit = bytes.readLimit();
        bytes.readPositionUnlimited(readLocation);
        this.readContext.start();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        while (this.bytes.readRemaining() > 0L) {
            this.copyOne(wire);
        }
    }

    public void copyOne(@NotNull WireOut wire) {
        int peekCode = this.peekCode();
        block2 : switch (peekCode >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().uint8checked(peekCode);
                break;
            }
            case 8: {
                switch (peekCode) {
                    case 143: {
                        this.bytes.uncheckedReadSkipOne();
                        break block2;
                    }
                    case 142: {
                        this.bytes.uncheckedReadSkipOne();
                        this.bytes.readSkip(this.bytes.readUnsignedInt());
                        break block2;
                    }
                    case 128: {
                        this.bytes.uncheckedReadSkipOne();
                        int len = this.bytes.readUnsignedByte();
                        this.readWithLength(wire, len);
                        break block2;
                    }
                    case 129: {
                        this.bytes.uncheckedReadSkipOne();
                        int len = this.bytes.readUnsignedShort();
                        this.readWithLength(wire, len);
                        break block2;
                    }
                    case 130: {
                        this.bytes.uncheckedReadSkipOne();
                        int len = this.bytes.readInt();
                        this.readWithLength(wire, len);
                        break block2;
                    }
                    case 138: {
                        this.bytes.uncheckedReadSkipOne();
                        wire.getValueOut().bytes((BytesStore)this.bytes);
                        this.bytes.readPositionRemaining(this.bytes.readLimit(), 0L);
                        break block2;
                    }
                    case 141: {
                        this.bytes.uncheckedReadSkipOne();
                        long len2 = this.bytes.readLong();
                        long used = this.bytes.readLong();
                        wire.getValueOut().sequence(o -> {
                            wire.writeComment("length: " + len2 + ", used: " + used);
                            for (long i = 0L; i < len2; ++i) {
                                long v = this.bytes.readLong();
                                if (i == used) {
                                    o.leaf(true);
                                }
                                o.int64(v);
                            }
                        });
                        break block2;
                    }
                    case 135: {
                        this.bytes.uncheckedReadSkipOne();
                        StringBuilder sb = this.acquireStringBuilder();
                        this.readFieldAnchor(sb);
                        wire.write(sb);
                        break block2;
                    }
                    case 136: 
                    case 137: {
                        Object o2 = this.valueIn.object();
                        wire.getValueOut().object(o2);
                        break block2;
                    }
                }
                this.unknownCode(wire);
                break;
            }
            case 9: {
                this.bytes.uncheckedReadSkipOne();
                try {
                    Double d = this.readFloat0(peekCode);
                    wire.getValueOut().object(d);
                }
                catch (Exception e) {
                    this.unknownCode(wire);
                }
                break;
            }
            case 10: {
                this.bytes.uncheckedReadSkipOne();
                try {
                    if (peekCode == 175) {
                        wire.getValueOut().int64_0x(this.bytes.readLong());
                        break;
                    }
                    Number l = this.readInt0object(peekCode);
                    wire.getValueOut().object(l);
                }
                catch (Exception e) {
                    this.unknownCode(wire);
                }
                break;
            }
            case 11: {
                this.copySpecial(wire, peekCode);
                break;
            }
            case 12: 
            case 13: {
                StringBuilder fsb = this.readField(peekCode, AnyCodeMatch.ANY_CODE_MATCH, this.acquireStringBuilder(), false);
                wire.write(fsb);
                break;
            }
            case 14: 
            case 15: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = this.readText(peekCode, this.acquireStringBuilder());
                wire.getValueOut().text(sb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readWithLength(@NotNull WireOut wire, int len) {
        long lim = this.bytes.readLimit();
        try {
            this.bytes.readLimit(this.bytes.readPosition() + (long)len);
            ValueOut valueOut = wire.getValueOut();
            switch (this.getBracketTypeNext()) {
                case MAP: {
                    valueOut.marshallable(this::copyTo);
                    return;
                }
                case SEQ: {
                    valueOut.sequence(v -> this.copyTo(v.wireOut()));
                    return;
                }
                case NONE: {
                    valueOut.object(this.getValueIn().object());
                    return;
                }
            }
            return;
        }
        finally {
            this.bytes.readLimit(lim);
        }
    }

    private void unknownCode(@NotNull WireOut wire) {
        wire.writeComment("# " + BinaryWireCode.stringForCode(this.bytes.readUnsignedByte()));
    }

    private BracketType getBracketTypeNext() {
        int peekCode = this.peekCode();
        return this.getBracketTypeFor(peekCode);
    }

    BracketType getBracketTypeFor(int peekCode) {
        if (peekCode >= 192 && peekCode <= 223) {
            return BracketType.MAP;
        }
        switch (peekCode) {
            case 183: 
            case 189: {
                return BracketType.MAP;
            }
            case 138: 
            case 141: {
                return BracketType.NONE;
            }
        }
        return BracketType.SEQ;
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder(), AnyCodeMatch.ANY_CODE_MATCH);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        ValueInState curr = this.valueIn.curr();
        StringBuilder sb = this.acquireStringBuilder();
        if (curr.savedPosition() > 0L) {
            this.bytes.readPosition(curr.savedPosition() - 1L);
            curr.savedPosition(0L);
        }
        CharSequence name = key.name();
        while (this.bytes.readRemaining() > 0L) {
            long position = this.bytes.readPosition();
            this.readField(sb, key);
            if (sb.length() == 0 || StringUtils.isEqual((StringBuilder)sb, (CharSequence)name)) {
                return this.valueIn;
            }
            curr.addUnexpected(position);
            this.valueIn.consumeNext();
            this.consumePadding();
        }
        return this.read2(key, curr, sb, name);
    }

    protected ValueIn read2(@NotNull WireKey key, ValueInState curr, StringBuilder sb, CharSequence name) {
        long position2 = this.bytes.readLimit();
        for (int i = 0; i < curr.unexpectedSize(); ++i) {
            this.bytes.readPosition(curr.unexpected(i));
            this.readField(sb, key);
            if (sb.length() != 0 && !StringUtils.isEqual((StringBuilder)sb, (CharSequence)name)) continue;
            curr.removeUnexpected(i);
            curr.savedPosition(position2 + 1L);
            return this.valueIn;
        }
        this.bytes.readPosition(position2);
        if (this.defaultValueIn == null) {
            this.defaultValueIn = new DefaultValueIn(this);
        }
        this.defaultValueIn.wireKey = key;
        return this.defaultValueIn;
    }

    @Override
    @NotNull
    public ValueIn readEventName(@NotNull StringBuilder name) {
        this.readField(name, AnyCodeMatch.ANY_CODE_MATCH);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.readField(name, AnyCodeMatch.ANY_CODE_MATCH);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        if (this.peekCode() == 190) {
            this.bytes.uncheckedReadSkipOne();
            this.bytes.readUtf8((Appendable)s);
        } else {
            s.setLength(0);
        }
        return this;
    }

    @Nullable
    private StringBuilder readField(@NotNull StringBuilder name, WireKey key) {
        int peekCode = this.peekCodeAfterPadding();
        return this.readField(peekCode, key, name, true);
    }

    private int peekCodeAfterPadding() {
        int peekCode = this.peekCode();
        if (peekCode == 143 || peekCode == 142 || peekCode == 190) {
            this.consumePadding(false);
            peekCode = this.peekCode();
        }
        return peekCode;
    }

    @Override
    public <K> K readEvent(Class<K> expectedClass) {
        int peekCode = this.peekCodeAfterPadding();
        switch (peekCode >> 4) {
            case -1: {
                return null;
            }
            case 8: 
            case 11: {
                return this.readSpecialField(peekCode, expectedClass);
            }
            case 12: 
            case 13: {
                return this.readSmallField(peekCode, expectedClass);
            }
        }
        return null;
    }

    @NotNull
    private <K> K readSmallField(int peekCode, Class<K> expectedClass) {
        this.bytes.uncheckedReadSkipOne();
        int length = peekCode & 0x1F;
        String s = (String)BIT8.intern(this.bytes, length);
        this.bytes.readSkip((long)length);
        return (K)ObjectUtils.convertTo(expectedClass, (Object)s);
    }

    @Nullable
    private <K> K readSpecialField(int peekCode, Class<K> expectedClass) {
        switch (peekCode) {
            case 186: {
                this.bytes.uncheckedReadSkipOne();
                long fieldId = this.bytes.readStopBit();
                return (K)ObjectUtils.convertTo(expectedClass, (Object)fieldId);
            }
            case 183: 
            case 185: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = this.read8bit();
                return (K)ObjectUtils.convertTo(expectedClass, (Object)WireInternal.INTERNER.intern((CharSequence)sb));
            }
            case 135: {
                this.bytes.uncheckedReadSkipOne();
                throw new UnsupportedOperationException();
            }
            case 189: {
                this.bytes.uncheckedReadSkipOne();
                return this.valueIn.object(expectedClass);
            }
        }
        return null;
    }

    @Nullable
    StringBuilder read8bit() {
        StringBuilder sb = this.acquireStringBuilder();
        return this.bytes.read8bit(sb) ? sb : null;
    }

    @Override
    public void consumePadding() {
        this.consumePadding(false);
    }

    void consumePadding(boolean consumeType) {
        block6: while (true) {
            int code = this.peekCode();
            switch (code) {
                case 143: {
                    this.bytes.uncheckedReadSkipOne();
                    continue block6;
                }
                case 142: {
                    this.bytes.uncheckedReadSkipOne();
                    this.bytes.readSkip(this.bytes.readUnsignedInt());
                    continue block6;
                }
                case 182: {
                    if (!consumeType) {
                        return;
                    }
                }
                case 190: {
                    this.bytes.uncheckedReadSkipOne();
                    this.readUtf8();
                    continue block6;
                }
            }
            break;
        }
    }

    protected int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    private StringBuilder readField(int peekCode, WireKey key, @NotNull StringBuilder sb, boolean missingOk) {
        sb.setLength(0);
        switch (peekCode >> 4) {
            case -1: {
                break;
            }
            case 8: 
            case 11: {
                return this.readSpecialField(peekCode, key, sb);
            }
            case 12: 
            case 13: {
                return this.readSmallField(peekCode, sb);
            }
            default: {
                if (missingOk) break;
                throw new UnsupportedOperationException("Unknown code " + BinaryWireCode.stringForCode(peekCode));
            }
        }
        if (this.fieldLess) {
            return sb;
        }
        return null;
    }

    @NotNull
    private StringBuilder readSmallField(int peekCode, @NotNull StringBuilder sb) {
        this.bytes.uncheckedReadSkipOne();
        if (this.bytes.isDirectMemory()) {
            AppendableUtil.parse8bit_SB1((Bytes)this.bytes, (StringBuilder)sb, (int)(peekCode & 0x1F));
        } else {
            AppendableUtil.parse8bit((StreamingDataInput)this.bytes, (Appendable)sb, (int)(peekCode & 0x1F));
        }
        return sb;
    }

    @Nullable
    private StringBuilder readSpecialField(int peekCode, WireKey key, @NotNull StringBuilder sb) {
        switch (peekCode) {
            case 186: {
                this.bytes.uncheckedReadSkipOne();
                long fieldId = this.bytes.readStopBit();
                return this.readFieldNumber(key, sb, fieldId);
            }
            case 183: 
            case 185: {
                this.bytes.uncheckedReadSkipOne();
                this.bytes.read8bit(sb);
                return sb;
            }
            case 135: {
                this.bytes.uncheckedReadSkipOne();
                return this.readFieldAnchor(sb);
            }
            case 189: {
                this.valueIn.text(sb);
                return sb;
            }
        }
        return null;
    }

    protected StringBuilder readFieldAnchor(StringBuilder sb) {
        if (this.valueIn instanceof DeltaValueIn) {
            DeltaValueIn in = (DeltaValueIn)this.valueIn;
            int ref = Maths.toUInt31((long)this.bytes.readStopBit());
            if (ref >= in.inField.length) {
                in.inField = Arrays.copyOf(in.inField, in.inField.length * 2);
            }
            this.bytes.readUtf8((Appendable)sb);
            in.inField[ref] = sb.toString();
            return sb;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected StringBuilder readFieldNumber(WireKey key, @NotNull StringBuilder sb, long fieldId) {
        if (this.valueIn instanceof DeltaValueIn) {
            String s;
            DeltaValueIn in = (DeltaValueIn)this.valueIn;
            if (fieldId >= 0L && fieldId < (long)in.inField.length && (s = in.inField[(int)fieldId]) != null) {
                return sb.append(s);
            }
        }
        if (key == AnyCodeMatch.ANY_CODE_MATCH) {
            sb.append(fieldId);
            return sb;
        }
        int codeMatch = key.code();
        if (fieldId != (long)codeMatch) {
            return sb;
        }
        sb.append(key.name());
        return sb;
    }

    @NotNull
    private <ACS extends Appendable & CharSequence> ACS getStringBuilder(int code, @NotNull ACS sb) {
        this.bytes.parseUtf8(sb, code & 0x1F);
        return sb;
    }

    private void copySpecial(@NotNull WireOut wire, int peekCode) {
        switch (peekCode) {
            case 190: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = this.readUtf8();
                wire.writeComment(sb);
                break;
            }
            case 178: {
                wire.getValueOut().time(this.getValueIn().time());
                break;
            }
            case 179: {
                wire.getValueOut().date(this.getValueIn().date());
                break;
            }
            case 180: {
                wire.getValueOut().dateTime(this.getValueIn().dateTime());
                break;
            }
            case 181: {
                wire.getValueOut().zonedDateTime(this.getValueIn().zonedDateTime());
                break;
            }
            case 182: {
                long readPosition = this.bytes.readPosition();
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = this.readUtf8();
                if (StringUtils.isEqual((CharSequence)"snappy", (CharSequence)sb) || StringUtils.isEqual((CharSequence)"gzip", (CharSequence)sb) || StringUtils.isEqual((CharSequence)"lzw", (CharSequence)sb)) {
                    this.bytes.readPosition(readPosition);
                    wire.writeComment(sb);
                    wire.getValueOut().text(this.valueIn.text());
                    break;
                }
                wire.getValueOut().typePrefix(sb);
                break;
            }
            case 188: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = this.readUtf8();
                wire.getValueOut().typeLiteral(sb);
                break;
            }
            case 183: 
            case 185: {
                StringBuilder fsb = this.readField(peekCode, AnyCodeMatch.ANY_CODE_MATCH, this.acquireStringBuilder(), false);
                wire.write(fsb);
                break;
            }
            case 189: {
                this.bytes.uncheckedReadSkipOne();
                wire.startEvent();
                wire.getValueOut().leaf(true);
                if (this.peekCode() == 182) {
                    this.copyOne(wire);
                }
                this.copyOne(wire);
                wire.endEvent();
                break;
            }
            case 184: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb1 = this.readUtf8();
                wire.getValueOut().text(sb1);
                break;
            }
            case 186: {
                this.bytes.uncheckedReadSkipOne();
                final long code2 = this.bytes.readStopBit();
                if (this.valueIn instanceof DeltaValueIn) {
                    String name;
                    DeltaValueIn din = (DeltaValueIn)this.valueIn;
                    if (code2 >= 0L && code2 < (long)din.inField.length && (name = din.inField[(int)code2]) != null) {
                        wire.write(name);
                        break;
                    }
                }
                wire.write(new WireKey(){

                    @Override
                    @NotNull
                    public String name() {
                        return Long.toString(code2);
                    }

                    @Override
                    public int code() {
                        return (int)code2;
                    }
                });
                break;
            }
            case 187: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().bool(null);
                break;
            }
            case 176: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().bool(false);
                break;
            }
            case 177: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().bool(true);
                break;
            }
            default: {
                this.unknownCode(wire);
            }
        }
    }

    private long readInt(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 11: {
                switch (code) {
                    case 176: {
                        return 0L;
                    }
                    case 177: {
                        return 1L;
                    }
                }
                break;
            }
            case 9: {
                double d = this.readFloat0(code);
                return (long)d;
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private double readFloat0(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return this.bytes.readFloat();
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private Number readFloat0bject(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return Float.valueOf(this.bytes.readFloat());
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    long readInt0(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: 
            case 168: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: 
            case 169: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: 
            case 175: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    Number readInt0object(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: 
            case 168: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: 
            case 169: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: 
            case 175: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private boolean isSmallInt(int code) {
        return (code & 0x80) == 0;
    }

    double readFloat(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 9: {
                return this.readFloat0(code);
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    @Override
    @NotNull
    public ValueOut write() {
        if (!this.fieldLess) {
            this.writeField("");
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull WireKey key) {
        return this.writeEventName(key.name());
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull CharSequence name) {
        this.writeCode(185).write8bit(name);
        return this.valueOut;
    }

    @Override
    public void startEvent() {
        this.writeCode(189);
    }

    @Override
    public void endEvent() {
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(key.code());
            } else {
                this.writeField(key.name());
            }
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(WireKey.toCode(key));
            } else {
                this.writeField(key);
            }
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        this.writeCode(190);
        this.bytes.writeUtf8(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        if (paddingToAdd < 0) {
            throw new IllegalStateException("Cannot add " + paddingToAdd + " bytes of padding");
        }
        if (paddingToAdd >= 5) {
            this.writeCode(142).writeUnsignedInt((long)(paddingToAdd - 5)).writeSkip((long)(paddingToAdd - 5));
        } else {
            for (int i = 0; i < paddingToAdd; ++i) {
                this.writeCode(143);
            }
        }
        return this;
    }

    private void writeField(@NotNull CharSequence name) {
        int len = name.length();
        if (len < 32) {
            this.writeField0(name, len);
        } else {
            this.writeCode(183).write8bit(name);
        }
    }

    private void writeField0(@NotNull CharSequence name, int len) {
        if (len > 0 && Character.isDigit(name.charAt(0))) {
            try {
                this.writeField(Integer.parseInt(name.toString()));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.bytes.writeByte((byte)(192 + len));
        this.bytes.append8bit(name);
    }

    private void writeField(int code) {
        this.writeCode(186);
        this.bytes.writeStopBit((long)code);
    }

    protected Bytes writeCode(int code) {
        return (Bytes)this.bytes.writeByte((byte)code);
    }

    @Nullable
    <ACS extends Appendable & CharSequence> ACS readText(int code, @NotNull ACS sb) {
        if (code <= 127) {
            AppendableUtil.append(sb, (long)code);
            return sb;
        }
        switch (code >> 4) {
            case 8: {
                switch (code) {
                    case 128: 
                    case 129: 
                    case 130: {
                        if (sb instanceof StringBuilder) {
                            this.bytes.uncheckedReadSkipBackOne();
                            this.valueIn.bytesStore((StringBuilder)sb);
                        } else if (sb instanceof Bytes) {
                            this.bytes.uncheckedReadSkipBackOne();
                            this.valueIn.bytesStore((Bytes)sb);
                        } else {
                            throw new IllegalArgumentException("Expected a StringBuilder or Bytes");
                        }
                        return sb;
                    }
                }
            }
            case 11: {
                switch (code) {
                    case 187: {
                        AppendableUtil.append(sb, (String)"null");
                        return sb;
                    }
                    case 177: {
                        AppendableUtil.append(sb, (String)"true");
                        return sb;
                    }
                    case 176: {
                        AppendableUtil.append(sb, (String)"false");
                        return sb;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 184: 
                    case 188: {
                        if (this.bytes.readUtf8(sb)) {
                            return sb;
                        }
                        return null;
                    }
                    case 189: {
                        this.valueIn.text((StringBuilder)sb);
                        return sb;
                    }
                }
                return null;
            }
            case 9: {
                AppendableUtil.append(sb, (double)this.readFloat(code));
                return sb;
            }
            case 10: {
                AppendableUtil.append(sb, (long)this.readInt(code));
                return sb;
            }
            case 14: 
            case 15: {
                return this.getStringBuilder(code, sb);
            }
        }
        throw new UnsupportedOperationException("code=0x" + String.format("%02X ", code).trim());
    }

    int readCode() {
        return this.bytes.uncheckedReadUnsignedByte();
    }

    @NotNull
    public String toString() {
        return this.bytes.toDebugString();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new BinaryLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new BinaryIntReference();
    }

    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        return new BinaryLongArrayReference();
    }

    @Nullable
    StringBuilder readUtf8() {
        StringBuilder sb = this.acquireStringBuilder();
        return this.bytes.readUtf8((Appendable)sb) ? sb : null;
    }

    class DeltaValueIn
    extends BinaryValueIn {
        Marshallable[] inObjects;
        String[] inField;
        byte[] inFieldHash;

        DeltaValueIn() {
            this.inObjects = new Marshallable[128];
            this.inField = new String[128];
            this.inFieldHash = new byte[128];
        }

        @Override
        protected <T> T anchor() {
            long ref = BinaryWire.this.bytes.readStopBit();
            if (ref >= (long)this.inObjects.length) {
                this.inObjects = Arrays.copyOf(this.inObjects, this.inObjects.length * 2);
            }
            Object t = super.typedMarshallable0();
            this.inObjects[Maths.toUInt31((long)ref)] = (Marshallable)t;
            return t;
        }

        @Override
        protected <T> T updateAlias() {
            int ref = Maths.toUInt31((long)BinaryWire.this.bytes.readStopBit());
            Marshallable previous = this.inObjects[ref];
            if (previous == null) {
                throw new IllegalStateException("Unknown ref: " + ref);
            }
            super.marshallable(previous, false);
            return (T)previous;
        }

        @Override
        public int int32(int previous) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 168: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFFFF00 | BinaryWire.this.bytes.readUnsignedByte();
                }
                case 169: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFF0000 | BinaryWire.this.bytes.readUnsignedShort();
                }
            }
            return super.int32();
        }

        @Override
        public long int64(long previous) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 168: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFFFFFFFFFFFF00L | (long)BinaryWire.this.bytes.readUnsignedByte();
                }
                case 169: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFFFFFFFFFF0000L | (long)BinaryWire.this.bytes.readUnsignedShort();
                }
            }
            return super.int64();
        }
    }

    protected class BinaryValueIn
    implements ValueIn {
        final ValueInStack stack = new ValueInStack();

        protected BinaryValueIn() {
        }

        @Override
        public void resetState() {
            this.stack.reset();
        }

        public void pushState() {
            this.stack.push();
        }

        public void popState() {
            this.stack.pop();
        }

        public ValueInState curr() {
            return this.stack.curr();
        }

        @Override
        public BracketType getBracketType() {
            BinaryWire.this.consumePadding();
            switch (BinaryWire.this.peekCode()) {
                case 129: {
                    return BinaryWire.this.getBracketTypeFor(BinaryWire.this.bytes.readUnsignedByte(BinaryWire.this.bytes.readPosition() + 2L + 1L));
                }
                case 130: {
                    return BinaryWire.this.getBracketTypeFor(BinaryWire.this.bytes.readUnsignedByte(BinaryWire.this.bytes.readPosition() + 4L + 1L));
                }
            }
            return BracketType.NONE;
        }

        @NotNull
        WireIn text(@NotNull Consumer<String> s) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    s.accept(null);
                    break;
                }
                case 184: {
                    s.accept(BinaryWire.this.bytes.readUtf8());
                    break;
                }
                default: {
                    if (code >= 224 && code <= 255) {
                        StringBuilder sb = BinaryWire.this.acquireStringBuilder();
                        BinaryWire.this.bytes.parseUtf8((Appendable)sb, code & 0x1F);
                        s.accept(WireInternal.INTERNER.intern((CharSequence)sb));
                        break;
                    }
                    this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        private boolean isText(int code) {
            return code == 184 || code >= 224 && code <= 255;
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                sb.setLength(0);
                return null;
            }
            StringBuilder text = BinaryWire.this.readText(code, sb);
            if (text == null) {
                this.cantRead(code);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                bytes.readPosition(0L);
                return null;
            }
            Bytes text = BinaryWire.this.readText(code, bytes);
            if (text == null) {
                this.cantRead(code);
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String text() {
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    return null;
                }
                case 184: {
                    long len0 = BinaryWire.this.bytes.readStopBit();
                    if (len0 == -1L) {
                        return null;
                    }
                    int len = Maths.toUInt31((long)len0);
                    long limit = BinaryWire.this.bytes.readLimit();
                    long end = BinaryWire.this.bytes.readPosition() + (long)len;
                    try {
                        BinaryWire.this.bytes.readLimit(end);
                        String string = (String)UTF8.intern(BinaryWire.this.bytes);
                        return string;
                    }
                    finally {
                        BinaryWire.this.bytes.readLimit(limit);
                        BinaryWire.this.bytes.readPosition(end);
                    }
                }
                case 182: {
                    byte[] bytes;
                    StringBuilder sb = BinaryWire.this.readUtf8();
                    if (sb != null && (bytes = Compression.uncompress((CharSequence)sb, (Object)this, ValueIn::bytes)) != null) {
                        return new String(bytes, StandardCharsets.UTF_8);
                    }
                    StringBuilder text = BinaryWire.this.readText(code, BinaryWire.this.acquireStringBuilder());
                    return WireInternal.INTERNER.intern((CharSequence)text);
                }
            }
            StringBuilder text = BinaryWire.this.readText(code, BinaryWire.this.acquireStringBuilder());
            return text == null ? null : WireInternal.INTERNER.intern((CharSequence)text);
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                ((BytesStore)toBytes).isPresent(false);
                return BinaryWire.this;
            }
            if (code == 182) {
                StringBuilder sb = BinaryWire.this.readUtf8();
                assert (sb != null);
                long length2 = this.readLength();
                int code2 = BinaryWire.this.readCode();
                if (code2 != 138) {
                    this.cantRead(code);
                }
                toBytes.clear();
                BinaryWire.this.bytes.readWithLength(length2 - 1L, b -> Compression.uncompress((CharSequence)sb, (BytesIn)b, (BytesOut)toBytes));
                return this.wireIn();
            }
            if (code != 138) {
                this.cantRead(code);
            }
            toBytes.clear();
            BinaryWire.this.bytes.readWithLength(length - 1L, arg_0 -> ((BytesOut)toBytes).write(arg_0));
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesLiteral(@NotNull BytesOut toBytes) {
            long length = this.readLength();
            toBytes.clear();
            toBytes.write((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        public BytesStore bytesLiteral() {
            int length = Maths.toUInt31((long)this.readLength());
            HeapBytesStore toBytes = BytesStore.wrap((byte[])new byte[length]);
            toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), (long)length);
            BinaryWire.this.bytes.readSkip((long)length);
            return toBytes;
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                toBytes.isPresent(false);
                return BinaryWire.this;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            long startAddr = BinaryWire.this.bytes.address(BinaryWire.this.bytes.readPosition());
            toBytes.set(startAddr, length - 1L);
            BinaryWire.this.bytes.readSkip(length - 1L);
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, @NotNull BooleanConsumer consumer) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (compareBytes.readRemaining() == --length) {
                consumer.accept(Boolean.valueOf(BinaryWire.this.bytes.equalBytes(compareBytes, length)));
            } else {
                consumer.accept(Boolean.valueOf(false));
            }
            BinaryWire.this.bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @Nullable
        public BytesStore bytesStore() {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 138: 
                case 141: {
                    NativeBytesStore toBytes = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)length);
                    toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                    BinaryWire.this.bytes.readSkip(length);
                    return toBytes;
                }
                case 182: {
                    StringBuilder sb = BinaryWire.this.readUtf8();
                    byte[] bytes = Compression.uncompress((CharSequence)sb, (Object)this, ValueIn::bytes);
                    if (bytes != null) {
                        return BytesStore.wrap((byte[])bytes);
                    }
                    throw new UnsupportedOperationException("Unsupported type " + sb);
                }
                case 187: {
                    return null;
                }
            }
            this.cantRead(code);
            throw new AssertionError();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bytesStore(@NotNull StringBuilder sb) {
            sb.setLength(0);
            BinaryWire.this.consumePadding();
            long pos = BinaryWire.this.bytes.readPosition();
            long length = this.readLength();
            if (length < 0L) {
                throw this.cantRead(BinaryWire.this.peekCode());
            }
            int code = BinaryWire.this.readCode();
            if (code == 138) {
                for (long i = 1L; i < length; ++i) {
                    sb.append((char)BinaryWire.this.bytes.readUnsignedByte());
                }
            } else {
                BinaryWire.this.bytes.readPosition(pos);
                long limit = BinaryWire.this.bytes.readLimit();
                BinaryWire.this.bytes.readLimit(pos + 4L + length);
                try {
                    sb.append(Wires.fromSizePrefixedBlobs(BinaryWire.this.bytes));
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit);
                }
            }
        }

        public void bytesStore(@NotNull Bytes toBytes) {
            toBytes.clear();
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                toBytes.isPresent(false);
                return;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            toBytes.readLimit(length);
            BinaryWire.this.bytes.readSkip(length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (length > BinaryWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = BinaryWire.this.bytes.readLimit();
            long limit = BinaryWire.this.bytes.readPosition() + length;
            try {
                BinaryWire.this.bytes.readLimit(limit);
                bytesConsumer.readMarshallable((BytesIn)BinaryWire.this.bytes);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit0);
                BinaryWire.this.bytes.readPosition(limit);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public byte[] bytes() {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                return null;
            }
            if (code == 182) {
                StringBuilder sb = BinaryWire.this.readUtf8();
                assert ("byte[]".contentEquals(sb));
                length = this.readLength();
                code = BinaryWire.this.readCode();
            }
            if (code != 138) {
                this.cantRead(code);
            }
            byte[] bytes2 = new byte[Maths.toUInt31((long)(length - 1L))];
            BinaryWire.this.bytes.readWithLength(length - 1L, b -> b.read(bytes2));
            return bytes2;
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return BinaryWire.this;
        }

        @Override
        public long readLength() {
            int code = BinaryWire.this.peekCode();
            block7: while (true) {
                switch (code) {
                    case 128: {
                        BinaryWire.this.bytes.uncheckedReadSkipOne();
                        return BinaryWire.this.bytes.uncheckedReadUnsignedByte();
                    }
                    case 129: {
                        BinaryWire.this.bytes.uncheckedReadSkipOne();
                        return BinaryWire.this.bytes.readUnsignedShort();
                    }
                    case 130: {
                        BinaryWire.this.bytes.uncheckedReadSkipOne();
                        return BinaryWire.this.bytes.readUnsignedInt();
                    }
                    case 182: {
                        BinaryWire.this.bytes.uncheckedReadSkipOne();
                        long len = BinaryWire.this.bytes.readStopBit();
                        BinaryWire.this.bytes.readSkip(len);
                        return this.readLength();
                    }
                    case 142: 
                    case 143: 
                    case 190: {
                        BinaryWire.this.consumePadding();
                        continue block7;
                    }
                }
                break;
            }
            return AnyCodeMatch.ANY_CODE_MATCH.code();
        }

        @Override
        public WireIn skipValue() {
            long length = this.readLength();
            if (length < 0L) {
                this.object();
            } else {
                BinaryWire.this.bytes.readSkip(length);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    tFlag.accept(t, null);
                    break;
                }
                case 176: {
                    tFlag.accept(t, Boolean.valueOf(false));
                    break;
                }
                case 177: {
                    tFlag.accept(t, Boolean.valueOf(true));
                    break;
                }
                default: {
                    throw this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.bytes.readUnsignedByte();
            if (this.isText(code)) {
                tb.accept(t, Byte.parseByte(this.text()));
            } else {
                tb.accept(t, (byte)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Short.parseShort(this.text()));
            } else {
                ti.accept(t, (short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Short.parseShort(this.text()));
            } else {
                ti.accept(t, (short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Integer.parseInt(this.text()));
            } else {
                ti.accept(t, (int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Integer.parseInt(this.text()));
            } else {
                ti.accept(t, (int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tl.accept(t, Long.parseLong(this.text()));
            } else {
                tl.accept(t, BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tl.accept(t, Long.parseLong(this.text()));
            } else {
                tl.accept(t, BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tf.accept(t, Float.parseFloat(this.text()));
            } else {
                tf.accept(t, (float)BinaryWire.this.readFloat(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            BinaryWire.this.consumePadding(false);
            int code = BinaryWire.this.readCode();
            td.accept(t, BinaryWire.this.readFloat(code));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 178) {
                setLocalTime.accept(t, this.readLocalTime());
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        private LocalTime readLocalTime() {
            StringBuilder sb = BinaryWire.this.readUtf8();
            return LocalTime.parse(sb);
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 181) {
                StringBuilder sb = BinaryWire.this.readUtf8();
                tZonedDateTime.accept(t, ZonedDateTime.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 179) {
                StringBuilder sb = BinaryWire.this.readUtf8();
                tLocalDate.accept(t, LocalDate.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public boolean hasNext() {
            return BinaryWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            return this.hasNext();
        }

        @Override
        public UUID uuid() {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                return new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong());
            }
            throw this.cantRead(code);
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                tuuid.accept(t, new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong()));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 141) {
                if (!(values instanceof BinaryLongArrayReference)) {
                    values = new BinaryLongArrayReference();
                    setter.accept(t, values);
                }
                Byteable b = (Byteable)values;
                long length = BinaryLongArrayReference.peakLength((BytesStore)BinaryWire.this.bytes, (long)BinaryWire.this.bytes.readPosition());
                b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                BinaryWire.this.bytes.readSkip(length);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(LongValue value) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 167) {
                this.cantRead(code);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof BinaryLongReference)) {
                value = new BinaryLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 166) {
                this.cantRead(code);
            }
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 4L) {
                value = new BinaryIntReference();
                setter.accept(t, value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            if (this.isNull()) {
                return false;
            }
            long length = this.readLength();
            if (length < 0L) {
                throw this.cantRead(BinaryWire.this.peekCode());
            }
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                tReader.accept(t, this);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 130) {
                this.cantRead(code);
            }
            int length = BinaryWire.this.bytes.readInt();
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + (long)length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                tReader.accept(t, kls, this);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            BinaryWire.this.consumePadding();
            this.pushState();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                T t = marshallableReader.apply(BinaryWire.this);
                return t;
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            }
            T t = marshallableReader.apply(BinaryWire.this);
            return t;
            finally {
                this.popState();
            }
        }

        @Override
        public boolean isTyped() {
            int code = BinaryWire.this.peekCode();
            return code == 182;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() throws IORuntimeException {
            this.pushState();
            try {
                int code = BinaryWire.this.readCode();
                switch (code) {
                    case 182: {
                        T t = this.typedMarshallable0();
                        return t;
                    }
                    case 187: {
                        T t = null;
                        return t;
                    }
                    case 136: {
                        T t = this.anchor();
                        return t;
                    }
                    case 137: {
                        T t = this.updateAlias();
                        return t;
                    }
                }
                this.cantRead(code);
                T t = null;
                return t;
            }
            finally {
                this.popState();
            }
        }

        protected <T> T typedMarshallable0() {
            Class clazz;
            StringBuilder sb = BinaryWire.this.readUtf8();
            try {
                clazz = BinaryWire.this.classLookup().forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
            if (Demarshallable.class.isAssignableFrom(clazz)) {
                return (T)this.demarshallable(clazz);
            }
            if (!Marshallable.class.isAssignableFrom(clazz) && !Demarshallable.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("its not possible to Marshallable and object that is not of type Marshallable, type=" + sb);
            }
            ReadMarshallable m = (ReadMarshallable)ObjectUtils.newInstance((Class)clazz);
            this.marshallable(m, true);
            return (T)ReadResolvable.readResolve((Object)m);
        }

        protected <T> T updateAlias() {
            throw new UnsupportedOperationException("Used by DeltaWire");
        }

        protected <T> T anchor() {
            throw new UnsupportedOperationException("Used by DeltaWire");
        }

        @Override
        public Class typePrefix() {
            int code = BinaryWire.this.peekCode();
            if (code != 182) {
                return null;
            }
            BinaryWire.this.bytes.uncheckedReadSkipOne();
            StringBuilder sb = BinaryWire.this.readUtf8();
            try {
                return BinaryWire.this.classLookup().forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            StringBuilder sb = BinaryWire.this.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            if (code == 182) {
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
            } else if (code == 187) {
                sb.setLength(0);
                sb.append("!null");
            } else {
                this.cantRead(code);
            }
            ts.accept(t, sb);
            return this;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            int code = BinaryWire.this.readCode();
            if (code == 188) {
                StringBuilder sb = BinaryWire.this.readUtf8();
                classNameConsumer.accept(t, sb);
            } else if (code == 187) {
                classNameConsumer.accept(t, null);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public <T> Class<T> typeLiteral() {
            int code = BinaryWire.this.readCode();
            if (code == 188) {
                StringBuilder sb = BinaryWire.this.readUtf8();
                try {
                    return BinaryWire.this.classLookup().forName((CharSequence)sb);
                }
                catch (ClassNotFoundException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            if (code == 187) {
                return null;
            }
            throw this.cantRead(code);
        }

        @Override
        @NotNull
        public boolean marshallable(@NotNull ReadMarshallable object) throws BufferUnderflowException, IORuntimeException {
            return this.marshallable(object, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean marshallable(@NotNull ReadMarshallable object, boolean overwrite) throws BufferUnderflowException, IORuntimeException {
            if (this.isNull()) {
                return false;
            }
            this.pushState();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    if (overwrite) {
                        object.readMarshallable(BinaryWire.this);
                    }
                    Wires.readMarshallable(object, BinaryWire.this, false);
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                    this.popState();
                }
            } else {
                throw new IORuntimeException("Length unknown");
            }
            return true;
        }

        @Override
        public boolean isNull() {
            BinaryWire.this.consumePadding(true);
            if (BinaryWire.this.peekCode() == 187) {
                BinaryWire.this.bytes.uncheckedReadSkipOne();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object marshallable(Object object, SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            if (this.isNull()) {
                return null;
            }
            this.pushState();
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 136: 
                case 137: {
                    Object o;
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    Object t = o = code == 136 ? this.anchor() : this.updateAlias();
                    if (object == null || o.getClass() != object.getClass()) {
                        return o instanceof Marshallable ? Wires.deepCopy((Marshallable)o) : o;
                    }
                    Wires.copyTo(o, object);
                    return object;
                }
            }
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    strategy.readUsing(object, this);
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                    this.popState();
                }
            } else {
                throw new IORuntimeException("Length unknown " + length);
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Demarshallable demarshallable(@NotNull Class clazz) throws BufferUnderflowException, IORuntimeException {
            if (this.isNull()) {
                return null;
            }
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    Object t = Demarshallable.newInstance(clazz, this.wireIn());
                    return t;
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            }
            return Demarshallable.newInstance(clazz, this.wireIn());
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        private long readTextAsLong() throws IORuntimeException, BufferUnderflowException {
            BinaryWire.this.bytes.uncheckedReadSkipBackOne();
            String text = this.text();
            if (text == null) {
                throw new NullPointerException();
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return Math.round(Double.parseDouble(text));
            }
        }

        private double readTextAsDouble() throws IORuntimeException, BufferUnderflowException {
            BinaryWire.this.bytes.uncheckedReadSkipBackOne();
            String text = this.text();
            if (text == null || text.length() == 0) {
                return Double.NaN;
            }
            return Double.parseDouble(text);
        }

        @Override
        public boolean bool() throws IORuntimeException {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                return Boolean.valueOf(this.text());
            }
            switch (code) {
                case 177: {
                    return true;
                }
                case 176: {
                    return false;
                }
            }
            throw new IORuntimeException(BinaryWireCode.stringForCode(code));
        }

        @Override
        public byte int8() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 127L || value < -128L) {
                throw new IllegalStateException();
            }
            return (byte)value;
        }

        @Override
        public short int16() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 32767L || value < -32768L) {
                throw new IllegalStateException();
            }
            return (short)value;
        }

        @Override
        public int uint16() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 0x100000000L || value < 0L) {
                throw new IllegalStateException("value " + value + " cannot be cast to an unsigned 16-bit int without loss of information");
            }
            return (int)value;
        }

        @Override
        public int int32() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalStateException("value " + value + " cannot be cast to int without loss of information");
            }
            return (int)value;
        }

        @Override
        public long int64() {
            int code = BinaryWire.this.readCode();
            if (code == 143 || code == 142 || code == 190) {
                BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                BinaryWire.this.consumePadding();
                code = BinaryWire.this.readCode();
            }
            switch (code >> 4) {
                case 9: {
                    return (long)BinaryWire.this.readFloat0(code);
                }
                case 10: {
                    return BinaryWire.this.readInt0(code);
                }
            }
            return this.readTextAsLong();
        }

        @Override
        public double float64() {
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsDouble() : (double)BinaryWire.this.readInt0(code);
        }

        @Override
        public float float32() {
            double value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            double d = value = this.isText(code) ? this.readTextAsDouble() : BinaryWire.this.readFloat0(code);
            if (Double.isFinite(value) && (value > 3.4028234663852886E38 || value < -3.4028234663852886E38)) {
                throw new IllegalStateException("Cannot convert " + value + " to float");
            }
            return (float)value;
        }

        @NotNull
        private RuntimeException cantRead(int code) {
            throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object objectWithInferredType(Object using, SerializationStrategy strategy, Class type) {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                BinaryWire.this.bytes.uncheckedReadSkipOne();
                return code;
            }
            switch (code >> 4) {
                case 8: {
                    switch (code) {
                        case 129: 
                        case 130: {
                            if (using instanceof StringBuilder) {
                                this.bytesStore((StringBuilder)using);
                                return using;
                            }
                            if (using instanceof Bytes) {
                                this.bytesStore((Bytes)using);
                                return using;
                            }
                            long pos = BinaryWire.this.bytes.readPosition();
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            int len = code == 129 ? BinaryWire.this.bytes.readUnsignedShort() : BinaryWire.this.bytes.readInt();
                            code = BinaryWire.this.peekCode();
                            if (code == 138) {
                                BinaryWire.this.bytes.readPosition(pos);
                                return this.bytesStore();
                            }
                            long lim = BinaryWire.this.bytes.readLimit();
                            try {
                                BinaryWire.this.bytes.readLimit(BinaryWire.this.bytes.readPosition() + (long)len);
                                Object object = strategy.readUsing(using, this, type);
                                return object;
                            }
                            finally {
                                BinaryWire.this.bytes.readLimit(lim);
                            }
                        }
                        case 138: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            long length = BinaryWire.this.bytes.readRemaining();
                            if (length == 0L) {
                                return BytesStore.empty();
                            }
                            NativeBytesStore toBytes = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)length);
                            toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                            BinaryWire.this.bytes.readSkip(length);
                            return toBytes;
                        }
                        case 136: 
                        case 137: {
                            return this.typedMarshallable();
                        }
                    }
                    break;
                }
                case 11: {
                    switch (code) {
                        case 176: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return Boolean.FALSE;
                        }
                        case 177: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return Boolean.TRUE;
                        }
                        case 187: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return null;
                        }
                        case 184: {
                            return this.text();
                        }
                        case 182: {
                            Class clazz2;
                            BinaryWire.this.readCode();
                            StringBuilder sb = BinaryWire.this.readUtf8();
                            try {
                                clazz2 = BinaryWire.this.classLookup().forName((CharSequence)sb);
                            }
                            catch (ClassNotFoundException e) {
                                throw new IORuntimeException((Throwable)e);
                            }
                            return this.object(null, clazz2);
                        }
                        case 189: {
                            if (using == null) {
                                strategy = SerializationStrategies.MAP;
                                using = strategy.newInstance(null);
                            }
                            strategy.readUsing(using, BinaryWire.this.valueIn);
                            return ObjectUtils.convertTo((Class)type, (Object)using);
                        }
                        case 178: {
                            return this.time();
                        }
                        case 179: {
                            return this.date();
                        }
                        case 180: {
                            return this.dateTime();
                        }
                        case 181: {
                            return this.zonedDateTime();
                        }
                        case 188: {
                            return this.typeLiteral();
                        }
                    }
                    break;
                }
                case 9: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return BinaryWire.this.readFloat0bject(code);
                }
                case 10: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    if (code == 160) {
                        return new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong());
                    }
                    return BinaryWire.this.readInt0object(code);
                }
            }
            return this.text();
        }

        void consumeNext() {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                BinaryWire.this.bytes.uncheckedReadSkipOne();
                return;
            }
            switch (code >> 4) {
                case 8: {
                    switch (code) {
                        case 128: 
                        case 129: 
                        case 130: {
                            long length = this.readLength();
                            BinaryWire.this.bytes.readSkip(length);
                            return;
                        }
                        case 136: 
                        case 137: {
                            BinaryWire.this.valueIn.object();
                            return;
                        }
                        case 135: {
                            BinaryWire.this.bytes.readSkip(1L);
                            BinaryWire.this.readFieldAnchor(BinaryWire.this.acquireStringBuilder());
                            return;
                        }
                    }
                    Jvm.warn().on(this.getClass(), "reading control code as text");
                    break;
                }
                case 11: {
                    switch (code) {
                        case 176: 
                        case 177: 
                        case 187: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return;
                        }
                        case 184: {
                            this.text();
                            return;
                        }
                        case 182: {
                            Class clazz2;
                            BinaryWire.this.readCode();
                            StringBuilder sb = BinaryWire.this.readUtf8();
                            try {
                                clazz2 = BinaryWire.this.classLookup().forName((CharSequence)sb);
                            }
                            catch (ClassNotFoundException e) {
                                throw new IORuntimeException((Throwable)e);
                            }
                            this.object(null, clazz2);
                            return;
                        }
                    }
                    break;
                }
                case 9: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    BinaryWire.this.readFloat0bject(code);
                    return;
                }
                case 10: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    BinaryWire.this.readInt0object(code);
                    return;
                }
            }
            this.text();
        }
    }

    protected class BinaryValueOut
    extends FixedBinaryValueOut {
        protected BinaryValueOut() {
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.writeNumber(i8);
            return BinaryWire.this;
        }

        void writeNumber(long l) {
            switch (Long.numberOfLeadingZeros(l)) {
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    BinaryWire.this.bytes.writeUnsignedByte((int)l);
                    return;
                }
                case 56: {
                    super.uint8checked((short)l);
                    return;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    super.fixedInt16((short)l);
                    return;
                }
                case 48: {
                    super.uint16checked((int)l);
                    return;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    super.fixedInt32((int)l);
                    return;
                }
                case 32: {
                    super.uint32checked(l);
                    return;
                }
                case 0: {
                    if (l >= -128L) {
                        super.int8((byte)l);
                        return;
                    }
                    if (l >= -32768L) {
                        super.int16((short)l);
                        return;
                    }
                    if (l < Integer.MIN_VALUE) break;
                    super.int32((int)l);
                    return;
                }
            }
            if ((long)((float)l) == l) {
                super.float32(l);
                return;
            }
            super.int64(l);
        }

        void writeNumber(double l) {
            boolean canOnlyBeRepresentedAsFloatingPoint;
            boolean bl = canOnlyBeRepresentedAsFloatingPoint = (double)((long)l) != l;
            if (l >= 0.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0.0) {
                if (l <= 255.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint16checked((int)l);
                    return;
                }
                if ((double)((float)l) == l) {
                    super.float32((float)l);
                    return;
                }
                if (l <= 4.294967295E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint32checked((int)l);
                    return;
                }
                super.float64(l);
                return;
            }
            if (l >= -128.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768.0 && l <= 32767.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int16((short)l);
                return;
            }
            if ((double)((float)l) == l) {
                super.float32((float)l);
                return;
            }
            if (l >= -2.147483648E9 && l <= 2.147483647E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int32((int)l);
                return;
            }
            super.float64(l);
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.writeNumber(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.writeNumber(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.writeNumber(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.writeNumber(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.writeNumber(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.writeNumber(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.writeNumber(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.writeNumber(d);
            return BinaryWire.this;
        }
    }

    protected class FixedBinaryValueOut
    implements ValueOut {
        protected FixedBinaryValueOut() {
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            BinaryWire.this.bytes.writeUnsignedByte(flag == null ? 187 : (flag != false ? 177 : 176));
            return BinaryWire.this;
        }

        @Override
        public WireOut nu11() {
            BinaryWire.this.writeCode(187);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s == null) {
                this.nu11();
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8(s);
                } else {
                    BinaryWire.this.writeCode(184);
                    BinaryWire.this.bytes.writeUtf8(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable String s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    len = (int)AppendableUtil.findUtf8Length((CharSequence)s);
                }
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8(StringUtils.extractChars((String)s), 0, s.length());
                } else {
                    BinaryWire.this.writeCode(184);
                    BinaryWire.this.bytes.writeUtf8(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable BytesStore s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8((CharSequence)s);
                } else {
                    BinaryWire.this.writeCode(184).writeUtf8((CharSequence)s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return this.nu11();
            }
            long remaining = fromBytes.readRemaining();
            if (remaining >= (long)this.compressedSize()) {
                this.compress(BinaryWire.this.compression, fromBytes.bytesForRead());
            } else {
                this.bytes0(fromBytes, remaining);
            }
            return BinaryWire.this;
        }

        @Override
        public WireOut bytesLiteral(@Nullable BytesStore fromBytes) {
            long remaining = fromBytes.readRemaining();
            this.writeLength(Maths.toInt32((long)remaining));
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        public int compressedSize() {
            return BinaryWire.this.compressedSize;
        }

        public void bytes0(@Nullable BytesStore fromBytes, long remaining) {
            this.writeLength(Maths.toInt32((long)(remaining + 1L)));
            BinaryWire.this.writeCode(138);
            if (remaining > 0L) {
                BinaryWire.this.bytes.write(fromBytes);
            }
        }

        @Override
        @NotNull
        public WireOut rawBytes(byte[] value) {
            this.typePrefix(byte[].class);
            this.writeLength(Maths.toInt32((long)(value.length + 1)));
            BinaryWire.this.writeCode(138);
            if (value.length > 0) {
                BinaryWire.this.bytes.write(value);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Invalid length " + length);
            }
            if (length < 256L) {
                BinaryWire.this.writeCode(128);
                BinaryWire.this.bytes.writeUnsignedByte((int)length);
            } else if (length < 65536L) {
                BinaryWire.this.writeCode(129);
                BinaryWire.this.bytes.writeUnsignedShort((int)length);
            } else {
                BinaryWire.this.writeCode(130);
                BinaryWire.this.bytes.writeUnsignedInt(length);
            }
            return this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull byte[] fromBytes) {
            this.writeLength(Maths.toInt32((long)(fromBytes.length + 1)));
            BinaryWire.this.writeCode(138);
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @Nullable BytesStore fromBytes) {
            this.typePrefix(type);
            if (fromBytes != null) {
                this.bytes0(fromBytes, fromBytes.readRemaining());
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, byte[] fromBytes) {
            this.typePrefix(type);
            return this.bytes(fromBytes);
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            return this.fixedInt8(i8);
        }

        @Override
        @NotNull
        public WireOut fixedInt8(byte i8) {
            BinaryWire.this.writeCode(164).writeByte(i8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            BinaryWire.this.writeCode(161).writeUnsignedByte(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            return this.fixedInt16(i16);
        }

        @Override
        @NotNull
        public WireOut fixedInt16(short i16) {
            BinaryWire.this.writeCode(165).writeShort(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            BinaryWire.this.writeCode(162).writeUnsignedShort(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            BinaryWire.this.writeCode(162);
            BinaryWire.this.bytes.appendUtf8(codepoint);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            return this.fixedInt32(i32);
        }

        @Override
        @NotNull
        public WireOut fixedInt32(int i32) {
            BinaryWire.this.writeCode(166).writeInt(i32);
            return BinaryWire.this;
        }

        @NotNull
        public WireOut fixedOrderedInt32(int i32) {
            BinaryWire.this.writeCode(166).writeOrderedInt(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            BinaryWire.this.writeCode(163).writeUnsignedInt(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            return this.fixedInt64(i64);
        }

        @Override
        @NotNull
        public WireOut fixedInt64(long i64) {
            BinaryWire.this.writeCode(167).writeLong(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64_0x(long i64) {
            BinaryWire.this.writeCode(175).writeLong(i64);
            return BinaryWire.this;
        }

        @NotNull
        private WireOut fixedOrderedInt64(long i64) {
            BinaryWire.this.writeAlignTo(8, 1);
            BinaryWire.this.writeCode(167).writeOrderedLong(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            BinaryWire.this.writeAlignTo(8, 1);
            BinaryWire.this.writeCode(141);
            BinaryLongArrayReference.lazyWrite((Bytes)BinaryWire.this.bytes, (long)capacity);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            BinaryWire.this.writeAlignTo(8, 1);
            BinaryWire.this.writeCode(141);
            long pos = BinaryWire.this.bytes.writePosition();
            BinaryLongArrayReference.lazyWrite((Bytes)BinaryWire.this.bytes, (long)capacity);
            ((Byteable)values).bytesStore((BytesStore)BinaryWire.this.bytes, pos, BinaryWire.this.bytes.writePosition() - pos);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            return this.fixedFloat32(f);
        }

        @Override
        @NotNull
        public WireOut fixedFloat32(float f) {
            BinaryWire.this.writeCode(144).writeFloat(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            return this.fixedFloat64(d);
        }

        @Override
        @NotNull
        public WireOut fixedFloat64(double d) {
            BinaryWire.this.writeCode(145).writeDouble(d);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            BinaryWire.this.writeCode(178).writeUtf8(localTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            BinaryWire.this.writeCode(181).writeUtf8(zonedDateTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            BinaryWire.this.writeCode(179).writeUtf8(localDate.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut dateTime(@NotNull LocalDateTime localDateTime) {
            BinaryWire.this.writeCode(180).writeUtf8(localDateTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(CharSequence typeName) {
            BinaryWire.this.writeCode(182).writeUtf8(typeName);
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            BinaryWire.this.writeCode(188).writeUtf8(type);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(Class type) {
            if (type == null) {
                this.nu11();
            } else {
                BinaryWire.this.writeCode(188).writeUtf8(BinaryWire.this.classLookup().nameFor(type));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            BinaryWire.this.writeCode(188);
            typeTranslator.accept(type, BinaryWire.this.bytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            BinaryWire.this.writeCode(160).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.readPosition() - 1L & 0x3FL);
            if (fromEndOfCacheLine < 4) {
                BinaryWire.this.addPadding(fromEndOfCacheLine - 1);
            }
            this.fixedInt32(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.readPosition() - 1L & 0x3FL);
            if (fromEndOfCacheLine < 8) {
                BinaryWire.this.addPadding(fromEndOfCacheLine);
            }
            this.fixedOrderedInt64(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            this.int32forBinding(value);
            ((BinaryIntReference)intValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 4L, 4L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            this.int64forBinding(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 8L, 8L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, BiConsumer<T, ValueOut> writer) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            writer.accept(t, this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T, K> WireOut sequence(T t, K kls, TriConsumer<T, K, ValueOut> writer) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            writer.accept(t, kls, this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            object.writeMarshallable(BinaryWire.this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(BinaryWire.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, BinaryWire.this);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(Map map) {
            return this.marshallable(map);
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return BinaryWire.this;
        }

        @Override
        public void resetState() {
        }
    }

    static enum AnyCodeMatch implements WireKey
    {
        ANY_CODE_MATCH;


        @Override
        public int code() {
            return Integer.MIN_VALUE;
        }
    }
}

