/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.LicenceCheck;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractAnyWire;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.CSVWire;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.ReadAnyWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WireType implements Function<Bytes, Wire>,
LicenceCheck
{
    TEXT{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new TextWire(bytes);
        }

        @Override
        public Supplier<LongValue> newLongReference() {
            return TextLongReference::new;
        }

        @Override
        public Supplier<LongArrayValues> newLongArrayReference() {
            return TextLongArrayReference::new;
        }
    }
    ,
    BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes);
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    BINARY_LIGHT{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return BinaryWire.binaryOnly(bytes);
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    DEFAULT_ZERO_BINARY{
        private Boolean isAvailable;

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            try {
                return (Wire)Class.forName("software.chronicle.wire.DefaultZeroWire").getDeclaredConstructor(Bytes.class).newInstance(bytes);
            }
            catch (Exception e) {
                IllegalStateException licence = new IllegalStateException("A Chronicle Wire Enterprise licence is required to run this code because you are using DefaultZeroWire which is a licence product. Please contact sales@chronicle.software");
                Jvm.warn().on(this.getClass(), (Throwable)licence);
                throw licence;
            }
        }

        public void licenceCheck() {
            if (this.isAvailable()) {
                return;
            }
            IllegalStateException licence = new IllegalStateException("A Chronicle Wire Enterprise licence is required to run this code because you are using DEFAULT_ZERO_BINARY which is a licence product. Please contact sales@chronicle.software");
            Jvm.warn().on(this.getClass(), (Throwable)licence);
            throw licence;
        }

        public boolean isAvailable() {
            if (this.isAvailable != null) {
                return this.isAvailable;
            }
            try {
                Class<?> e = Class.forName("software.chronicle.wire.DefaultZeroWire");
                e.getDeclaredConstructor(Bytes.class);
                this.isAvailable = true;
                return true;
            }
            catch (Exception var4) {
                this.isAvailable = false;
                return false;
            }
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    DELTA_BINARY{
        private final boolean isAvailable = this.isAvailable0();

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            try {
                Class<?> aClass = Class.forName("software.chronicle.wire.DeltaWire");
                Constructor<?> declaredConstructor = aClass.getDeclaredConstructor(Bytes.class);
                return (Wire)declaredConstructor.newInstance(bytes);
            }
            catch (Exception e) {
                this.licenceCheck();
                throw new AssertionError((Object)e);
            }
        }

        public void licenceCheck() {
            if (this.isAvailable()) {
                return;
            }
            IllegalStateException licence = new IllegalStateException("A Chronicle Wire Enterprise licence is required to run this code because you are using DELTA_BINARY which is a licence product. Please contact sales@chronicle.software");
            LOG.error("", (Throwable)licence);
            throw licence;
        }

        private boolean isAvailable0() {
            try {
                Class.forName("software.chronicle.wire.DeltaWire").getDeclaredConstructor(Bytes.class);
                return true;
            }
            catch (Exception fallback) {
                return false;
            }
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, true, Integer.MAX_VALUE, "binary", false);
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    COMPRESSED_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, false, COMPRESSED_SIZE, "lzw", true);
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    JSON{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new JSONWire(bytes);
        }
    }
    ,
    RAW{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new RawWire(bytes);
        }

        @Override
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    CSV{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new CSVWire(bytes);
        }
    }
    ,
    READ_ANY{

        @Override
        public Wire apply(@NotNull Bytes bytes) {
            return new ReadAnyWire(bytes);
        }
    };

    static final ThreadLocal<Bytes> bytesTL;
    static final ThreadLocal<Bytes> bytes2TL;
    private static final Logger LOG;
    private static final int COMPRESSED_SIZE;

    static Bytes getBytes() {
        if (Jvm.isDebug()) {
            return Bytes.allocateElasticDirect();
        }
        Bytes bytes = bytesTL.get();
        bytes.clear();
        return bytes;
    }

    static Bytes getBytes2() {
        if (Jvm.isDebug()) {
            return Bytes.allocateElasticDirect();
        }
        Bytes bytes = bytes2TL.get();
        bytes.clear();
        return bytes;
    }

    public static WireType valueOf(Wire wire) {
        if (wire instanceof AbstractAnyWire) {
            wire = ((AbstractAnyWire)wire).underlyingWire();
        }
        if (wire instanceof JSONWire) {
            return JSON;
        }
        if (wire instanceof TextWire) {
            return TEXT;
        }
        if ("DeltaWire".equals(wire.getClass().getSimpleName())) {
            return DELTA_BINARY;
        }
        if ("DefaultZeroWire".equals(wire.getClass().getSimpleName())) {
            return DEFAULT_ZERO_BINARY;
        }
        if (wire instanceof BinaryWire) {
            BinaryWire binaryWire = (BinaryWire)wire;
            return binaryWire.fieldLess() ? FIELDLESS_BINARY : BINARY;
        }
        if (wire instanceof RawWire) {
            return RAW;
        }
        throw new IllegalStateException("unknown type");
    }

    public Supplier<IntValue> newIntReference() {
        return BinaryIntReference::new;
    }

    public Supplier<LongValue> newLongReference() {
        return BinaryLongReference::new;
    }

    public Supplier<LongArrayValues> newLongArrayReference() {
        return BinaryLongArrayReference::new;
    }

    public String asString(Object marshallable) {
        Bytes bytes = this.asBytes(marshallable);
        return bytes.toString();
    }

    private Bytes asBytes(Object marshallable) {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        ValueOut valueOut = wire.getValueOut();
        if (marshallable instanceof WriteMarshallable) {
            valueOut.typedMarshallable((WriteMarshallable)marshallable);
        } else if (marshallable instanceof Map) {
            wire.getValueOut().marshallable((Map)marshallable, Object.class, Object.class, false);
        } else if (marshallable instanceof Iterable) {
            wire.getValueOut().sequence((Iterable)marshallable);
        } else if (marshallable instanceof Serializable) {
            valueOut.typedMarshallable((Serializable)marshallable);
        } else {
            bytes.appendUtf8((CharSequence)marshallable.toString());
        }
        return bytes;
    }

    public <T> T fromString(CharSequence cs) {
        Bytes bytes = WireType.getBytes2();
        bytes.appendUtf8(cs);
        Wire wire = (Wire)this.apply(bytes);
        return (T)wire.getValueIn().object();
    }

    public <T> T fromFile(String filename) throws IOException {
        return ((Wire)this.apply(Bytes.wrapForRead((byte[])IOTools.readFile((String)filename)))).getValueIn().typedMarshallable();
    }

    public <T> Map<String, T> fromFileAsMap(String filename, Class<T> tClass) throws IOException {
        LinkedHashMap map = new LinkedHashMap();
        Wire wire = (Wire)this.apply(Bytes.wrapForRead((byte[])IOTools.readFile((String)filename)));
        StringBuilder sb = new StringBuilder();
        while (wire.hasMore()) {
            wire.readEventName(sb).object(tClass, map, (m, o) -> m.put(sb.toString(), o));
        }
        return map;
    }

    public <T extends Marshallable> void toFileAsMap(String filename, Map<String, T> map) throws IOException {
        this.toFileAsMap(filename, map, false);
    }

    public <T extends Marshallable> void toFileAsMap(String filename, Map<String, T> map, boolean compact) throws IOException {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            ValueOut valueOut = wire.writeEventName(entry::getKey);
            valueOut.leaf(compact).marshallable((WriteMarshallable)entry.getValue());
        }
        String tempFilename = IOTools.tempName((String)filename);
        IOTools.writeFile((String)tempFilename, (byte[])bytes.toByteArray());
        File file2 = new File(tempFilename);
        File dest = new File(filename);
        if (!file2.renameTo(dest)) {
            if (dest.delete() && file2.renameTo(dest)) {
                return;
            }
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    public <T> void toFile(String filename, WriteMarshallable marshallable) throws IOException {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        wire.getValueOut().typedMarshallable(marshallable);
        String tempFilename = IOTools.tempName((String)filename);
        IOTools.writeFile((String)tempFilename, (byte[])bytes.toByteArray());
        File file2 = new File(tempFilename);
        if (!file2.renameTo(new File(filename))) {
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    String asHexString(Object marshallable) {
        Bytes bytes = this.asBytes(marshallable);
        return bytes.toHexString();
    }

    <T> T fromHexString(CharSequence s) {
        Wire wire = (Wire)this.apply(Bytes.fromHexString((String)s.toString()));
        return wire.getValueIn().typedMarshallable();
    }

    public Map<String, Object> asMap(CharSequence cs) {
        Bytes bytes = WireType.getBytes2();
        bytes.appendUtf8(cs);
        Wire wire = (Wire)this.apply(bytes);
        return wire.getValueIn().marshallableAsMap(String.class, Object.class);
    }

    static {
        bytesTL = ThreadLocal.withInitial(Bytes::allocateElasticDirect);
        bytes2TL = ThreadLocal.withInitial(Bytes::allocateElasticDirect);
        LOG = LoggerFactory.getLogger(WireType.class);
        COMPRESSED_SIZE = Integer.getInteger("WireType.compressedSize", 128);
    }
}

