/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueOut {
    public static final int SMALL_MESSAGE = 64;

    @NotNull
    public WireOut bool(Boolean var1);

    @NotNull
    public WireOut text(@Nullable CharSequence var1);

    @NotNull
    default public WireOut text(@Nullable BytesStore s) {
        return this.text((CharSequence)s);
    }

    @NotNull
    default public WireOut int8(long x) {
        return this.int8(Maths.toInt8((long)x));
    }

    @NotNull
    public WireOut int8(byte var1);

    @NotNull
    public WireOut bytes(@Nullable BytesStore var1);

    @NotNull
    public WireOut bytes(String var1, @Nullable BytesStore var2);

    @NotNull
    public WireOut rawBytes(byte[] var1);

    @NotNull
    public ValueOut writeLength(long var1);

    @NotNull
    public WireOut bytes(byte[] var1);

    @NotNull
    public WireOut bytes(String var1, byte[] var2);

    @NotNull
    default public WireOut uint8(int x) {
        return this.uint8checked(Maths.toUInt8((long)x));
    }

    @NotNull
    public WireOut uint8checked(int var1);

    @NotNull
    default public WireOut int16(long x) {
        return this.int16(Maths.toInt16((long)x));
    }

    @NotNull
    public WireOut int16(short var1);

    @NotNull
    default public WireOut uint16(long x) {
        return this.uint16checked((int)x);
    }

    @NotNull
    public WireOut uint16checked(int var1);

    @NotNull
    public WireOut utf8(int var1);

    @NotNull
    default public WireOut int32(long x) {
        return this.int32(Maths.toInt32((long)x));
    }

    @NotNull
    public WireOut int32(int var1);

    @NotNull
    default public WireOut uint32(long x) {
        return this.uint32checked(x);
    }

    @NotNull
    public WireOut uint32checked(long var1);

    @NotNull
    public WireOut int64(long var1);

    @NotNull
    public WireOut int64_0x(long var1);

    @NotNull
    public WireOut int64array(long var1);

    @NotNull
    public WireOut int64array(long var1, LongArrayValues var3);

    @NotNull
    public WireOut float32(float var1);

    @NotNull
    public WireOut float64(double var1);

    @NotNull
    public WireOut time(LocalTime var1);

    @NotNull
    public WireOut zonedDateTime(ZonedDateTime var1);

    @NotNull
    public WireOut date(LocalDate var1);

    @NotNull
    public ValueOut typePrefix(CharSequence var1);

    @NotNull
    default public ValueOut typePrefix(Class type) {
        return this.typePrefix(ClassAliasPool.CLASS_ALIASES.nameFor(type));
    }

    @NotNull
    default public WireOut typeLiteral(Class type) {
        return type == null ? this.text((BytesStore)null) : this.typeLiteral((t, b) -> b.appendUtf8((CharSequence)ClassAliasPool.CLASS_ALIASES.nameFor(t)), type);
    }

    @NotNull
    public WireOut typeLiteral(@NotNull CharSequence var1);

    @NotNull
    public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> var1, @NotNull Class var2);

    @NotNull
    public WireOut uuid(UUID var1);

    @NotNull
    public WireOut int32forBinding(int var1);

    @NotNull
    public WireOut int32forBinding(int var1, IntValue var2);

    @NotNull
    public WireOut int64forBinding(long var1);

    @NotNull
    public WireOut int64forBinding(long var1, LongValue var3);

    @NotNull
    default public WireOut sequence(WriteValue writer) {
        return this.sequence(writer, WriteValue::writeValue);
    }

    @NotNull
    public <T> WireOut sequence(T var1, BiConsumer<T, ValueOut> var2);

    @NotNull
    default public WireOut array(WriteValue writer, Class arrayType) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public WireOut marshallable(WriteMarshallable var1);

    @NotNull
    public WireOut map(Map var1);

    @NotNull
    public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> var1);

    @NotNull
    public ValueOut leaf();

    default public ValueOut leaf(boolean leaf) {
        return leaf ? this.leaf() : this;
    }

    @NotNull
    default public WireOut typedMarshallable(@Nullable WriteMarshallable object) {
        if (object == null) {
            return this.text((BytesStore)null);
        }
        this.typePrefix(object.getClass());
        return this.marshallable(object);
    }

    @NotNull
    default public WireOut typedMarshallable(CharSequence typeName, WriteMarshallable object) {
        this.typePrefix(typeName);
        return this.marshallable(object);
    }

    default public <E extends Enum<E>> WireOut asEnum(E e) {
        return this.text(e == null ? null : e.name());
    }

    default public <V> WireOut set(Set<V> coll) {
        return this.set(coll, null);
    }

    default public <V> WireOut set(Set<V> coll, Class<V> assumedClass) {
        return this.collection(coll, assumedClass);
    }

    default public <V> WireOut list(List<V> coll) {
        return this.list(coll, null);
    }

    default public <V> WireOut list(List<V> coll, Class<V> assumedClass) {
        return this.collection(coll, assumedClass);
    }

    default public <V> WireOut collection(Collection<V> coll, Class<V> assumedClass) {
        this.sequence(coll, (s, out) -> {
            for (Object v : s) {
                out.leaf();
                this.object(assumedClass, v);
            }
        });
        return this.wireOut();
    }

    default public <V> void object(Class<V> assumedClass, V v) {
        if (v instanceof WriteMarshallable) {
            if (v.getClass() == assumedClass) {
                this.marshallable((WriteMarshallable)v);
            } else {
                this.typedMarshallable((WriteMarshallable)v);
            }
        } else if (v != null && v.getClass() == assumedClass) {
            this.untypedObject(v);
        } else {
            this.object(v);
        }
    }

    default public <V> WireOut marshallableAsMap(Map<String, V> map) {
        return this.marshallableAsMap(map, null);
    }

    default public <V> WireOut marshallableAsMap(Map<String, V> map, Class<V> vClass) {
        return this.marshallableAsMap(map, vClass, true);
    }

    default public <V> WireOut marshallableAsMap(Map<String, V> map, Class<V> vClass, boolean leaf) {
        this.marshallable(m -> {
            for (Map.Entry entry : map.entrySet()) {
                m.writeEventName(entry::getKey).leaf(leaf).object(vClass, entry.getValue());
            }
        });
        return this.wireOut();
    }

    @NotNull
    default public WireOut object(Object value) {
        if (value == null) {
            return this.text((BytesStore)null);
        }
        if (value instanceof Marshallable) {
            return this.typedMarshallable((Marshallable)value);
        }
        if (value instanceof BytesStore) {
            return this.bytes((BytesStore)value);
        }
        if (value instanceof CharSequence) {
            return this.text((CharSequence)value);
        }
        if (value instanceof Map) {
            return this.map((Map)value);
        }
        if (value instanceof byte[]) {
            return this.typePrefix(byte[].class).bytes((byte[])value);
        }
        if (value instanceof Byte) {
            return this.typePrefix(Byte.TYPE).int8((Byte)value);
        }
        if (value instanceof Boolean) {
            return this.bool((Boolean)value);
        }
        if (value instanceof Character) {
            return this.text(value.toString());
        }
        if (value instanceof Short) {
            return this.typePrefix(Short.TYPE).int16((Short)value);
        }
        if (value instanceof Integer) {
            return this.typePrefix(Integer.TYPE).int32((Integer)value);
        }
        if (value instanceof Long) {
            return this.int64((Long)value);
        }
        if (value instanceof Double) {
            return this.float64((Double)value);
        }
        if (value instanceof Float) {
            return this.typePrefix(Float.TYPE).float32(((Float)value).floatValue());
        }
        if (value instanceof Throwable) {
            return this.throwable((Throwable)value);
        }
        if (value instanceof Enum) {
            return this.typedScalar(value);
        }
        if (value instanceof String[]) {
            return this.array(v -> Stream.of((String[])value).forEach(v::text), String[].class);
        }
        if (value instanceof Collection) {
            if (((Collection)value).size() == 0) {
                return this.sequence(v -> {});
            }
            return this.sequence(v -> ((Collection)value).stream().forEach(v::object));
        }
        if (WireSerializedLambda.isSerializableLambda(value.getClass())) {
            WireSerializedLambda.write(value, this);
            return this.wireOut();
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            return this.array(v -> Stream.of((Object[])value).forEach(v::object), Object[].class);
        }
        if (value instanceof LocalTime) {
            return this.time((LocalTime)value);
        }
        if (value instanceof LocalDate) {
            return this.date((LocalDate)value);
        }
        if (value instanceof ZonedDateTime) {
            return this.zonedDateTime((ZonedDateTime)value);
        }
        throw new IllegalStateException("type=" + value.getClass() + " is unsupported, it must either be of type Marshallable, String or " + "AutoBoxed primitive Object");
    }

    @NotNull
    default public WireOut untypedObject(Object value) {
        if (value == null) {
            return this.text((BytesStore)null);
        }
        if (value instanceof Marshallable) {
            return this.marshallable((Marshallable)value);
        }
        if (value instanceof BytesStore) {
            return this.bytes((BytesStore)value);
        }
        if (value instanceof CharSequence) {
            return this.text((CharSequence)value);
        }
        if (value instanceof Map) {
            return this.map((Map)value);
        }
        if (value instanceof byte[]) {
            return this.bytes((byte[])value);
        }
        if (value instanceof Byte) {
            return this.int8((Byte)value);
        }
        if (value instanceof Boolean) {
            return this.bool((Boolean)value);
        }
        if (value instanceof Character) {
            return this.text(value.toString());
        }
        if (value instanceof Short) {
            return this.int16((Short)value);
        }
        if (value instanceof Integer) {
            return this.int32((Integer)value);
        }
        if (value instanceof Long) {
            return this.int64((Long)value);
        }
        if (value instanceof Double) {
            return this.float64((Double)value);
        }
        if (value instanceof Float) {
            return this.float32(((Float)value).floatValue());
        }
        if (value instanceof Throwable) {
            return this.throwable((Throwable)value);
        }
        if (value instanceof Enum) {
            return this.text(value.toString());
        }
        if (value instanceof String[]) {
            return this.array(v -> Stream.of((String[])value).forEach(v::text), String[].class);
        }
        if (value instanceof Collection) {
            if (((Collection)value).size() == 0) {
                return this.sequence(v -> {});
            }
            return this.sequence(v -> ((Collection)value).stream().forEach(v::object));
        }
        if (WireSerializedLambda.isSerializableLambda(value.getClass())) {
            WireSerializedLambda.write(value, this);
            return this.wireOut();
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            return this.array(v -> Stream.of((Object[])value).forEach(v::object), Object[].class);
        }
        if (value instanceof LocalTime) {
            return this.time((LocalTime)value);
        }
        if (value instanceof LocalDate) {
            return this.date((LocalDate)value);
        }
        if (value instanceof ZonedDateTime) {
            return this.zonedDateTime((ZonedDateTime)value);
        }
        throw new IllegalStateException("type=" + value.getClass() + " is unsupported, it must either be of type Marshallable, String or " + "AutoBoxed primitive Object");
    }

    @NotNull
    default public WireOut typedScalar(@NotNull Object value) {
        this.typePrefix(ClassAliasPool.CLASS_ALIASES.nameFor(value.getClass()));
        if (!(value instanceof CharSequence)) {
            value = value.toString();
        }
        this.text((CharSequence)value);
        return this.wireOut();
    }

    @NotNull
    default public WireOut throwable(@NotNull Throwable t) {
        this.typedMarshallable(t.getClass().getName(), w -> w.write(() -> "message").text(t.getMessage()).write(() -> "stackTrace").sequence(w3 -> {
            StackTraceElement[] stes = t.getStackTrace();
            int last = Jvm.trimLast((int)0, (StackTraceElement[])stes);
            for (int i = 0; i < last; ++i) {
                StackTraceElement ste = stes[i];
                w3.leaf().marshallable(w4 -> w4.write(() -> "class").text(ste.getClassName()).write(() -> "method").text(ste.getMethodName()).write(() -> "file").text(ste.getFileName()).write(() -> "line").int32(ste.getLineNumber()));
            }
        }));
        return this.wireOut();
    }

    @NotNull
    public WireOut wireOut();

    default public WireOut compress(String compression, Bytes uncompressedBytes) {
        if (uncompressedBytes == null) {
            return this.text((BytesStore)null);
        }
        if (uncompressedBytes.readRemaining() < 64L) {
            return this.bytes((BytesStore)uncompressedBytes);
        }
        Bytes tmpBytes = Wires.acquireBytes();
        Compression.compress((CharSequence)compression, (Bytes)uncompressedBytes, (Bytes)tmpBytes);
        this.bytes(compression, (BytesStore)tmpBytes);
        return this.wireOut();
    }

    default public int compressedSize() {
        return Integer.MAX_VALUE;
    }

    @Deprecated
    default public WireOut compress(String compression, String str) {
        if (str == null || str.length() < 64) {
            return this.text(str);
        }
        WireInternal.compress(this, compression, str);
        return this.wireOut();
    }
}

