/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public enum Wires {

    public static final int LENGTH_MASK = 0x3FFFFFFF;
    public static final int NOT_READY = Integer.MIN_VALUE;
    public static final int META_DATA = 0x40000000;
    public static final int UNKNOWN_LENGTH = 0;
    public static final int MAX_LENGTH = 0x3FFFFFFF;
    public static final int NOT_READY_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    public static final int END_OF_DATA = -1073741824;
    public static final int NOT_INITIALIZED = 0;
    public static final Bytes<?> NO_BYTES = new VanillaBytes(Bytes.empty());
    public static final WireIn EMPTY = new BinaryWire(NO_BYTES);
    public static final int SPB_HEADER_SIZE = 4;
    static final StringBuilderPool SBP = new StringBuilderPool();

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes) {
        long position = bytes.readPosition();
        return WireInternal.fromSizePrefixedBlobs(bytes, position, bytes.readRemaining());
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position) {
        long limit = bytes.readLimit();
        if (position > limit) {
            return "";
        }
        return WireInternal.fromSizePrefixedBlobs(bytes, position, limit - position);
    }

    public static String fromSizePrefixedBlobs(@NotNull Wire wire) {
        Bytes<?> bytes = wire.bytes();
        long position = bytes.readPosition();
        return WireInternal.fromSizePrefixedBlobs(bytes, position, bytes.readRemaining());
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static int lengthOf(long len) {
        return (int)(len & 0x3FFFFFFFL);
    }

    public static boolean isReady(long len) {
        return (len & Integer.MIN_VALUE) == 0L;
    }

    public static boolean isNotReady(long len) {
        return (len & Integer.MIN_VALUE) != 0L;
    }

    public static boolean isReadyData(long len) {
        return (len & 0xFFFFFFFFC0000000L) == 0L;
    }

    public static boolean isData(long len) {
        return (len & 0x40000000L) == 0L;
    }

    public static boolean isReadyMetaData(long len) {
        return (len & 0xFFFFFFFFC0000000L) == 0x40000000L;
    }

    public static boolean isKnownLength(int len) {
        return (len & Integer.MAX_VALUE) != 0;
    }

    public static boolean isNotInitialized(int len) {
        return len == 0;
    }

    public static int toIntU30(long l, @NotNull String error) {
        if (l < 0L || l > 0x3FFFFFFFL) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    public static boolean acquireLock(BytesStore store, long position) {
        return store.compareAndSwapInt(position, 0, Integer.MIN_VALUE);
    }

    public static boolean exceedsMaxLength(long length) {
        return length > 0x3FFFFFFFL;
    }

    @ForceInline
    public static <T extends ReadMarshallable> long readData(@NotNull WireIn wireIn, @NotNull T reader) {
        return Wires.readWire(wireIn, reader);
    }

    @ForceInline
    public static <T extends WriteMarshallable> long writeData(@NotNull WireOut wireOut, @NotNull T writer) {
        return WireInternal.writeData(wireOut, false, false, writer);
    }

    @ForceInline
    public static <T extends WriteMarshallable> long writeMeta(@NotNull WireOut wireOut, @NotNull T writer) {
        return WireInternal.writeData(wireOut, true, false, writer);
    }

    @ForceInline
    public static <T extends ReadMarshallable> long readMeta(@NotNull WireIn wireIn, @NotNull T reader) {
        return Wires.readWire(wireIn, reader);
    }

    @ForceInline
    public static long readWire(@NotNull WireIn wireIn, @NotNull ReadMarshallable readMarshallable) {
        Bytes<?> bytes = wireIn.bytes();
        int header = bytes.readVolatileInt(bytes.readPosition());
        int len = Wires.lengthOf(header);
        bytes.readSkip(4L);
        return Wires.readWire(wireIn, len, readMarshallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static long readWire(@NotNull WireIn wireIn, long size, @NotNull ReadMarshallable readMarshallable) {
        Bytes<?> bytes = wireIn.bytes();
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + size;
        try {
            bytes.readLimit(limit);
            readMarshallable.readMarshallable(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
            bytes.readPosition(limit);
        }
        return bytes.readPosition();
    }

    public static Bytes acquireBytes() {
        Bytes bytes = WireInternal.BYTES_TL.get();
        bytes.clear();
        return bytes;
    }

    public static Bytes acquireAnotherBytes() {
        Bytes bytes = WireInternal.ABYTES_TL.get();
        bytes.clear();
        return bytes;
    }

    public static String fromSizePrefixedBlobs(Bytes<?> bytes, long position, long length) {
        return WireInternal.fromSizePrefixedBlobs(bytes, position, length);
    }

    public static void readMarshallable(Object marshallable, WireIn wire) {
        ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass())).readMarshallable(marshallable, wire);
    }

    public static void writeMarshallable(Object marshallable, WireOut wire) {
        ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass())).writeMarshallable(marshallable, wire);
    }
}

