/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.cfg.ApplicationCfg;
import net.openhft.chronicle.wire.cfg.MapInstallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    static <I extends MapInstallable> void addClass(Class<I> ... iClasses) {
        ClassAliasPool.CLASS_ALIASES.addAlias((Class[])iClasses);
    }

    public static void main(String[] args) throws IOException {
        Main.addClass(ApplicationCfg.class);
        String name = args.length > 0 ? args[0] : "engine.yaml";
        TextWire yaml = TextWire.fromFile(name);
        MapInstallable installable = (MapInstallable)yaml.readObject();
        Map<String, Object> root = Collections.synchronizedMap(new LinkedHashMap());
        try {
            installable.install("/", root);
            LOGGER.info("Engine started");
        }
        catch (Exception e) {
            LOGGER.error("Error starting a component, stopping", (Throwable)e);
            Main.close(root);
        }
    }

    private static void close(Object o) {
        if (o instanceof Closeable) {
            Closeable.closeQuietly((Object)o);
        } else if (o instanceof Map) {
            for (Object o2 : ((Map)o).values()) {
                Main.close(o2);
            }
        }
    }
}

