/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import org.jetbrains.annotations.NotNull;

public interface WireParser {
    @NotNull
    public static WireParser wireParser(BiConsumer<CharSequence, ValueIn> defaultConsumer) {
        return new VanillaWireParser(defaultConsumer);
    }

    public BiConsumer<CharSequence, ValueIn> getDefaultConsumer();

    default public void parse(@NotNull WireIn wireIn) {
        StringBuilder sb = WireInternal.SBP.acquireStringBuilder();
        ValueIn valueIn = wireIn.readEventName(sb);
        Consumer<ValueIn> consumer = this.lookup(sb);
        if (consumer == null) {
            this.getDefaultConsumer().accept(sb, valueIn);
        } else {
            consumer.accept(valueIn);
        }
    }

    public Consumer<ValueIn> lookup(CharSequence var1);

    public void register(WireKey var1, Consumer<ValueIn> var2);

    public Consumer<ValueIn> lookup(int var1);
}

