/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Base64;
import java.util.Map;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryWire
extends TextWire {
    final QueryValueOut valueOut = new QueryValueOut();
    final ValueIn valueIn = new QueryValueIn();

    public QueryWire(Bytes bytes) {
        super(bytes);
    }

    @Override
    @NotNull
    protected QueryValueOut createValueOut() {
        return new QueryValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new QueryValueIn();
    }

    @Override
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumeWhiteSpace();
        this.bytes.parseUtf8((Appendable)sb, (StopCharTester)QueryStopCharTesters.QUERY_FIELD_NAME);
        if (this.rewindAndRead() == 38) {
            this.bytes.readSkip(-1L);
        }
        return sb;
    }

    @Override
    @ForceInline
    protected void consumeWhiteSpace() {
        int codePoint = this.peekCode();
        while (Character.isWhitespace(codePoint)) {
            this.bytes.readSkip(1L);
            codePoint = this.peekCode();
        }
    }

    @Override
    @NotNull
    public ValueOut write() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        return this;
    }

    int rewindAndRead() {
        return this.bytes.readUnsignedByte(this.bytes.readPosition() - 1L);
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        throw new UnsupportedOperationException();
    }

    class QueryValueIn
    extends TextWire.TextValueIn {
        QueryValueIn() {
            super(QueryWire.this);
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.textTo(WireInternal.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder a) {
            QueryWire.this.consumeWhiteSpace();
            QueryWire.this.bytes.parseUtf8((Appendable)a, (StopCharTester)QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes a) {
            QueryWire.this.consumeWhiteSpace();
            QueryWire.this.bytes.parseUtf8((Appendable)a, (StopCharTester)QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            this.textTo(sb);
            classNameConsumer.accept(t, sb);
            return this.wireIn();
        }

        @Override
        public <T> Class<T> typeLiteral() {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            this.textTo(sb);
            try {
                return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        public boolean hasNextSequenceItem() {
            QueryWire.this.consumeWhiteSpace();
            int ch = QueryWire.this.peekCode();
            if (ch == 44) {
                QueryWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch != 93;
        }
    }

    class QueryValueOut
    extends TextWire.TextValueOut {
        @NotNull
        String sep;
        @Nullable
        CharSequence fieldName;

        QueryValueOut() {
            super(QueryWire.this);
            this.sep = "";
            this.fieldName = null;
        }

        @Override
        void prependSeparator() {
            QueryWire.this.bytes.appendUtf8((CharSequence)this.sep);
            this.sep = "";
            if (this.fieldName != null) {
                ((Bytes)QueryWire.this.bytes.appendUtf8(this.fieldName)).appendUtf8(61);
                this.fieldName = null;
            }
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        public void elementSeparator() {
            this.sep = "&";
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (flag != null) {
                this.prependSeparator();
                QueryWire.this.bytes.appendUtf8((CharSequence)(flag != false ? "true" : "false"));
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s != null) {
                this.prependSeparator();
                QueryWire.this.bytes.appendUtf8(s);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((int)i8);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut rawBytes(@Nullable byte[] value) {
            if (value != null) {
                this.prependSeparator();
                QueryWire.this.bytes.write(value);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        private boolean isText(@NotNull Bytes fromBytes) {
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch != 38 && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)Base64.getEncoder().encodeToString(byteArray));
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, LongArrayValues values) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(typeName);
            this.sep = " ";
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, IntValue intValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, LongValue longValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, BiConsumer<T, ValueOut> writer) {
            this.prependSeparator();
            this.pushState();
            QueryWire.this.bytes.appendUtf8((CharSequence)"[");
            this.sep = ",";
            long pos = QueryWire.this.bytes.writePosition();
            writer.accept(t, this);
            if (pos != QueryWire.this.bytes.writePosition()) {
                QueryWire.this.bytes.appendUtf8((CharSequence)",");
            }
            this.popState();
            QueryWire.this.bytes.appendUtf8((CharSequence)"]");
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        protected void popState() {
        }

        @Override
        protected void pushState() {
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            this.pushState();
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)"{");
            this.sep = ",";
            object.writeMarshallable(QueryWire.this);
            this.popState();
            QueryWire.this.bytes.appendUtf8(125);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ValueOut write() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            this.fieldName = key.name();
            return this;
        }
    }

    static enum QueryStopCharTesters implements StopCharTester
    {
        QUERY_FIELD_NAME{

            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch == 61 || ch < 0;
            }
        }
        ,
        QUERY_VALUE{

            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch < 0;
            }
        };

    }
}

