/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class BinaryMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    @NotNull
    private final Supplier<MarshallableOut> marshallableOutSupplier;
    private final boolean metaData;

    BinaryMethodWriterInvocationHandler(boolean metaData, @NotNull MarshallableOut marshallableOut) {
        this(metaData, () -> marshallableOut);
    }

    public BinaryMethodWriterInvocationHandler(boolean metaData, Supplier<MarshallableOut> marshallableOutSupplier) {
        this.marshallableOutSupplier = marshallableOutSupplier;
        this.metaData = metaData;
        this.recordHistory = marshallableOutSupplier.get().recordHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleInvoke(Method method, Object[] args) {
        MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
        try (DocumentContext context = marshallableOut.writingDocument(this.metaData);){
            Wire wire = context.wire();
            this.handleInvoke(method, args, wire);
            wire.padToCacheAlign();
        }
    }
}

