/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public enum BinaryWireCode {

    public static final int BYTES_LENGTH8 = 128;
    public static final int BYTES_LENGTH16 = 129;
    public static final int BYTES_LENGTH32 = 130;
    public static final int FIELD_ANCHOR = 135;
    public static final int ANCHOR = 136;
    public static final int UPDATED_ALIAS = 137;
    public static final int U8_ARRAY = 138;
    public static final int I64_ARRAY = 141;
    public static final int PADDING32 = 142;
    public static final int PADDING = 143;
    public static final int FLOAT32 = 144;
    public static final int FLOAT64 = 145;
    public static final int FLOAT_STOP_2 = 146;
    public static final int FLOAT_STOP_4 = 148;
    public static final int FLOAT_STOP_6 = 150;
    public static final int FLOAT_SET_LOW_0 = 154;
    public static final int FLOAT_SET_LOW_2 = 155;
    public static final int FLOAT_SET_LOW_4 = 156;
    public static final int UUID = 160;
    public static final int UINT8 = 161;
    public static final int UINT16 = 162;
    public static final int UINT32 = 163;
    public static final int INT8 = 164;
    public static final int INT16 = 165;
    public static final int INT32 = 166;
    public static final int INT64 = 167;
    public static final int SET_LOW_INT8 = 168;
    public static final int SET_LOW_INT16 = 169;
    public static final int INT64_0x = 175;
    public static final int FALSE = 176;
    public static final int TRUE = 177;
    public static final int TIME = 178;
    public static final int DATE = 179;
    public static final int DATE_TIME = 180;
    public static final int ZONED_DATE_TIME = 181;
    public static final int TYPE_PREFIX = 182;
    public static final int FIELD_NAME_ANY = 183;
    public static final int STRING_ANY = 184;
    public static final int EVENT_NAME = 185;
    public static final int FIELD_NUMBER = 186;
    public static final int NULL = 187;
    public static final int TYPE_LITERAL = 188;
    public static final int EVENT_OBJECT = 189;
    public static final int COMMENT = 190;
    public static final int HINT = 191;
    public static final int FIELD_NAME0 = 192;
    public static final int FIELD_NAME31 = 223;
    public static final int STRING_0 = 224;
    public static final int STRING_31 = 255;
    public static final String[] STRING_FOR_CODE = new String[256];

    public static boolean isFieldCode(int code) {
        return code == 183 || code == 186 || code >= 192 && code <= 223;
    }

    @NotNull
    public static String stringForCode(int code) {
        return code == -1 ? "EndOfFile" : STRING_FOR_CODE[code];
    }

    static {
        try {
            int i;
            for (Field field : BinaryWireCode.class.getDeclaredFields()) {
                if (field.getType() != Integer.TYPE) continue;
                BinaryWireCode.STRING_FOR_CODE[field.getInt(null)] = field.getName();
            }
            for (i = 192; i <= 223; ++i) {
                BinaryWireCode.STRING_FOR_CODE[i] = "FIELD_" + i;
            }
            for (i = 224; i <= 255; ++i) {
                BinaryWireCode.STRING_FOR_CODE[i] = "STRING_" + i;
            }
            for (i = 0; i < STRING_FOR_CODE.length; ++i) {
                if (STRING_FOR_CODE[i] != null) continue;
                BinaryWireCode.STRING_FOR_CODE[i] = i <= 32 || i >= 127 ? "Unknown_0x" + Integer.toHexString(i).toUpperCase() : "Unknown_" + (char)i;
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

