/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.util.CharSequenceComparator;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;

public class VanillaWireParser<O>
implements WireParser<O> {
    private final Map<CharSequence, WireParselet<O>> namedConsumer = new TreeMap<CharSequence, WireParselet<O>>((Comparator<CharSequence>)CharSequenceComparator.INSTANCE);
    private final WireParselet<O> defaultConsumer;
    private final StringBuilder sb = new StringBuilder(128);
    private final StringBuilder lastEventName = new StringBuilder(128);
    private FieldNumberParselet<O> fieldNumberParselet;
    private WireParselet<O> lastParslet = null;
    private long lastStart = 0L;

    public VanillaWireParser(@org.jetbrains.annotations.NotNull WireParselet<O> defaultConsumer, @org.jetbrains.annotations.NotNull FieldNumberParselet<O> fieldNumberParselet) {
        this.defaultConsumer = defaultConsumer;
        this.lastEventName.appendCodePoint(65535);
        this.fieldNumberParselet = fieldNumberParselet;
    }

    private int peekCode(@NotNull WireIn wireIn) {
        return wireIn.bytes().peekUnsignedByte();
    }

    @Override
    public WireParselet<O> getDefaultConsumer() {
        return this.defaultConsumer;
    }

    @Override
    public void parseOne(@org.jetbrains.annotations.NotNull WireIn wireIn, O out) {
        WireParselet<O> parslet;
        if (this.peekCode(wireIn) == 186) {
            this.fieldNumberParselet.readOne(wireIn.readEventNumber(), wireIn, out);
            return;
        }
        long start = wireIn.bytes().readPosition();
        ValueIn valueIn = wireIn.readEventName(this.sb);
        if (StringUtils.isEqual((StringBuilder)this.sb, (CharSequence)this.lastEventName)) {
            parslet = this.lastParslet;
        } else {
            parslet = this.lookup(this.sb);
            if (parslet == null) {
                if (this.sb.length() == 0) {
                    Jvm.warn().on(this.getClass(), "Attempt to read method name/id but not at the start of a method, the previous method name was " + this.lastEventName + "\n" + wireIn.bytes().toHexString(start, 1024L));
                    if (this.lastStart < start && this.lastStart + 1024L >= start) {
                        Jvm.warn().on(this.getClass(), "The previous message was\n" + wireIn.bytes().toHexString(this.lastStart, start - this.lastStart));
                    }
                }
                parslet = this.getDefaultConsumer();
            }
        }
        parslet.accept(this.sb, valueIn, out);
        this.lastEventName.setLength(0);
        this.lastEventName.append((CharSequence)this.sb);
        this.lastParslet = parslet;
        this.lastStart = start;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public VanillaWireParser<O> register(@org.jetbrains.annotations.NotNull WireKey key, WireParselet<O> valueInConsumer) {
        this.namedConsumer.put(key.name(), valueInConsumer);
        return this;
    }

    @Override
    public WireParselet<O> lookup(CharSequence name) {
        return this.namedConsumer.get(name);
    }
}

