/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class WiredBytes<D extends Marshallable>
implements Closeable {
    private static final long TIMEOUT_MS = 10000L;
    private final Function<Bytes, Wire> wireType;
    private final MappedBytes mappedBytes;
    private final D delegate;
    private final long headerLength;
    private final boolean headerCreated;

    public WiredBytes(@NotNull Function<Bytes, Wire> wireType, @NotNull MappedBytes mappedBytes, @NotNull D delegate, long headerLength, boolean headerCreated) {
        this.wireType = wireType;
        this.mappedBytes = mappedBytes;
        this.delegate = delegate;
        this.headerLength = headerLength;
        this.headerCreated = headerCreated;
    }

    public static <D extends Marshallable> WiredBytes<D> build(String masterFile, Function<File, MappedBytes> toMappedBytes, WireType wireType, Function<MappedBytes, D> delegateSupplier, Consumer<WiredBytes<D>> consumer) {
        return WiredBytes.build(new File(masterFile), toMappedBytes, wireType, delegateSupplier, consumer);
    }

    public static <D extends Marshallable> WiredBytes<D> build(File masterFile, Function<File, MappedBytes> mappedBytesFunction, WireType wireType, Function<MappedBytes, D> delegateSupplier, Consumer<WiredBytes<D>> installer) {
        WiredBytes<Marshallable> wiredBytes;
        MappedBytes mappedBytes;
        File parentFile = masterFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        if ((mappedBytes = mappedBytesFunction.apply(masterFile)).compareAndSwapInt(0L, 0, -1073741824)) {
            Bytes bytes = (Bytes)mappedBytes.bytesForWrite().writePosition(4L);
            Marshallable delegate = (Marshallable)delegateSupplier.apply(mappedBytes);
            ((Wire)wireType.apply(bytes)).getValueOut().typedMarshallable(delegate);
            long length = bytes.writePosition();
            wiredBytes = new WiredBytes<Marshallable>(wireType, mappedBytes, delegate, length, true);
            installer.accept(wiredBytes);
            mappedBytes.writeOrderedInt(0L, 0x40000000 | Wires.toIntU30(bytes.writePosition() - 4L, "Delegate too large"));
        } else {
            long end = System.currentTimeMillis() + 10000L;
            while ((mappedBytes.readVolatileInt(0L) & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                if (System.currentTimeMillis() > end) {
                    throw new IllegalStateException("Timed out waiting for the header record to be ready in " + masterFile);
                }
                Jvm.pause((long)1L);
            }
            mappedBytes.readPosition(0L);
            mappedBytes.writePosition(mappedBytes.capacity());
            int len = Wires.lengthOf(mappedBytes.readVolatileInt());
            long length = mappedBytes.readPosition() + (long)len;
            mappedBytes.readLimit(length);
            Marshallable delegate = (Marshallable)((Wire)wireType.apply(mappedBytes)).getValueIn().typedMarshallable();
            wiredBytes = new WiredBytes<Marshallable>(wireType, mappedBytes, delegate, length, false);
            installer.accept(wiredBytes);
        }
        return wiredBytes;
    }

    public D delegate() {
        return this.delegate;
    }

    public long headerLength() {
        return this.headerLength;
    }

    public boolean headerCreated() {
        return this.headerCreated;
    }

    public Function<Bytes, Wire> wireSupplier() {
        return this.wireType;
    }

    public void close() {
        this.mappedBytes.close();
    }

    public MappedBytes mappedBytes() {
        return this.mappedBytes;
    }
}

