/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class WiredFile<D extends Marshallable>
implements Closeable {
    private static final long TIMEOUT_MS = 10000L;
    private final File masterFile;
    private final Function<Bytes, Wire> wireType;
    private final MappedFile mappedFile;
    private final D delegate;
    private final BytesStore headerStore;
    private final long headerLength;
    private final boolean headerCreated;
    private final MappedBytesStoreFactory<WiredMappedBytesStore> mappedBytesStoreFactory;

    public WiredFile(@NotNull File masterFile, @NotNull Function<Bytes, Wire> wireType, @NotNull MappedFile mappedFile, @NotNull D delegate, @NotNull BytesStore headerStore, long headerLength, boolean headerCreated, @NotNull MappedBytesStoreFactory<WiredMappedBytesStore> mappedBytesStoreFactory) {
        this.masterFile = masterFile;
        this.wireType = wireType;
        this.mappedFile = mappedFile;
        this.delegate = delegate;
        this.headerStore = headerStore;
        this.headerLength = headerLength;
        this.headerCreated = headerCreated;
        this.mappedBytesStoreFactory = mappedBytesStoreFactory;
    }

    public File masterFile() {
        return this.masterFile;
    }

    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    public D delegate() {
        return this.delegate;
    }

    public long headerLength() {
        return this.headerLength;
    }

    public BytesStore headerStore() {
        return this.headerStore;
    }

    public boolean headerCreated() {
        return this.headerCreated;
    }

    public Function<Bytes, Wire> wireSupplier() {
        return this.wireType;
    }

    public Wire acquireWiredChunk(long position) throws IOException {
        WiredMappedBytesStore mappedBytesStore = (WiredMappedBytesStore)this.mappedFile.acquireByteStore(position, this.mappedBytesStoreFactory);
        return mappedBytesStore.getWire();
    }

    public void close() {
        this.mappedFile.close();
    }

    public static <D extends Marshallable> WiredFile<D> build(@NotNull String masterFile, @NotNull ThrowingFunction<File, IOException, MappedFile> mappedFileFunction, @NotNull Function<Bytes, Wire> wireType, @NotNull Supplier<D> delegateSupplier, @NotNull ThrowingAcceptor<WiredFile<D>, IOException> installer) throws IOException {
        return WiredFile.build(new File(masterFile), mappedFileFunction, wireType, delegateSupplier, installer);
    }

    public static <D extends Marshallable> WiredFile<D> build(@NotNull File masterFile, @NotNull ThrowingFunction<File, IOException, MappedFile> mappedFileFunction, @NotNull Function<Bytes, Wire> wireType, @NotNull Supplier<D> delegateSupplier, @NotNull ThrowingAcceptor<WiredFile<D>, IOException> installer) throws IOException {
        WiredFile<Marshallable> wiredFile;
        File parentFile = masterFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        MappedFile mappedFile = (MappedFile)mappedFileFunction.apply((Object)masterFile);
        MappedBytesStoreFactory mappedBytesStoreFactory = (owner, start, address, capacity, safeCapacity) -> new WiredMappedBytesStore(owner, start, address, capacity, safeCapacity, wireType);
        WiredMappedBytesStore header = (WiredMappedBytesStore)mappedFile.acquireByteStore(0L, mappedBytesStoreFactory);
        assert (header != null);
        if (header.compareAndSwapInt(0L, 0, -1073741824)) {
            Bytes bytes = header.bytesForWrite().writePosition(4L);
            Marshallable delegate = (Marshallable)delegateSupplier.get();
            wireType.apply(bytes).getValueOut().typedMarshallable(delegate);
            long length = bytes.writePosition();
            wiredFile = new WiredFile<Marshallable>(masterFile, wireType, mappedFile, delegate, (BytesStore)header, length, true, (MappedBytesStoreFactory<WiredMappedBytesStore>)mappedBytesStoreFactory);
            installer.accept(wiredFile);
            header.writeOrderedInt(0L, 0x40000000 | Wires.toIntU30(bytes.writePosition() - 4L, "Delegate too large"));
        } else {
            long end = System.currentTimeMillis() + 10000L;
            while ((header.readVolatileInt(0L) & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                if (System.currentTimeMillis() > end) {
                    throw new IllegalStateException("Timed out waiting for the header record to be ready in " + masterFile);
                }
                Jvm.pause((long)1L);
            }
            Bytes<?> bytes = header.wire.bytes();
            bytes.readPosition(0L);
            bytes.writePosition(bytes.capacity());
            int len = Wires.lengthOf(bytes.readVolatileInt());
            long length = bytes.readPosition() + (long)len;
            bytes.readLimit(length);
            Marshallable delegate = (Marshallable)wireType.apply(bytes).getValueIn().typedMarshallable();
            wiredFile = new WiredFile<Marshallable>(masterFile, wireType, mappedFile, delegate, (BytesStore)header, length, false, (MappedBytesStoreFactory<WiredMappedBytesStore>)mappedBytesStoreFactory);
            installer.accept(wiredFile);
        }
        return wiredFile;
    }

    static class WiredMappedBytesStore
    extends MappedBytesStore {
        private final Wire wire;

        WiredMappedBytesStore(ReferenceCounted owner, long start, long address, long capacity, long safeCapacity, Function<Bytes, Wire> wireType) throws IllegalStateException {
            super(owner, start, address, capacity, safeCapacity);
            this.wire = wireType.apply((Bytes)this.bytesForWrite());
        }

        public Wire getWire() {
            return this.wire;
        }
    }
}

