/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public interface Wire
extends WireIn,
WireOut {
    public static Function<Bytes, Wire> bytesToWire(@NotNull Class<? extends Wire> wireClass) {
        if (TextWire.class.isAssignableFrom(wireClass)) {
            return TextWire::new;
        }
        if (BinaryWire.class.isAssignableFrom(wireClass)) {
            return BinaryWire::new;
        }
        throw new UnsupportedOperationException("type " + wireClass.getSimpleName() + " is not currently supported.");
    }
}

