/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public interface ValueOut {
    public WireOut bool(Boolean var1);

    public WireOut text(CharSequence var1);

    default public WireOut int8(long x) {
        return this.int8(Maths.toInt8((long)x));
    }

    public WireOut int8(byte var1);

    public WireOut bytes(Bytes var1);

    public WireOut rawBytes(byte[] var1);

    public ValueOut writeLength(long var1);

    public WireOut bytes(byte[] var1);

    default public WireOut uint8(int x) {
        return this.uint8checked(Maths.toUInt8((long)x));
    }

    public WireOut uint8checked(int var1);

    default public WireOut int16(long x) {
        return this.int16(Maths.toInt16((long)x));
    }

    public WireOut int16(short var1);

    default public WireOut uint16(long x) {
        return this.uint16checked((int)x);
    }

    public WireOut uint16checked(int var1);

    public WireOut utf8(int var1);

    default public WireOut int32(long x) {
        return this.int32(Maths.toInt32((long)x));
    }

    public WireOut int32(int var1);

    default public WireOut uint32(long x) {
        return this.uint32checked(x);
    }

    public WireOut uint32checked(long var1);

    public WireOut int64(long var1);

    public WireOut int64array(long var1);

    public WireOut float32(float var1);

    public WireOut float64(double var1);

    public WireOut time(LocalTime var1);

    public WireOut zonedDateTime(ZonedDateTime var1);

    public WireOut date(LocalDate var1);

    public WireOut type(CharSequence var1);

    public WireOut uuid(UUID var1);

    public WireOut int32forBinding(int var1);

    public WireOut int64forBinding(long var1);

    public WireOut sequence(Consumer<ValueOut> var1);

    public WireOut marshallable(WriteMarshallable var1);

    public WireOut map(Map var1);

    public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> var1);

    public ValueOut leaf();

    default public WireOut typedMarshallable(WriteMarshallable object) {
        this.type(object.getClass().getName());
        return this.marshallable(object);
    }

    default public WireOut typedMarshallable(CharSequence typeName, WriteMarshallable object) {
        this.type(typeName);
        return this.marshallable(object);
    }

    default public WireOut object(Object value) {
        if (value instanceof byte[]) {
            return this.rawBytes((byte[])value);
        }
        if (value == null) {
            return this.text(null);
        }
        if (value instanceof Map) {
            return this.map((Map)value);
        }
        if (value instanceof Byte) {
            return this.int8((Byte)value);
        }
        if (value instanceof Character) {
            return this.text(value.toString());
        }
        if (value instanceof Short) {
            return this.int16((Short)value);
        }
        if (value instanceof Integer) {
            return this.int32((Integer)value);
        }
        if (value instanceof Long) {
            return this.int64((Long)value);
        }
        if (value instanceof CharSequence) {
            return this.text((CharSequence)value);
        }
        if (value instanceof Marshallable) {
            return this.marshallable((Marshallable)value);
        }
        if (value instanceof Throwable) {
            return this.throwable((Throwable)value);
        }
        throw new IllegalStateException("type=" + value.getClass() + " is unsupported, it must either be of type Marshallable, String or " + "AutoBoxed primitive Object");
    }

    default public WireOut throwable(Throwable t) {
        this.typedMarshallable(t.getClass().getName(), w -> w.write(() -> "message").text(t.getMessage()).write(() -> "stackTrace").sequence(w3 -> {
            StackTraceElement[] stes = t.getStackTrace();
            int last = Jvm.trimLast((int)0, (StackTraceElement[])stes);
            for (int i = 0; i < last; ++i) {
                StackTraceElement ste = stes[i];
                w3.leaf().marshallable(w4 -> w4.write(() -> "class").text(ste.getClassName()).write(() -> "method").text(ste.getMethodName()).write(() -> "file").text(ste.getFileName()).write(() -> "line").int32(ste.getLineNumber()));
            }
        }));
        return this.wireOut();
    }

    public WireOut wireOut();
}

