/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Consumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;

public interface WireParser {
    public static final WireKey DEFAULT = () -> ":default:";

    public static WireParser wireParser() {
        return new VanillaWireParser();
    }

    default public void parse(WireIn wireIn) {
        StringBuilder sb = Wires.SBP.acquireStringBuilder();
        ValueIn valueIn = wireIn.read(sb);
        Consumer<ValueIn> consumer = this.lookup(sb);
        if (consumer == null) {
            consumer = this.lookup(DEFAULT.name());
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Unhandled event type " + sb);
        }
        consumer.accept(valueIn);
    }

    public Consumer<ValueIn> lookup(CharSequence var1);

    default public void setDefault(Consumer<ValueIn> valueInConsumer) {
        this.register(DEFAULT, valueInConsumer);
    }

    public void register(WireKey var1, Consumer<ValueIn> var2);

    public Consumer<ValueIn> lookup(int var1);
}

