/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.set;

import java.io.StreamCorruptedException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireHandlers;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.set.SetWireHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetWireHandlerProcessor<U>
implements SetWireHandler<U>,
Consumer<WireHandlers> {
    private Function<ValueIn, U> fromWire;
    private BiConsumer<ValueOut, U> toWire;
    private static final Logger LOG = LoggerFactory.getLogger(SetWireHandlerProcessor.class);
    public static final int SIZE_OF_SIZE = 2;
    private Wire inWire = null;
    private Wire outWire = null;
    private Set<U> underlyingSet;
    public long tid;
    private final Consumer<WireIn> metaDataConsumer = new Consumer<WireIn>(){

        @Override
        public void accept(WireIn wireIn) {
            ValueIn read;
            StringBuilder sb = Wires.acquireStringBuilder();
            do {
                read = SetWireHandlerProcessor.this.inWire.read(sb);
            } while (!CoreFields.tid.contentEquals(sb));
            SetWireHandlerProcessor.this.tid = read.int64();
        }
    };
    private final Consumer<WireIn> dataConsumer = new Consumer<WireIn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn) {
            Bytes<?> outBytes = SetWireHandlerProcessor.this.outWire.bytes();
            try {
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn valueIn = SetWireHandlerProcessor.this.inWire.readEventName(eventName);
                SetWireHandlerProcessor.this.outWire.writeDocument(true, wire -> SetWireHandlerProcessor.this.outWire.write(CoreFields.tid).int64(SetWireHandlerProcessor.this.tid));
                SetWireHandlerProcessor.this.outWire.writeDocument(false, out -> {
                    if (SetWireHandler.SetEventId.remove.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(SetWireHandlerProcessor.this.underlyingSet.remove(SetWireHandlerProcessor.this.fromWire.apply(valueIn)));
                        return;
                    }
                    if (SetWireHandler.SetEventId.iterator.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.underlyingSet.forEach(e -> SetWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).sequence(v -> SetWireHandlerProcessor.this.toWire.accept(v, e)));
                        return;
                    }
                    if (SetWireHandler.SetEventId.numberOfSegments.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.outWire.write(CoreFields.reply).int32(1);
                        return;
                    }
                    if (SetWireHandler.SetEventId.isEmpty.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(SetWireHandlerProcessor.this.underlyingSet.isEmpty());
                        return;
                    }
                    if (SetWireHandler.SetEventId.size.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.outWire.write(CoreFields.reply).int32(SetWireHandlerProcessor.this.underlyingSet.size());
                        return;
                    }
                    if (SetWireHandler.SetEventId.clear.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.underlyingSet.clear();
                        return;
                    }
                    if (SetWireHandler.SetEventId.contains.contentEquals(eventName)) {
                        SetWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(SetWireHandlerProcessor.this.underlyingSet.contains(SetWireHandlerProcessor.this.fromWire.apply(valueIn)));
                        return;
                    }
                    throw new IllegalStateException("unsupported event=" + eventName);
                });
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                long len = outBytes.position() - 2L;
                if (len == 0L) {
                    System.out.println("--------------------------------------------\nserver writes:\n\n<EMPTY>");
                } else {
                    System.out.println("--------------------------------------------\nserver writes:\n\n" + Wires.fromSizePrefixedBlobs(outBytes, 2L, len));
                }
            }
        }
    };

    @Override
    public void process(Wire in, Wire out, Set<U> set, CharSequence csp, BiConsumer<ValueOut, U> toWire, Function<ValueIn, U> fromWire) throws StreamCorruptedException {
        this.fromWire = fromWire;
        this.toWire = toWire;
        this.underlyingSet = set;
        try {
            this.inWire = in;
            this.outWire = out;
            this.inWire.readDocument(this.metaDataConsumer, this.dataConsumer);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public void accept(@NotNull WireHandlers wireHandlers) {
    }
}

