/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueIn {
    @NotNull
    public WireIn bool(@NotNull BooleanConsumer var1);

    @NotNull
    public WireIn text(@NotNull Consumer<String> var1);

    default public String text() {
        StringBuilder sb = Wires.acquireStringBuilder();
        this.text(sb);
        return sb.toString();
    }

    @NotNull
    public WireIn text(@NotNull StringBuilder var1);

    @NotNull
    public WireIn int8(@NotNull ByteConsumer var1);

    @NotNull
    public WireIn bytes(@NotNull Bytes<?> var1);

    @NotNull
    public WireIn bytes(@NotNull Consumer<WireIn> var1);

    public byte[] bytes();

    @NotNull
    public WireIn wireIn();

    public long readLength();

    @NotNull
    public WireIn uint8(@NotNull ShortConsumer var1);

    @NotNull
    public WireIn int16(@NotNull ShortConsumer var1);

    @NotNull
    public WireIn uint16(@NotNull IntConsumer var1);

    @NotNull
    public WireIn int32(@NotNull IntConsumer var1);

    @NotNull
    public WireIn uint32(@NotNull LongConsumer var1);

    @NotNull
    public WireIn int64(@NotNull LongConsumer var1);

    @NotNull
    public WireIn float32(@NotNull FloatConsumer var1);

    @NotNull
    public WireIn float64(@NotNull DoubleConsumer var1);

    @NotNull
    public WireIn time(@NotNull Consumer<LocalTime> var1);

    @NotNull
    public WireIn zonedDateTime(@NotNull Consumer<ZonedDateTime> var1);

    @NotNull
    public WireIn date(@NotNull Consumer<LocalDate> var1);

    public boolean hasNext();

    public boolean hasNextSequenceItem();

    public WireIn uuid(@NotNull Consumer<UUID> var1);

    public WireIn int64array(@Nullable LongArrayValues var1, @NotNull Consumer<LongArrayValues> var2);

    public WireIn int64(@Nullable LongValue var1, @NotNull Consumer<LongValue> var2);

    public WireIn int32(@Nullable IntValue var1, @NotNull Consumer<IntValue> var2);

    public WireIn sequence(@NotNull Consumer<ValueIn> var1);

    public <T> T applyToMarshallable(Function<WireIn, T> var1);

    @NotNull
    default public Marshallable typedMarshallable() {
        try {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.type(sb);
            Class<?> clazz = Class.forName(sb.toString());
            if (!Marshallable.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("its not possible to Marshallable and object that is not of type Marshallable, type=" + sb);
            }
            Marshallable m = (Marshallable)UnsafeMemory.MEMORY.allocateInstance(clazz);
            this.marshallable(m);
            return m;
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    @NotNull
    public WireIn type(@NotNull StringBuilder var1);

    @NotNull
    public WireIn marshallable(@NotNull ReadMarshallable var1);

    public <R> R applyMarshallable(@NotNull Function<WireIn, R> var1);

    default public void map(@NotNull Map<String, String> usingMap) {
        this.map(String.class, String.class, usingMap);
    }

    public void typedMap(@NotNull Map<Marshallable, Marshallable> var1);

    public <K, V> Map<K, V> map(@NotNull Class<K> var1, @NotNull Class<V> var2, @NotNull Map<K, V> var3);

    public boolean bool();

    public byte int8();

    public short int16();

    public int uint16();

    public int int32();

    public long int64();

    public double float64();

    public float float32();

    public boolean isNull();

    @Nullable
    default public <E> E object(@NotNull Class<E> clazz) {
        return this.object(null, clazz);
    }

    default public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
        if (byte[].class.isAssignableFrom(clazz)) {
            return (E)this.bytes();
        }
        if (Marshallable.class.isAssignableFrom(clazz)) {
            E v;
            if (using == null) {
                try {
                    v = clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                v = using;
            }
            this.marshallable((Marshallable)v);
            return v;
        }
        if (StringBuilder.class.isAssignableFrom(clazz)) {
            StringBuilder builder = using == null ? Wires.acquireStringBuilder() : (StringBuilder)using;
            this.text(builder);
            return using;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return (E)this.text();
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (E)Long.valueOf(this.int64());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (E)Double.valueOf(this.float64());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (E)Integer.valueOf(this.int32());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (E)Float.valueOf(this.float32());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (E)Short.valueOf(this.int16());
        }
        if (Character.class.isAssignableFrom(clazz)) {
            String text = this.text();
            if (text == null || text.length() == 0) {
                return null;
            }
            return (E)Character.valueOf(text.charAt(0));
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (E)Byte.valueOf(this.int8());
        }
        if (Map.class.isAssignableFrom(clazz)) {
            HashMap<String, String> result = new HashMap<String, String>();
            this.map(result);
            return (E)result;
        }
        throw new IllegalStateException("unsupported type");
    }
}

