/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;

public class WireSerializedLambda
implements ReadMarshallable,
ReadResolvable {
    private Class<?> capturingClass;
    private String functionalInterfaceClass;
    private String functionalInterfaceMethodName;
    private String functionalInterfaceMethodSignature;
    private String implClass;
    private String implMethodName;
    private String implMethodSignature;
    private int implMethodKind;
    private String instantiatedMethodType;
    @NotNull
    private List<Object> capturedArgs = new ArrayList<Object>();

    public static boolean isSerializableLambda(@NotNull Class clazz) {
        return Serializable.class.isAssignableFrom(clazz) && clazz.getName().contains("$Lambda$");
    }

    public static <Lambda> void write(@NotNull Lambda lambda, @NotNull ValueOut valueOut) {
        try {
            Method writeReplace = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda sl = (SerializedLambda)writeReplace.invoke(lambda, new Object[0]);
            valueOut.type("SerializedLambda");
            valueOut.marshallable(v -> v.write(() -> "cc").typeLiteral(sl.getCapturingClass().replace('/', '.')).write(() -> "fic").text(sl.getFunctionalInterfaceClass()).write(() -> "fimn").text(sl.getFunctionalInterfaceMethodName()).write(() -> "fims").text(sl.getFunctionalInterfaceMethodSignature()).write(() -> "imk").int32(sl.getImplMethodKind()).write(() -> "ic").text(sl.getImplClass()).write(() -> "imn").text(sl.getImplMethodName()).write(() -> "ims").text(sl.getImplMethodSignature()).write(() -> "imt").text(sl.getInstantiatedMethodType()).write(() -> "ca").sequence(v2 -> {
                for (int i = 0; i < sl.getCapturedArgCount(); ++i) {
                    v2.object(sl.getCapturedArg(i));
                }
            }));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.capturedArgs = new ArrayList<Object>();
        wire.read(() -> "cc").typeLiteral(t -> {
            this.capturingClass = t;
        }).read(() -> "fic").text(s -> {
            this.functionalInterfaceClass = s;
        }).read(() -> "fimn").text(s -> {
            this.functionalInterfaceMethodName = s;
        }).read(() -> "fims").text(s -> {
            this.functionalInterfaceMethodSignature = s;
        }).read(() -> "imk").int32(i -> {
            this.implMethodKind = i;
        }).read(() -> "ic").text(s -> {
            this.implClass = s;
        }).read(() -> "imn").text(s -> {
            this.implMethodName = s;
        }).read(() -> "ims").text(s -> {
            this.implMethodSignature = s;
        }).read(() -> "imt").text(s -> {
            this.instantiatedMethodType = s;
        }).read(() -> "ca").sequence(v2 -> {
            while (v2.hasNextSequenceItem()) {
                this.capturedArgs.add(v2.object(Object.class));
            }
        });
    }

    public Object readResolve() {
        SerializedLambda sl = new SerializedLambda(this.capturingClass, this.functionalInterfaceClass, this.functionalInterfaceMethodName, this.functionalInterfaceMethodSignature, this.implMethodKind, this.implClass, this.implMethodName, this.implMethodSignature, this.instantiatedMethodType, this.capturedArgs.toArray());
        try {
            Method readReplace = SerializedLambda.class.getDeclaredMethod("readResolve", new Class[0]);
            readReplace.setAccessible(true);
            return readReplace.invoke((Object)sl, new Object[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

