/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;

public class BinaryLongReference
implements LongValue,
Byteable {
    private BytesStore bytes;
    private long offset;

    public void bytesStore(BytesStore bytes, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.bytes = bytes.bytesStore();
        this.offset = offset;
    }

    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return "value: " + this.getValue();
    }

    public long getValue() {
        return this.bytes.readLong(this.offset);
    }

    public void setValue(long value) {
        this.bytes.writeLong(this.offset, value);
    }

    public long getVolatileValue() {
        return this.bytes.readVolatileLong(this.offset);
    }

    public void setOrderedValue(long value) {
        this.bytes.writeOrderedLong(this.offset, value);
    }

    public long addValue(long delta) {
        return this.bytes.addAndGetLong(this.offset, delta);
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        return this.bytes.compareAndSwapLong(this.offset, expected, value);
    }
}

