/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Wires
extends Enum<Wires> {
    public static final int NOT_READY = Integer.MIN_VALUE;
    public static final int META_DATA = 0x40000000;
    public static final int UNKNOWN_LENGTH = 0;
    public static final int LENGTH_MASK = 0x3FFFFFFF;
    public static final StringInterner INTERNER;
    static final StringBuilderPool SBP;
    static final StringBuilderPool ASBP;
    static final StackTraceElement[] NO_STE;
    private static final Field DETAILED_MESSAGE;
    private static final Field STACK_TRACE;
    private static final /* synthetic */ Wires[] $VALUES;

    public static Wires[] values() {
        return (Wires[])$VALUES.clone();
    }

    public static Wires valueOf(String name) {
        return Enum.valueOf(Wires.class, name);
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static StringBuilder acquireAnotherStringBuilder(CharSequence cs) {
        StringBuilder sb = ASBP.acquireStringBuilder();
        assert (sb != cs);
        return sb;
    }

    public static void writeData(@NotNull WireOut wireOut, boolean metaData, boolean notReady, @NotNull Consumer<WireOut> writer) {
        Bytes<?> bytes = wireOut.bytes();
        long position = bytes.writePosition();
        int metaDataBit = metaData ? 0x40000000 : 0;
        bytes.writeOrderedInt(metaDataBit | Integer.MIN_VALUE | 0);
        writer.accept(wireOut);
        int length = metaDataBit | BinaryWire.toIntU30(bytes.writePosition() - position - 4L, "Document length %,d out of 30-bit int range.");
        bytes.writeOrderedInt(position, length | (notReady ? Integer.MIN_VALUE : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readData(long offset, @NotNull WireIn wireIn, @Nullable Consumer<WireIn> metaDataConsumer, @Nullable Consumer<WireIn> dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readLimit(bytes.isElastic() ? bytes.capacity() : bytes.realCapacity());
            bytes.readPosition(offset);
            boolean bl = Wires.readData(wireIn, metaDataConsumer, dataConsumer);
            return bl;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readData(@NotNull WireIn wireIn, @Nullable Consumer<WireIn> metaDataConsumer, @Nullable Consumer<WireIn> dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        boolean read = false;
        while (bytes.readRemaining() >= 4L) {
            long position = bytes.readPosition();
            int header = bytes.readVolatileInt(position);
            if (!Wires.isKnownLength(header)) {
                return read;
            }
            bytes.readSkip(4L);
            boolean ready = Wires.isReady(header);
            int len = Wires.lengthOf(header);
            if (Wires.isData(header)) {
                if (dataConsumer == null) {
                    return false;
                }
                ((InternalWireIn)wireIn).setReady(ready);
                bytes.readWithLength((long)len, b -> dataConsumer.accept(wireIn));
                return true;
            }
            if (metaDataConsumer == null) {
                bytes.readSkip((long)len);
            } else {
                if ((long)len > bytes.readRemaining()) {
                    throw new BufferUnderflowException();
                }
                long limit0 = bytes.readLimit();
                long limit = bytes.readPosition() + (long)len;
                try {
                    bytes.readLimit(limit);
                    metaDataConsumer.accept(wireIn);
                }
                finally {
                    bytes.readLimit(limit0);
                    bytes.readPosition(limit);
                }
            }
            if (dataConsumer == null) {
                return true;
            }
            read = true;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rawReadData(WireIn wireIn, Consumer<WireIn> dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        int header = bytes.readInt();
        assert (Wires.isReady(header) && Wires.isData(header));
        int len = Wires.lengthOf(header);
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + (long)len;
        try {
            bytes.readLimit(limit);
            dataConsumer.accept(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
        }
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes) {
        long position = bytes.readPosition();
        return Wires.fromSizePrefixedBlobs(bytes, position, bytes.readRemaining());
    }

    public static int lengthOf(long len) {
        return (int)(len & 0x3FFFFFFFL);
    }

    public static boolean isReady(long len) {
        return (len & Integer.MIN_VALUE) == 0L;
    }

    public static boolean isData(long len) {
        return (len & 0x40000000L) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position, long length) {
        StringBuilder sb = new StringBuilder();
        long limit0 = bytes.readLimit();
        long position0 = bytes.readPosition();
        try {
            bytes.readPosition(position);
            bytes.readLimit(position + length);
            while (bytes.readRemaining() >= 4L) {
                long header = bytes.readUnsignedInt();
                int len = Wires.lengthOf(header);
                String type = Wires.isData(header) ? (Wires.isReady(header) ? "!!data" : "!!not-ready-data!") : (Wires.isReady(header) ? "!!meta-data" : "!!not-ready-meta-data!");
                boolean binary = bytes.readByte(bytes.readPosition()) < 32;
                sb.append("--- ").append(type).append(binary ? " #binary\n" : "\n");
                for (int i = 0; i < len; ++i) {
                    int ch = bytes.readUnsignedByte();
                    if (binary) {
                        sb.append(RandomDataInput.charToString[ch]);
                        continue;
                    }
                    sb.append((char)ch);
                }
                if (sb.charAt(sb.length() - 1) == '\n') continue;
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit0);
            bytes.readPosition(position0);
        }
    }

    public static boolean isKnownLength(long len) {
        return (len & Integer.MAX_VALUE) != 0L;
    }

    public static Throwable throwable(@NotNull ValueIn valueIn, boolean appendCurrentStack) {
        Throwable throwable;
        StringBuilder type = Wires.acquireStringBuilder();
        valueIn.type(type);
        String preMessage = null;
        try {
            throwable = (Throwable)OS.memory().allocateInstance(Class.forName(INTERNER.intern((CharSequence)type)));
        }
        catch (ClassNotFoundException e) {
            preMessage = type.toString();
            throwable = new RuntimeException();
        }
        String finalPreMessage = preMessage;
        Throwable finalThrowable = throwable;
        ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>();
        valueIn.marshallable(m -> {
            String message = Wires.merge(finalPreMessage, m.read(() -> "message").text());
            if (message != null) {
                try {
                    DETAILED_MESSAGE.set(finalThrowable, message);
                }
                catch (IllegalAccessException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
            }
            m.read(() -> "stackTrace").sequence(stackTrace -> {
                while (stackTrace.hasNextSequenceItem()) {
                    stackTrace.marshallable(r -> {
                        String declaringClass = r.read(() -> "class").text();
                        String methodName = r.read(() -> "method").text();
                        String fileName = r.read(() -> "file").text();
                        int lineNumber = r.read(() -> "line").int32();
                        stes.add(new StackTraceElement(declaringClass, methodName, fileName, lineNumber));
                    });
                }
            });
        });
        if (appendCurrentStack) {
            stes.add(new StackTraceElement("~ remote", "tcp ~", "", 0));
            StackTraceElement[] stes2 = Thread.currentThread().getStackTrace();
            int first = 6;
            int last = Jvm.trimLast((int)first, (StackTraceElement[])stes2);
            for (int i = first; i <= last; ++i) {
                stes.add(stes2[i]);
            }
        }
        try {
            STACK_TRACE.set(finalThrowable, stes.toArray(NO_STE));
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return throwable;
    }

    @Nullable
    static String merge(@Nullable String a, @Nullable String b) {
        return a == null ? b : (b == null ? a : a + " " + b);
    }

    static {
        $VALUES = new Wires[0];
        INTERNER = new StringInterner(128);
        SBP = new StringBuilderPool();
        ASBP = new StringBuilderPool();
        NO_STE = new StackTraceElement[0];
        DETAILED_MESSAGE = Jvm.getField(Throwable.class, (String)"detailMessage");
        STACK_TRACE = Jvm.getField(Throwable.class, (String)"stackTrace");
        ClassAliasPool.CLASS_ALIASES.addAlias(WireSerializedLambda.class, "SerializedLambda");
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
    }
}

