/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;

public enum WireType implements Function<Bytes, Wire>
{
    TEXT{

        @Override
        public Wire apply(Bytes bytes) {
            return new TextWire(bytes);
        }
    }
    ,
    BINARY{

        @Override
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, true);
        }
    }
    ,
    RAW{

        @Override
        public Wire apply(Bytes bytes) {
            return new RawWire(bytes);
        }
    };

}

