/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;

enum BinaryWireCode {

    static final int BYTES_LENGTH32 = 130;
    static final int U8_ARRAY = 138;
    static final int I64_ARRAY = 141;
    static final int PADDING32 = 142;
    static final int PADDING = 143;
    static final int FLOAT32 = 144;
    static final int FLOAT64 = 145;
    static final int UUID = 160;
    static final int UINT8 = 161;
    static final int UINT16 = 162;
    static final int UINT32 = 163;
    static final int INT8 = 164;
    static final int INT16 = 165;
    static final int INT32 = 166;
    static final int INT64 = 167;
    static final int FALSE = 176;
    static final int TRUE = 177;
    static final int TIME = 178;
    static final int DATE = 179;
    static final int DATE_TIME = 180;
    static final int ZONED_DATE_TIME = 181;
    static final int TYPE_PREFIX = 182;
    static final int FIELD_NAME_ANY = 183;
    static final int STRING_ANY = 184;
    static final int EVENT_NAME = 185;
    static final int FIELD_NUMBER = 186;
    static final int NULL = 187;
    static final int TYPE_LITERAL = 188;
    static final int COMMENT = 190;
    static final int HINT = 191;
    static final int FIELD_NAME0 = 192;
    static final int FIELD_NAME31 = 223;
    static final int STRING_0 = 224;
    static final int STRING_31 = 255;
    static final String[] STRING_FOR_CODE = new String[256];

    public static String stringForCode(int code) {
        return STRING_FOR_CODE[code];
    }

    static {
        try {
            int i;
            for (Field field : BinaryWireCode.class.getDeclaredFields()) {
                if (field.getType() != Integer.TYPE) continue;
                BinaryWireCode.STRING_FOR_CODE[field.getInt(null)] = field.getName();
            }
            for (i = 192; i <= 223; ++i) {
                BinaryWireCode.STRING_FOR_CODE[i] = "FIELD_" + i;
            }
            for (i = 224; i <= 255; ++i) {
                BinaryWireCode.STRING_FOR_CODE[i] = "STRING_" + i;
            }
            for (i = 0; i < STRING_FOR_CODE.length; ++i) {
                if (STRING_FOR_CODE[i] != null) continue;
                BinaryWireCode.STRING_FOR_CODE[i] = "Unknown_0x" + Integer.toHexString(i);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

