/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.websocket.jetty.JettyServletFactory;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WireIn;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyWebSocketServer {
    private final Server server = new Server();
    private final ServletContextHandler context;

    public JettyWebSocketServer(int port) {
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        this.context = new ServletContextHandler(1);
        this.context.setContextPath("/");
        this.server.setHandler((Handler)this.context);
    }

    public <T> void addServlet(String path, Function<MarshallableOut, T> outWrapper, BiConsumer<WireIn, T> channel) {
        ServletHolder holderEvents = new ServletHolder("ws-events", new JettyServletFactory<T>(outWrapper, channel));
        this.context.addServlet(holderEvents, path);
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public void close() throws IOException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

