/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.websocket.jetty.JettyWebSocketAdapter;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteValue;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketClient
implements MarshallableOut,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketClient.class);
    private final WebSocketClient client;
    private final JettyWebSocketAdapter<MarshallableOut> adapter;

    public JettyWebSocketClient(String uriString, BiConsumer<WireIn, MarshallableOut> parser) throws IOException {
        URI uri = URI.create(uriString);
        this.client = new WebSocketClient();
        try {
            this.client.start();
            this.adapter = new JettyWebSocketAdapter<MarshallableOut>(out -> out, parser);
            Future fut = this.client.connect(this.adapter, uri);
            Session session = (Session)fut.get();
            this.adapter.onWebSocketConnect(session);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void send(WireKey key, WriteValue value) {
        this.adapter.send(key, value);
    }

    public <T> void marshallable(T t, BiConsumer<ValueOut, T> writer) {
        this.adapter.marshallable((MarshallableOut)t, (BiConsumer<ValueOut, MarshallableOut>)writer);
    }

    public void close() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            LOGGER.info("Error on close of " + this.client, (Throwable)e);
        }
    }
}

