/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueModel;

class ValueBuilder {
    final ValueModel model;
    final String className;
    final TypeSpec.Builder typeBuilder;
    private FieldSpec unsafe;
    private CodeBlock.Builder staticBlockBuilder;
    private MethodSpec.Builder defaultConstructorBuilder;
    private FieldSpec bytesStoreForPointers;

    public ValueBuilder(ValueModel model, String className, TypeSpec.Builder typeBuilder) {
        this.model = model;
        this.className = className;
        this.typeBuilder = typeBuilder;
    }

    ClassName className() {
        return ClassName.get((String)this.model.valueType.getPackage().getName(), (String)this.className, (String[])new String[0]);
    }

    FieldSpec unsafe() {
        if (this.unsafe == null) {
            Class type = Utils.UNSAFE_CLASS;
            this.unsafe = FieldSpec.builder((Type)type, (String)"UNSAFE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).build();
            this.typeBuilder.addField(this.unsafe);
            this.staticBlockBuilder().beginControlFlow("try", new Object[0]).addStatement("$T theUnsafe = $T.getField($T.class, $S)", new Object[]{Field.class, Jvm.class, type, "theUnsafe"}).addStatement("$N = ($T) theUnsafe.get(null)", new Object[]{this.unsafe, type});
        }
        return this.unsafe;
    }

    CodeBlock.Builder staticBlockBuilder() {
        if (this.staticBlockBuilder == null) {
            this.staticBlockBuilder = CodeBlock.builder();
        }
        return this.staticBlockBuilder;
    }

    MethodSpec.Builder defaultConstructorBuilder() {
        if (this.defaultConstructorBuilder == null) {
            this.defaultConstructorBuilder = MethodSpec.constructorBuilder();
            this.defaultConstructorBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        return this.defaultConstructorBuilder;
    }

    void closeConstructorsAndInitializationBlocks() {
        if (this.staticBlockBuilder != null) {
            this.staticBlockBuilder.nextControlFlow("catch ($T e)", new Object[]{IllegalAccessException.class});
            this.staticBlockBuilder.addStatement("throw new $T(e)", new Object[]{AssertionError.class});
            this.staticBlockBuilder.endControlFlow();
            this.typeBuilder.addStaticBlock(this.staticBlockBuilder.build());
        }
        if (this.defaultConstructorBuilder != null) {
            this.typeBuilder.addMethod(this.defaultConstructorBuilder.build());
        }
    }

    FieldSpec bytesStoreForPointers() {
        if (this.bytesStoreForPointers == null) {
            this.bytesStoreForPointers = FieldSpec.builder((TypeName)TypeName.get(PointerBytesStore.class), (String)"bytesStoreForPointers", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{PointerBytesStore.class}).build();
            this.typeBuilder.addField(this.bytesStoreForPointers);
        }
        return this.bytesStoreForPointers;
    }
}

